<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>
    <uix:body>

      <uix:form name="updateJobs" method="POST" >
        <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:link textBinding="1@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="ruleMainPage@updateJobs@servletRequest"/>
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@updateJobs@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="ruleMainPage@updateJobs@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                           renderedBinding="showValErr@updateJobs@servletRequest">
            <uix:messageBox messageBinding="msg@updateJobs@servletRequest"
                            messageTypeBinding="msgType@updateJobs@servletRequest"
                            textBinding="valErrText@updateJobs@servletRequest">
              <uix:contents childDataBinding="valErrData@updateJobs@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@updateJobs@servletRequest" >
            <uix:header textBinding="createEditHeader@updateJobs@servletRequest" >

            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:pageButtonBar>
                    <uix:button textBinding="CANCEL@commonResourceBundle"
                                destination="ruleJobs" />
                    <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="doUpdateJobs"/>
                  </uix:pageButtonBar>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:spacer height="5" />

            <uix:header textBinding="JOBS@notifResourceBundle" >

              <uix:table name="updateJobs"
                         width="100%"
                         formSubmitted="true"
                         alternateTextBinding="NO_JOBS_SELECTED@notifResourceBundle"
                         summaryBinding="JOBS@notifResourceBundle"
                         tableDataBinding="jobsToUpdate@updateJobs@servletRequest" >

                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:column >
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="JOB_NAME@notifResourceBundle" />
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText textBinding="nameLabel@"
                                  shortDescBinding="JOB_NAME@notifResourceBundle" />
                  <uix:formValue name="job" valueBinding="value@" />
                </uix:column>

                <uix:column >
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="JOB_TYPE@notifResourceBundle" />
                   </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText textBinding="typeLabel@"
                                  shortDescBinding="JOB_TYPE@notifResourceBundle" />
                </uix:column>

                <uix:column >
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="JOB_OWNER@notifResourceBundle" />
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText textBinding="owner@"
                                  shortDescBinding="JOB_OWNER@notifResourceBundle" />
                </uix:column>

              </uix:table>
            
            </uix:header>

            <uix:spacer height="10" />
    
            <uix:header textBinding="JOB_STATUS@notifResourceBundle" >
              <uix:styledText textBinding="SELECT_JOB_STATUS@notifResourceBundle" 
                              styleClass="OraInstructionText"/>

              <uix:rowLayout>
                <uix:spacer height="5" />
              </uix:rowLayout>

              <uix:rowLayout rendered="true"
                             renderedBinding="singleJob@updateJobs@servletRequest" >
                <uix:spacer width="30" />
                <uix:checkBox name="scheduled" 
                              textBinding="JOB_SCHEDULED@notifResourceBundle" 
                              shortDescBinding="JOB_SCHEDULED@notifResourceBundle" 
                              checkedBinding="scheduled@updateJobs@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="started" 
                              textBinding="JOB_STARTED@notifResourceBundle" 
                              shortDescBinding="JOB_STARTED@notifResourceBundle" 
                              checkedBinding="started@updateJobs@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="suspended" 
                              textBinding="JOB_SUSPENDED@notifResourceBundle" 
                              shortDescBinding="JOB_SUSPENDED@notifResourceBundle" 
                              checkedBinding="suspended@updateJobs@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="succeeded" 
                              textBinding="JOB_SUCCEEDED@notifResourceBundle" 
                              shortDescBinding="JOB_SUCCEEDED@notifResourceBundle"
                              checkedBinding="succeeded@updateJobs@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="problem" 
                              textBinding="JOB_PROBLEM@notifResourceBundle" 
                              shortDescBinding="JOB_PROBLEM@notifResourceBundle"
                              checkedBinding="problem@updateJobs@servletRequest" 
                              value="true" />
              </uix:rowLayout>

            </uix:header>
    
            </uix:header>

          </uix:stackLayout>

          <uix:contentFooter>
            <uix:stackLayout rendered="true"
                             renderedBinding="showContents@updateJobs@servletRequest" >
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@commonResourceBundle"
                            destination="ruleJobs" />
                <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="doUpdateJobs"/>
              </uix:pageButtonBar>
            </uix:stackLayout>
          </uix:contentFooter>

        </uix:pageLayout>

      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
