<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<script language="javascript">
function setLovUrl(url)
{
  // alert(url);
  document.forms[0].lovUrl.value = url;
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <uix:form name="updateMetrics" method="POST" >
        <uix:pageLayout>

          <uix:formValue name="lovUrl"/>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:link textBinding="1@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="ruleMainPage@updateMetrics@servletRequest"/>
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@updateMetrics@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="ruleMainPage@updateMetrics@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                           renderedBinding="showValErr@updateMetrics@servletRequest">
            <uix:messageBox messageBinding="msg@updateMetrics@servletRequest"
                            messageTypeBinding="msgType@updateMetrics@servletRequest"
                            textBinding="valErrText@updateMetrics@servletRequest">
              <uix:contents childDataBinding="valErrData@updateMetrics@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@updateMetrics@servletRequest" >
            <uix:header textBinding="createEditHeader@updateMetrics@servletRequest" >

            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:pageButtonBar>
                    <uix:button textBinding="CANCEL@commonResourceBundle"
                                destination="ruleMetrics" />
                    <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="doUpdateMetrics"/>
                  </uix:pageButtonBar>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:spacer height="5" />

            <uix:header textBinding="METRICS@notifResourceBundle" >

              <uix:table name="updateMetrics"
                         width="100%"
                         formSubmitted="true"
                         alternateTextBinding="NO_METRICS_SELECTED@notifResourceBundle"
                         summaryBinding="METRICS@notifResourceBundle"
                         tableDataBinding="metricsToUpdate@updateMetrics@servletRequest" >

                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:column >
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="METRIC@notifResourceBundle" />
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:formValue name="metricID" 
                                 valueBinding="metricID@"  />
                  <uix:styledText textBinding="label@"
                                  shortDescBinding="METRIC@notifResourceBundle" />
                  <uix:formValue name="metric" valueBinding="value@" />
                  <uix:formValue name="origKeyVal" valueBinding="origKeyVal@" />
                </uix:column>

                <uix:column >
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="INDEXES@notifResourceBundle" />
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText rendered="true"
                                  renderedBinding="noKeyColumn@"
                                  textBinding="textNA@" />
                  <uix:stackLayout rendered="false"
                                   renderedBinding="hasKeyColumn@" >
                    <uix:radioButton name="keyValuesChoice"
                                     textBinding="keyColLabel@"
                                     shortDescBinding="keyColLabel@"
                                     value="all"
                                     selectedBinding="allSelected@" />
                    <uix:flowLayout>
                      <uix:radioButton name="keyValuesChoice"
                                       textBinding="SELECT@notifResourceBundle"
                                       shortDescBinding="SELECT@notifResourceBundle"
                                       selectedBinding="selectSelected@"
                                       value="select" />
                      <uix:lovField name="keyValuesField" 
                                    onClickBinding="onClickScript@"
                                    textBinding="keyValuesField@"
                                    columns="40"
                                    shortDescBinding="CLICK_TO_SELECT_OBJ@notifResourceBundle" 
                                    searchDescBinding="CLICK_TO_SELECT_OBJ@notifResourceBundle"/>
                    </uix:flowLayout>
                  </uix:stackLayout>
                </uix:column>

              </uix:table>

            </uix:header>

            <uix:spacer height="10" />
    
            <uix:header textBinding="SEVERITY_STATES@notifResourceBundle" >
              <uix:styledText textBinding="SEVERITY_STATES_MSG@notifResourceBundle" 
                              styleClass="OraInstructionText"/>

              <uix:rowLayout>
                <uix:spacer height="5" />
              </uix:rowLayout>

              <uix:rowLayout rendered="true"
                             renderedBinding="singleMetric@updateMetrics@servletRequest" >
                <uix:spacer width="30" />
                <uix:checkBox name="critical" 
                              textBinding="CRITICAL@notifResourceBundle" 
                              shortDescBinding="CRITICAL@notifResourceBundle" 
                              checkedBinding="critical@updateMetrics@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="warning" 
                              textBinding="WARNING@notifResourceBundle" 
                              shortDescBinding="WARNING@notifResourceBundle"
                              checkedBinding="warning@updateMetrics@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="clear" 
                              textBinding="CLEAR@notifResourceBundle" 
                              shortDescBinding="CLEAR@notifResourceBundle"
                              checkedBinding="clear@updateMetrics@servletRequest" 
                              value="true" />
              </uix:rowLayout>

            </uix:header>
    
            <uix:spacer height="10" />

            <uix:header textBinding="CORRECTIVE_ACTION@notifResourceBundle" >
              <uix:styledText textBinding="SELECT_METRIC_CA@notifResourceBundle" 
                              styleClass="OraInstructionText"/>

              <uix:rowLayout>
                <uix:spacer height="5" />
              </uix:rowLayout>

              <uix:labeledFieldLayout fieldWidth="70%" labelWidth="30%" 
                                      rendered="true" 
                                      renderedBinding="singleMetric@updateMetrics@servletRequest" >

                <uix:styledText textBinding="CORRECTIVE_ACTION_CRITICAL@notifResourceBundle" />

                <uix:rowLayout>
                  <uix:checkBox name="succeedOnCritical" 
                                textBinding="SUCCEEDED@notifResourceBundle" 
                                shortDescBinding="SUCCEEDED@notifResourceBundle" 
                                checkedBinding="succeedOnCritical@updateMetrics@servletRequest" 
                                value="true" />
                                          
                  <uix:spacer width="10" />
                  <uix:checkBox name="problemOnCritical" 
                                textBinding="PROBLEM@notifResourceBundle" 
                                shortDescBinding="PROBLEM@notifResourceBundle" 
                                checkedBinding="problemOnCritical@updateMetrics@servletRequest" 
                                value="true" />
                </uix:rowLayout>

                <uix:styledText textBinding="CORRECTIVE_ACTION_WARNING@notifResourceBundle" />

                <uix:rowLayout>
                  <uix:checkBox name="succeedOnWarning" 
                                textBinding="SUCCEEDED@notifResourceBundle" 
                                shortDescBinding="SUCCEEDED@notifResourceBundle" 
                                checkedBinding="succeedOnWarning@updateMetrics@servletRequest" 
                                value="true" />
                  <uix:spacer width="10" />
                  <uix:checkBox name="problemOnWarning" 
                                textBinding="PROBLEM@notifResourceBundle" 
                                shortDescBinding="PROBLEM@notifResourceBundle"
                                checkedBinding="problemOnWarning@updateMetrics@servletRequest" 
                                value="true" />
                </uix:rowLayout>

              </uix:labeledFieldLayout>

             </uix:header>
    
             </uix:header>

          </uix:stackLayout>

          <uix:contentFooter>
            <uix:stackLayout rendered="true"
                             renderedBinding="showContents@updateMetrics@servletRequest" >
              <uix:pageButtonBar>

                <uix:button textBinding="CANCEL@commonResourceBundle"
                            destination="ruleMetrics" />
                <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="doUpdateMetrics"/>

              </uix:pageButtonBar>
            </uix:stackLayout>
          </uix:contentFooter>

        </uix:pageLayout>

      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
