<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>
    <uix:body>

      <uix:form name="updatePolicies" method="POST" >
        <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:link textBinding="1@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="ruleMainPage@updatePolicies@servletRequest"/>
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@updatePolicies@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="ruleMainPage@updatePolicies@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                           renderedBinding="showValErr@updatePolicies@servletRequest">
            <uix:messageBox messageBinding="msg@updatePolicies@servletRequest"
                            messageTypeBinding="msgType@updatePolicies@servletRequest"
                            textBinding="valErrText@updatePolicies@servletRequest">
              <uix:contents childDataBinding="valErrData@updatePolicies@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@updatePolicies@servletRequest" >
            <uix:header textBinding="createEditHeader@updatePolicies@servletRequest" >

            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:pageButtonBar>
                    <uix:button textBinding="CANCEL@commonResourceBundle"
                                destination="rulePolicies" />
                    <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="doUpdatePolicies"/>
                  </uix:pageButtonBar>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            
            <uix:spacer height="5" />

            <uix:header textBinding="POLICIES@notifResourceBundle" >

              <uix:table name="updatePolicies"
                         width="100%"
                         formSubmitted="true"
                         alternateTextBinding="NO_POLICIES_SELECTED@notifResourceBundle"
                         summaryBinding="POLICY@notifResourceBundle"
                         tableDataBinding="policiesToUpdate@updatePolicies@servletRequest" >
                         
                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:column >
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="POLICY@notifResourceBundle" />
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText textBinding="label@"
                                  shortDescBinding="POLICY@notifResourceBundle" />
                  <uix:formValue name="policy" valueBinding="value@" />
                </uix:column>

                <uix:column >
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="CATEGORY@notifResourceBundle" />
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText textBinding="categoryLabel@"
                                  shortDescBinding="CATEGORY@notifResourceBundle" />
                  <uix:formValue name="categoryName" valueBinding="categoryName@" />
                </uix:column>

              </uix:table>

            </uix:header>

            <uix:spacer height="10" />
    
            <uix:header textBinding="SEVERITY_STATES@notifResourceBundle" >
              <uix:styledText textBinding="SEVERITY_STATES_MSG@notifResourceBundle" 
                              styleClass="OraInstructionText"/>

              <uix:rowLayout>
                <uix:spacer height="5" />
              </uix:rowLayout>

              <uix:rowLayout rendered="true"
                             renderedBinding="singlePolicy@updatePolicies@servletRequest" >
                <uix:spacer width="30" />
                <uix:checkBox name="violation" 
                              textBinding="VIOLATION@notifResourceBundle" 
                              shortDescBinding="VIOLATION@notifResourceBundle" 
                              checkedBinding="violation@updatePolicies@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="clear" 
                              textBinding="CLEAR@notifResourceBundle" 
                              shortDescBinding="CLEAR@notifResourceBundle" 
                              checkedBinding="clear@updatePolicies@servletRequest" 
                              value="true" />
              </uix:rowLayout>

            </uix:header>
    
            <uix:spacer height="10" />

            <uix:header textBinding="CORRECTIVE_ACTION@notifResourceBundle" >
              <uix:styledText textBinding="SELECT_POLICY_CA@notifResourceBundle" 
                              styleClass="OraInstructionText"/>

              <uix:rowLayout>
                <uix:spacer height="5" />
              </uix:rowLayout>

              <uix:rowLayout>
                    <uix:spacer width="30" />
                    <uix:checkBox name="succeedOnViolation" 
                                  textBinding="SUCCEEDED@notifResourceBundle" 
                                  shortDescBinding="SUCCEEDED@notifResourceBundle"
                                  checkedBinding="succeedOnViolation@updatePolicies@servletRequest" 
                                  value="true" />
                                          
                    <uix:spacer width="10" />
                    <uix:checkBox name="problemOnViolation" 
                                  textBinding="PROBLEM@notifResourceBundle" 
                                  shortDescBinding="PROBLEM@notifResourceBundle"
                                  checkedBinding="problemOnViolation@updatePolicies@servletRequest" 
                                  value="true" />
              </uix:rowLayout>

              </uix:header>
    
              </uix:header>

            </uix:stackLayout>

            <uix:contentFooter>
              <uix:stackLayout rendered="true"
                               renderedBinding="showContents@updatePolicies@servletRequest" >
                <uix:pageButtonBar>
                  <uix:button textBinding="CANCEL@commonResourceBundle"
                              destination="rulePolicies" />
                  <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                    unvalidated="true"
                                    name="event"
                                    value="doUpdatePolicies"/>
                </uix:pageButtonBar>
              </uix:stackLayout>
            </uix:contentFooter>

          </uix:pageLayout>

        </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
