<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>     
    
    <uix:body>
    <uix:form name="confirmForm" 
              method="POST">
      
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
  
          <uix:header messageType="confirmation" textBinding="CONFIRMATION@sdkUIBundle">
            <uix:stackLayout>
              <uix:rowLayout>
                <uix:spacer width="10"/>
                <uix:styledText styleClass="OraDataText" 
                                textBinding="questionText@renderDataKey@servletRequest" /> 
              </uix:rowLayout>     
              <uix:spacer height="5"/>             
              <uix:switcher childNameBinding="postQuestionText@renderDataKey@servletRequest">
                <uix:case name="" >
                </uix:case>
                
                <uix:default>
                  <uix:rowLayout> 
                    <uix:spacer width="10" />
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="postQuestionText@renderDataKey@servletRequest" />
                  </uix:rowLayout>                     
                </uix:default>                  
              </uix:switcher>
            </uix:stackLayout>    
          </uix:header>
  
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="NO@sdkUIBundle"
                                name="event"
                                value="cfm_no"/>
              <uix:submitButton textBinding="YES@sdkUIBundle" 
                                name="event"
                                value="cfm_yes"/>
            </uix:pageButtonBar>
          </uix:contentFooter>
  
      </uix:pageLayout>
    </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
