<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="progressPageBundle" 
              class="oracle.sysman.eml.rsc.page.prog.ProgressPageResourceBundle"
  />
  <uix:bundle name="sdkUIBundle" 
              class="oracle.sysman.emSDK.eml.SDKUIMsg" />             
              
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>    
    <%@ include file="/setRefreshRate.jspf" %>
    
    <uix:form nameBinding="formName@oracle.sysman.eml.page.prog.ppb@servletRequest"> 
      <uix:pageLayout titleBinding="pageHeader@oracle.sysman.eml.page.prog.ppb@servletRequest"
                      messageType="processing">
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="/sdk/page/pageMsgBox.jspf" %>
 
        <uix:flowLayout>
          <uix:spacer width="10" />
          <uix:styledText textBinding="primaryMessage@oracle.sysman.eml.page.prog.ppb@servletRequest"
                          styleClass="OraInstructionTextStrong" />
        </uix:flowLayout>
        
        <uix:spacer height="5"/>
        
        <uix:flowLayout>
          <uix:spacer width="10" />
          <uix:styledText styleClass="OraInstructionText" 
                          textBinding="secondaryMessage@oracle.sysman.eml.page.prog.ppb@servletRequest" />
        </uix:flowLayout>
        
        <uix:spacer height="10" /> 

        <uix:switcher childNameBinding="onlyOneStep@oracle.sysman.eml.page.prog.ppb@servletRequest">
          <uix:case name="true">
           <uix:processing timeIntervalBinding="refreshInterval@oracle.sysman.eml.page.prog.ppb@servletRequest">
                <uix:styledText styleClass="OraProcessingStatusFixed"
                                textBinding="description@oracle.sysman.eml.page.prog.ppb@servletRequest" />
           </uix:processing>
          </uix:case>
          
          <uix:case name="false">
            <uix:processing timeIntervalBinding="refreshInterval@oracle.sysman.eml.page.prog.ppb@servletRequest">
              <uix:tableLayout>
                <uix:contents childDataBinding="stepsData@oracle.sysman.eml.page.prog.ppb@servletRequest">
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <uix:image source="/em/images/processCheck.gif"
                                 renderedBinding="renderedSuccess" />
                      <uix:image source="/em/images/criticalind_status.gif"
                                 renderedBinding="renderedError" />
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:styledText styleClass="OraFieldText"
                                      textBinding="stepDescription" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:contents>
              </uix:tableLayout>
            </uix:processing>
          </uix:case>
        </uix:switcher>

        <uix:spacer height="10" />
       
        <%-- The cancel tip is shown if there is no return button and no 
             cancel button on the page. --%> 
        <uix:tip textBinding="CANCEL_TIP@progressPageBundle"
                 renderedBinding="showCancelTip@oracle.sysman.eml.page.prog.ppb@servletRequest" />

        <%-- The return tip is shown if there is a return button on the page, 
             but no cancel button. --%>
        <uix:tip textBinding="RETURN_TIP@progressPageBundle"
                 renderedBinding="showReturnTip@oracle.sysman.eml.page.prog.ppb@servletRequest" />

        <uix:contentFooter>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@sdkUIBundle"
                              name="event"
                              value="cancel"
                              renderedBinding="showCancelButton@oracle.sysman.eml.page.prog.ppb@servletRequest" 
            />
            <uix:submitButton textBinding="RETURN_BUTTON@progressPageBundle"
                              name="event"
                              value="return"
                              renderedBinding="showReturnButton@oracle.sysman.eml.page.prog.ppb@servletRequest"
            />
          </uix:pageButtonBar>
        </uix:contentFooter>
        
      </uix:pageLayout>
    </uix:form>
  </uix:document>
</uix:renderingContext>
