<%@ include file="/oemNoscript.jspf" %>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.host.admin.HostAdminConstants"%>

<jsp:useBean id="rfeDataBean"
             scope="request"
             type="oracle.sysman.eml.page.rfe.RfeDataBean"/>
<script>
 function loadMe()
 {
   //Focus in File Contents, if the file opened in Edit Mode 
   <%
     if((HostAdminConstants.FILE_OPENED.equals(rfeDataBean.getCurrentPage()))&&(!rfeDataBean.getIsViewMode())) {
   %>
       document.forms[0].fileContents.focus();
   <%
     } else if((HostAdminConstants.SAVE_A_COPY.equals(rfeDataBean.getCurrentPage())) ||
               (HostAdminConstants.SELECT_FILE.equals(rfeDataBean.getCurrentPage()))) {
   %>
       document.forms[0].fileName.focus();
   <%
     }
   %>
 }

 function myCallBack(lovWindow, event)
 {
   return true;
 }

 function launchRfs()
 {
   openWindow(top, '../rfs/postBackWithEvent$event=rfsLaunch', 'lovWindow', {width:750, height:550}, true, 'dialog', myCallBack);
 }

 var isNav = (navigator.appName.indexOf("Netscape") != -1);
 if(isNav)
 {
   document.captureEvents(Event.KEYPRESS);
   document.onkeypress = getKey;
 } 

 function getKey(keyStroke)
 {         
   key = (isNav) ? keyStroke.which : event.keyCode;
   if(key == "13")
   {
     <%
       if(HostAdminConstants.SELECT_FILE.equals(rfeDataBean.getCurrentPage())) {
     %>
       <%-- Submit the form with open event, if in Select File page --%>
       submitForm('remoteFileEditor', false, {event:'open'});
     <%
       } else if(HostAdminConstants.SAVE_A_COPY.equals(rfeDataBean.getCurrentPage())) {
     %>
       <%-- Submit the form with open event, if in Save a Copy page --%>
       submitForm('remoteFileEditor', false, {event:'okSaveACopy'});
     <%
       }
     %>
   }
 }

</script>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
 <uix:bundle name="hostAdminUIBundle" class="oracle.sysman.eml.rsc.host.admin.HostAdminMsg"/>
 <uix:bundle name="commResBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
 <uix:bundle name="mntrResBundle" class="oracle.sysman.resources.MntrResourceBundle"/>

 <uix:document>
  <%@ include file="/enablePPR.jspf" %>
 
  <uix:head titleBinding="pageTitle@rfeDataBean@servletRequest"/>
  <uix:body onLoad="loadMe();">
   <uix:form name="remoteFileEditor" method="POST">
    <uix:contents>
     <uix:formValue name="command"    valueBinding="cmdShell@rfeDataBean@servletRequest"/>
     <uix:formValue name="cacheKey" valueBinding="cacheKey@rfeDataBean@servletRequest"/>
     <uix:formValue name="rfeReturnUrl" valueBinding="rfeReturnUrl@rfeDataBean@servletRequest"/>
     <uix:formValue name="pageHeader" valueBinding="pageHeader@rfeDataBean@servletRequest"/>
    </uix:contents>
    <uix:pageLayout>
     <%@ include file="/oemGlobal.jspf" %>

     <uix:contentFooter>
      <uix:pageButtonBar><uix:contents>
       <uix:switcher childNameBinding="showRfePage@rfeDataBean@servletRequest">
        <uix:case name="true">
         <uix:switcher childNameBinding="currentPage@rfeDataBean@servletRequest">
          <uix:case name="selectFile">
           <uix:flowLayout>
            <uix:submitButton textBinding="CANCEL@commResBundle"
                              unvalidated="true"
                              name="event"
                              value="cancelSelectFile"/>
            <uix:spacer width="10" height="0"/>
            <uix:submitButton textBinding="CONTINUE@commResBundle"
                              unvalidated="true"
                              name="event"
                              value="open"/>
           </uix:flowLayout>
          </uix:case>
          <uix:case name="fileOpened">
           <uix:submitButton textBinding="OK@commResBundle"
                             unvalidated="true"
                             name="event"
                             value="close"/>
          </uix:case>
          <uix:case name="saveACopy">
           <uix:flowLayout>
            <uix:submitButton textBinding="CANCEL@commResBundle"
                              unvalidated="true"
                              name="event"
                              value="cancelSaveACopy"/>
            <uix:spacer width="10" height="0"/>
            <uix:submitButton textBinding="OK@commResBundle"
                              unvalidated="true"
                              name="event"
                              value="okSaveACopy"/>
           </uix:flowLayout>
          </uix:case>
          <uix:case name="confPage">
           <uix:flowLayout>
            <uix:submitButton textBinding="CANCEL@commResBundle"
                              unvalidated="true"
                              name="event"
                              value="cancelConfPage"/>
            <uix:spacer width="10" height="0"/>
            <uix:submitButton textBinding="NO@commResBundle"
                              unvalidated="true"
                              name="event"
                              value="noConfPage"/>
            <uix:spacer width="10" height="0"/>
            <uix:submitButton textBinding="YES@commResBundle"
                              unvalidated="true"
                              name="event"
                              value="yesConfPage"/>
           </uix:flowLayout>
          </uix:case>
          <uix:case name="confPageSaveACopy">
           <uix:flowLayout>
            <uix:submitButton textBinding="CANCEL@commResBundle"
                              unvalidated="true"
                              name="event"
                              value="cancelConfPageSaveACopy"/>
            <uix:spacer width="10" height="0"/>
            <uix:submitButton textBinding="NO@commResBundle"
                              unvalidated="true"
                              name="event"
                              value="noConfPageSaveACopy"/>
            <uix:spacer width="10" height="0"/>
            <uix:submitButton textBinding="YES@commResBundle"
                              unvalidated="true"
                              name="event"
                              value="yesConfPageSaveACopy"/>
           </uix:flowLayout>
          </uix:case>
         </uix:switcher>
        </uix:case>
        <uix:case name="false">
         <uix:button textBinding="OK@commResBundle"
                     destinationBinding="rfeReturnUrl@rfeDataBean@servletRequest"/>
        </uix:case>
       </uix:switcher>
      </uix:contents></uix:pageButtonBar>
     </uix:contentFooter>

     <uix:messageBox renderedBinding="rendered@msgBoxData@rfeDataBean@servletRequest"
                     textBinding="text@msgBoxData@rfeDataBean@servletRequest"
                     messageTypeBinding="messageType@msgBoxData@rfeDataBean@servletRequest"
                     messageBinding="message@msgBoxData@rfeDataBean@servletRequest">
      <uix:contents childDataBinding="linkList@msgBoxData@rfeDataBean@servletRequest">
       <uix:link textBinding="text"
                 destinationBinding="destination"
                 longDescBinding="longDesc"/>
      </uix:contents>
     </uix:messageBox>
     <uix:spacer width="0" height="5"/>

     <uix:switcher childNameBinding="showRfePage@rfeDataBean@servletRequest">
      <uix:case name="true">
       <uix:switcher childNameBinding="currentPage@rfeDataBean@servletRequest">
        <uix:case name="confPage">
         <uix:stackLayout>
          <uix:rowLayout width="100%">
           <uix:cellFormat width="3%" hAlign="left" vAlign="top" wrappingDisabled="true"><uix:contents>
            <uix:image source="/em/images/confirmation.gif"/>
           </uix:contents></uix:cellFormat>
           <uix:cellFormat width="97%" hAlign="left" vAlign="top" wrappingDisabled="true"><uix:contents>
            <uix:header textBinding="pageHeader@rfeDataBean@servletRequest"/>
           </uix:contents></uix:cellFormat>
          </uix:rowLayout>
          <uix:spacer width="0" height="5"/>
          <uix:styledText textBinding="confMessage@rfeDataBean@servletRequest" styleClass="OraDataText"/>
         </uix:stackLayout>
        </uix:case>
        <uix:case name="confPageSaveACopy">
         <uix:stackLayout>
          <uix:rowLayout width="100%">
           <uix:cellFormat width="3%" hAlign="left" vAlign="top" wrappingDisabled="true"><uix:contents>
            <uix:image source="/em/images/confirmation.gif"/>
           </uix:contents></uix:cellFormat>
           <uix:cellFormat width="97%" hAlign="left" vAlign="top" wrappingDisabled="true"><uix:contents>
            <uix:header textBinding="pageHeader@rfeDataBean@servletRequest"/>
           </uix:contents></uix:cellFormat>
          </uix:rowLayout>
          <uix:spacer width="0" height="5"/>
          <uix:styledText textBinding="confMessage@rfeDataBean@servletRequest" styleClass="OraDataText"/>
         </uix:stackLayout>
        </uix:case>
        <uix:default>
         <uix:tableLayout width="100%"><uix:contents>
          <uix:header textBinding="pageHeader@rfeDataBean@servletRequest"><uix:contents>
           <uix:tableLayout width="100%"><uix:contents>
            <uix:rowLayout width="100%"><uix:contents>
             <uix:cellFormat width="80%" hAlign="left" vAlign="top" wrappingDisabled="true"><uix:contents>
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="pageInstruction@rfeDataBean@servletRequest"/>
             </uix:contents></uix:cellFormat>
  
             <uix:cellFormat width="20%" hAlign="right" vAlign="top" wrappingDisabled="true"><uix:contents>
              <uix:pageButtonBar><uix:contents>
               <uix:switcher childNameBinding="currentPage@rfeDataBean@servletRequest">
                <uix:case name="selectFile">
                 <uix:flowLayout>
                  <uix:submitButton textBinding="CANCEL@commResBundle"
                                    unvalidated="true"
                                    name="event"
                                    value="cancelSelectFile"/>
                  <uix:spacer width="10" height="0"/>
                  <uix:submitButton textBinding="CONTINUE@commResBundle"
                                    unvalidated="true"
                                    name="event"
                                    value="open"/>
                 </uix:flowLayout>
                </uix:case>
                <uix:case name="fileOpened">
                 <uix:submitButton textBinding="OK@commResBundle"
                                   unvalidated="true"
                                   name="event"
                                   value="close"/>
                </uix:case>
                <uix:case name="saveACopy">
                 <uix:flowLayout>
                  <uix:submitButton textBinding="CANCEL@commResBundle"
                                    unvalidated="true"
                                    name="event"
                                    value="cancelSaveACopy"/>
                  <uix:spacer width="10" height="0"/>
                  <uix:submitButton textBinding="OK@commResBundle"
                                    unvalidated="true"
                                    name="event"
                                    value="okSaveACopy"/>
                 </uix:flowLayout>
                </uix:case>
               </uix:switcher>
              </uix:contents></uix:pageButtonBar>
             </uix:contents></uix:cellFormat>
            </uix:contents></uix:rowLayout>
  
            <uix:rowLayout width="100%"><uix:contents>
             <uix:spacer width="0" height="5"/>
            </uix:contents></uix:rowLayout>

            <uix:labeledFieldLayout labelWidthBinding="labelWidth@rfeDataBean@servletRequest" fieldWidthBinding="fieldWidth@rfeDataBean@servletRequest"><uix:contents>
             <uix:messageTextInput name="host"
                                   id="host"
                                   promptBinding="HOST@commResBundle" 
                                   textBinding="hostName@rfeDataBean@servletRequest"
                                   styleClass="OraDataText"
                                   readOnly="true"/>
             <uix:messageTextInput name="hostUser"
                                   id="hostUser"
                                   promptBinding="HOST_USER@hostAdminUIBundle" 
                                   textBinding="hostUser@rfeDataBean@servletRequest"
                                   styleClass="OraDataText"
                                   readOnly="true">
              <uix:end>
               <uix:switcher childNameBinding="showChangeUserButton@rfeDataBean@servletRequest">
                <uix:case name="true"> <%-- All times, except when file is open in view mode --%>
                 <uix:flowLayout>
                  <uix:spacer width="5" height="0"/>
                  <uix:submitButton textBinding="CHANGE@hostAdminUIBundle"
                                    unvalidated="true"
                                    name="event"
                                    value="switchUser"/>
                 </uix:flowLayout>
                </uix:case>
               </uix:switcher>
              </uix:end>
             </uix:messageTextInput>
             <uix:messageLovField name="fileName"
                                  promptBinding="FILE_NAME@hostAdminUIBundle"
                                  textBinding="fileName@rfeDataBean@servletRequest"
                                  searchDescBinding="fileNameShortDesc@rfeDataBean@servletRequest"
                                  shortDescBinding="FILE_NAME@hostAdminUIBundle"				  
                                  readOnlyBinding="isFileNameReadOnly@rfeDataBean@servletRequest"
                                  styleClassBinding="fileNameStyleClass@rfeDataBean@servletRequest"
                                  columns="75"
                                  id="fileName"
                                  onClick="launchRfs();"
                                  onKeyPress="getKey();">
              <uix:end>
               <uix:switcher childNameBinding="showChangeFileButton@rfeDataBean@servletRequest">
                <uix:case name="true"> <%-- File is open, except in view mode with a file name --%>
                 <uix:flowLayout><uix:contents>
                  <uix:spacer width="5" height="0"/>
                  <uix:submitButton textBinding="CHANGE@hostAdminUIBundle"
                                    unvalidated="true"
                                    name="event"
                                    value="changeFile"/>
                 </uix:contents></uix:flowLayout>
                </uix:case>
               </uix:switcher>
              </uix:end>
             </uix:messageLovField>

             <uix:switcher childNameBinding="currentPage@rfeDataBean@servletRequest">
              <uix:case name="saveACopy">
               <uix:messagePrompt promptBinding="RFE_CONTINUE_TO_EDIT@hostAdminUIBundle"/>
              </uix:case>
             </uix:switcher>
             <uix:switcher childNameBinding="currentPage@rfeDataBean@servletRequest">
              <uix:case name="saveACopy">
               <uix:flowLayout>
                <uix:radioButton name="contToEdit"
                                 textBinding="RFE_ORIGINAL_FILE@hostAdminUIBundle"
                                 value="ORIGINAL"
                                 selectedValueBinding="contToEdit@rfeDataBean@servletRequest"/>
                <uix:spacer width="5" height="0"/>
                <uix:radioButton name="contToEdit"
                                 textBinding="RFE_SAVED_FILE@hostAdminUIBundle"
                                 value="SAVED"
                                 selectedValueBinding="contToEdit@rfeDataBean@servletRequest"/>
               </uix:flowLayout>
              </uix:case>
             </uix:switcher>
            </uix:contents></uix:labeledFieldLayout>
 
            <uix:rowLayout width="100%"><uix:contents>
             <uix:cellFormat width="100%" hAlign="left" vAlign="top" wrappingDisabled="true"><uix:contents>
              <uix:tableLayout width="50%"><uix:contents>
               <uix:rowLayout width="100%"><uix:contents>
                <uix:cellFormat hAlign="left" wrappingDisabled="true"><uix:contents>
                 <uix:spacer width="0" height="5"/>
                </uix:contents></uix:cellFormat>
               </uix:contents></uix:rowLayout>
              </uix:contents></uix:tableLayout>
             </uix:contents></uix:cellFormat>
            </uix:contents></uix:rowLayout>
           </uix:contents></uix:tableLayout>
 
           <%-- File Contents --%>
           <%-- (when file is open in Edit Mode) or (when file is open in View Mode and is not empty) --%>
           <uix:switcher childNameBinding="showFileContents@rfeDataBean@servletRequest">
            <uix:case name="true">
             <uix:stackLayout>
              <uix:rowLayout width="100%"><uix:contents>
                <uix:separator/>
               </uix:contents></uix:rowLayout>
       
              <uix:header textBinding="FILE_CONTENTS@hostAdminUIBundle"><uix:contents>
               <uix:switcher childNameBinding="isViewMode@rfeDataBean@servletRequest">
                <uix:case name="false">
                 <uix:stackLayout>
                  <uix:tableLayout width="100%"><uix:contents>
                   <uix:rowLayout width="100%"><uix:contents>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true"><uix:contents>
                     <uix:flowLayout>
                      <uix:submitButton textBinding="REVERT_BUTTON@mntrResBundle"
                                        unvalidated="true"
                                        name="event"
                                        value="revert"/>
                      <uix:spacer width="5" height="0"/>
                      <uix:submitButton textBinding="RFE_SAVE_A_COPY@hostAdminUIBundle"
                                        unvalidated="true"
                                        name="event"
                                        value="saveACopy"/>
                      <uix:spacer width="5" height="0"/>
                      <uix:submitButton textBinding="SAVE_BUTTON@mntrResBundle"
                                        unvalidated="true"
                                        name="event"
                                        value="save"/>
                     </uix:flowLayout>
                    </uix:contents></uix:cellFormat>
                   </uix:contents></uix:rowLayout>
                   <uix:rowLayout width="100%"><uix:contents>
                    <uix:spacer width="0" height="5"/>
                   </uix:contents></uix:rowLayout>
                  </uix:contents></uix:tableLayout>
                  <uix:tableLayout width="100%"><uix:contents>
                   <uix:rowLayout width="100%"><uix:contents>
                    <uix:cellFormat wrappingDisabled="true"><uix:contents>
                     <uix:messageTextInput name="fileContents"
                                           id="fileContents"
                                           styleClass="OraInlineText"
                                           textBinding="fileContents@rfeDataBean@servletRequest"
                                           readOnlyBinding="isFileContentsReadOnly@rfeDataBean@servletRequest"
                                           rows="15"
                                           columns="110"
                                           shortDescBinding="FILE_CONTENTS@hostAdminUIBundle"/>
                    </uix:contents></uix:cellFormat>
                   </uix:contents></uix:rowLayout>
                  </uix:contents></uix:tableLayout>
                 </uix:stackLayout>
                </uix:case>
                <uix:case name="true">
                 <uix:stackLayout>
                  <uix:rawText text="<pre>"/>
                  <uix:text textBinding="fileContents@rfeDataBean@servletRequest"/>
                  <uix:rawText text="</pre>"/>
                 </uix:stackLayout>
                </uix:case>
               </uix:switcher>
              </uix:contents></uix:header>
             </uix:stackLayout>
            </uix:case>
           </uix:switcher>
          </uix:contents></uix:header>
         </uix:contents></uix:tableLayout>
        </uix:default>
       </uix:switcher>
      </uix:case>
     </uix:switcher>
    </uix:pageLayout>
   </uix:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>
