<%@ include file="/oemNoscript.jspf" %>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page   import="oracle.sysman.eml.host.admin.HostAdminConstants" %>

<jsp:useBean id="rfsBean"
             scope="request"
             type="oracle.sysman.eml.page.rfs.RfsBean"/>

<script language="javascript">
function loadMe()
{
  document.forms[0].searchPattern.focus();
}
function mySelect()
{
  //Create the table proxy object
  var proxy = new TableProxy("filesTable");

  //Get the selected index of a single-selection table
  var selectedIndex = proxy.getSelectedRow();

  //Return, if no row selected
  if(selectedIndex == -1)
  {
    top.close();
  }

  //Get the selected filename and current directory
  var fileName = proxy.getFormElement("fileName", selectedIndex);
  var curDir   = document.forms[0].curDir;

  //Get the LOV name in the parent page
  var lovName = document.forms[0].lovName.value;
  var dest;
  if(lovName != "")
  {
    dest = eval("window.opener.document.forms[0]." + lovName);
  } else 
  {
    dest = eval("window.opener.document.forms[0]." + "selFileName");
  }

  if(dest != null)
  {
    //Set the destination in the parent page
    //Windows root - My Computer
    if(curDir.value == "MC")
    {
      dest.value = fileName.value;
    } else
    {
      dest.value = curDir.value + fileName.value;
    }
  }

  //This is the event generated when Remote File Selector returns
  var retEvent = document.forms[0].retEvent.value;

  //If it has been indicated so while launching RFS page,
  //every calling page should handle his event.
  if(retEvent != "") 
  {
    //New form action for the parent form
    var newFormAction = window.opener.document.forms[0].action;

    if(newFormAction.indexOf("?") > 0) 
    {
      newFormAction = newFormAction + "&event=" + retEvent;
    } else 
    {
      newFormAction = newFormAction + "?event=" + retEvent;
    }

    //InterPageMessage containing updated RfsMsgBean object
    var ipMsgID = document.forms[0].intPageMsgID.value;
    if((ipMsgID != "")&&(newFormAction.indexOf("ipMsgID") < 0)) 
    {
      newFormAction = newFormAction + "&ipMsgID=" + ipMsgID;
    }

    //Submit the form in the parent window
    window.opener.document.forms[0].action = newFormAction;
    window.opener.document.forms[0].submit();
  }

  //Return
  top.close();
}
</script>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
 <uix:bundle name="commResBundle" class="oracle.sysman.resources.CommonResourceBundle" />
 <uix:bundle name="rfsUIBundle" class="oracle.sysman.eml.rsc.page.rfs.RfsMsg" />
 <uix:bundle name="hostAdminUIBundle" class="oracle.sysman.eml.rsc.host.admin.HostAdminMsg" />

 <uix:document>
  <%@ include file="/enablePPR.jspf" %>

  <uix:head titleBinding="pageTitle@rfsBean@servletRequest"/>

  <uix:body onLoad="loadMe();">
   <uix:form name="remoteFileSelector" method="POST">
    <uix:contents>
     <uix:formValue name="command" valueBinding="cmdShell@rfsBean@servletRequest"/>
     <uix:formValue name="curDir" valueBinding="curDir@rfsBean@servletRequest"/>
     <uix:formValue name="intPageMsgID" valueBinding="ipMsgID@rfsBean@servletRequest"/>
     <uix:formValue name="retEvent" valueBinding="retEvent@rfsBean@servletRequest"/>
     <uix:formValue name="lovName" valueBinding="lovName@rfsBean@servletRequest"/>
     <uix:formValue name="cacheKey" valueBinding="cacheKey@rfsBean@servletRequest"/>
     <uix:formValue name="tz" valueBinding="tz@rfsBean@servletRequest"/>
    </uix:contents>

    <uix:pageLayout>
     <%@ include file="/copyright.jspf" %>

     <uix:contentFooter>
      <uix:pageButtonBar><uix:contents>
       <uix:switcher childNameBinding="showRfsPage@rfsBean@servletRequest">
        <uix:case name="true">
         <uix:flowLayout><uix:contents>
          <uix:button textBinding="CANCEL@commResBundle"
                      onClick="top.close()"/>
          <uix:spacer width="10" height="0"/>
          <uix:button textBinding="SELECT@commResBundle"
                      onClick="mySelect();"/>
         </uix:contents></uix:flowLayout>
        </uix:case>
        <uix:case name="false">
         <uix:button textBinding="OK@commResBundle"
                     onClick="top.close()"/>
        </uix:case>
       </uix:switcher>
      </uix:contents></uix:pageButtonBar>
     </uix:contentFooter>

     <uix:messageBox renderedBinding="rendered@msgBoxData@rfsBean@servletRequest"
                     textBinding="text@msgBoxData@rfsBean@servletRequest"
                     messageTypeBinding="messageType@msgBoxData@rfsBean@servletRequest"
                     messageBinding="message@msgBoxData@rfsBean@servletRequest">
      <uix:contents childDataBinding="linkList@msgBoxData@rfsBean@servletRequest">
       <uix:link textBinding="text"
                 destinationBinding="destination"
                 longDescBinding="longDesc"/>
      </uix:contents>
     </uix:messageBox>

     <uix:switcher childNameBinding="showRfsPage@rfsBean@servletRequest">
      <uix:case name="true">
       <uix:header textBinding="header@rfsBean@servletRequest"><uix:contents>
  
        <uix:tableLayout width="100%"><uix:contents>
         <uix:rowLayout hAlign="right" vAlign="top"><uix:contents>
          <uix:cellFormat hAlign="left"><uix:contents>
           <uix:styledText styleClass="OraInstructionText"
                           textBinding="pageInstruction@rfsBean@servletRequest"/>
          </uix:contents></uix:cellFormat>
  
          <uix:cellFormat hAlign="right"><uix:contents>
           <uix:pageButtonBar><uix:contents>
            <uix:button textBinding="CANCEL@commResBundle"
                        onClick="top.close()"/>
  
            <uix:button textBinding="SELECT@commResBundle"
                        onClick="mySelect();"/>
           </uix:contents></uix:pageButtonBar>
          </uix:contents></uix:cellFormat>
         </uix:contents></uix:rowLayout>
        </uix:contents></uix:tableLayout>
  
        <uix:tableLayout width="100%"><uix:contents>
         <uix:switcher childNameBinding="showPrevDirs@rfsBean@servletRequest">
          <uix:case name="true">
           <uix:labeledFieldLayout labelWidth="10%"><uix:contents>
            <%-- Host --%>
            <uix:messagePrompt promptBinding="HOST@commResBundle"/>
            <uix:styledText textBinding="hostName@rfsBean@servletRequest" styleClass="OraDataText"/>
            <%-- User --%>
            <uix:styledText textBinding="HOST_USER@hostAdminUIBundle" styleClass="OraInstructionText"/>
            <uix:rowLayout><uix:contents> 
             <uix:styledText textBinding="loggedInAs@rfsBean@servletRequest" styleClass="OraDataText"/>
             <uix:spacer width="5" height="0"/>
             <uix:submitButton textBinding="SWITCH_USER@hostAdminUIBundle"
                               unvalidated="true"
                               name="event"
                               value="switchUser"/>
            </uix:contents></uix:rowLayout>
            <%-- Path --%>
            <uix:styledText styleClass="OraPromptText"
                            textBinding="PATH@rfsUIBundle"/>
            <uix:breadCrumbs><uix:contents childDataBinding="prevDirBCrumbData@rfsBean@servletRequest">
             <uix:link textBinding="text" destinationBinding="destination"/>
            </uix:contents></uix:breadCrumbs>
            <%-- Search --%>
            <uix:messagePrompt promptBinding="SEARCH@commResBundle" labeledNodeId="searchPattern"/>
            <uix:rowLayout><uix:contents> 
             <uix:textInput name="searchPattern"
                            styleClass="OraInlineText"
                            textBinding="searchPattern@rfsBean@servletRequest"
                            shortDescBinding="SEARCH@commResBundle"			    
                            columns="25"
                            id="searchPattern"/>
             <uix:spacer width="5" height="0"/>
             <uix:submitButton textBinding="GO@commResBundle"
                               unvalidated="true"
                               name="event"
                               value="search"/>
            </uix:contents></uix:rowLayout>
<%-- Commenting out as per UI Exit Review bug#4252679
            <uix:messagePrompt prompt=""/>
            <uix:styledText textBinding="SEARCH_TIP@rfsUIBundle" styleClass="OraInlineInfoText"/>
--%>
           </uix:contents></uix:labeledFieldLayout>
          </uix:case>
          <uix:case name="false">
           <uix:labeledFieldLayout labelWidth="10%"><uix:contents>
            <%-- Host --%>
            <uix:messagePrompt promptBinding="HOST@commResBundle"/>
            <uix:styledText textBinding="hostName@rfsBean@servletRequest" styleClass="OraDataText"/>
            <%-- User --%>
            <uix:styledText textBinding="HOST_USER@hostAdminUIBundle" styleClass="OraInstructionText"/>
            <uix:rowLayout><uix:contents> 
             <uix:styledText textBinding="loggedInAs@rfsBean@servletRequest" styleClass="OraDataText"/>
             <uix:spacer width="5" height="0"/>
             <uix:submitButton textBinding="SWITCH_USER@hostAdminUIBundle"
                               unvalidated="true"
                               name="event"
                               value="switchUser"/>
            </uix:contents></uix:rowLayout>
            <%-- Search --%>
            <uix:messagePrompt promptBinding="SEARCH@commResBundle"/>
            <uix:rowLayout><uix:contents> 
             <uix:textInput name="searchPattern"
                            styleClass="OraInlineText"
                            textBinding="searchPattern@rfsBean@servletRequest"
                            columns="25"
                            id="searchPattern"/>
             <uix:spacer width="5" height="0"/>
             <uix:submitButton textBinding="GO@commResBundle"
                               unvalidated="true"
                               name="event"
                               value="search"/>
            </uix:contents></uix:rowLayout>
           </uix:contents></uix:labeledFieldLayout>
          </uix:case>
         </uix:switcher>
        </uix:contents></uix:tableLayout>
   
        <uix:tableLayout width="100%"><uix:contents>
         <uix:rowLayout vAlign="top"><uix:contents> 
          <uix:cellFormat><uix:contents>
           <uix:spacer height="5" width="0"/>
           <uix:table tableDataBinding="filesTableData@rfsBean@servletRequest"
                      columnHeaderDataBinding="filesTableColumnData@rfsBean@servletRequest"
                      valueBinding="value@rfsBean@servletRequest"
                      blockSizeBinding="blockSize@rfsBean@servletRequest"
                      minValue="1"
                      maxValueBinding="maxValue@rfsBean@servletRequest"
                      id="filesTable"
                      proxied="true"
                      formSubmitted="true"
                      width="95%"
                      partialRenderMode="self"
                      showAll="yes"
                      alternateTextBinding="filesTableAlt@rfsBean@servletRequest"
                      summaryBinding="header@rfsBean@servletRequest">
  
            <uix:tableFormat tableBanding="rowBanding"/>
       
            <uix:columnHeaderStamp>
             <uix:sortableHeader textBinding="text"
                                 sortableBinding="sortable"/>
            </uix:columnHeaderStamp>
        
            <uix:tableSelection>
             <uix:singleSelection selectedIndex="0" disabledBinding="disabled" shortDescBinding="SELECT@commResBundle"/>
            </uix:tableSelection>
        
            <uix:contents>
             <uix:dataScope><uix:contents>
              <uix:image hAlign="left"
                         sourceBinding="fileTypeIcon"
                         shortDescBinding="fileTypeIconShortDesc"/>
  
  <%-- This was necessary in older labels, but doesn't seem to be required now. Still, keeping it for sometime.
              <uix:switcher childNameBinding="showSpacer">
               <uix:case name="yes">
                <uix:spacer width="10" height="0"/>
               </uix:case>
              </uix:switcher>
  --%>
  
              <uix:styledText textBinding="fileName"
                              destinationBinding="rfsDirDest"/>
             </uix:contents></uix:dataScope>
             <%
              if(HostAdminConstants.UNIX_OS_COMMAND.equals(rfsBean.getCmdShell()))
              {
             %>
              <uix:column>
               <uix:styledText textBinding="owner"/>
              </uix:column>
              <uix:column>
               <uix:styledText textBinding="group"/>
              </uix:column>
             <%
              }
             %>
             <uix:column>
              <uix:styledText textBinding="size"/>
              <uix:columnFormat columnDataFormat="numberFormat"/>
             </uix:column>
             <uix:column>
              <uix:styledText textBinding="lastModified" shortDescBinding="lastModifiedWithTZ"/>
             </uix:column>
             <uix:formValue name="fileName" valueBinding="fileName"/>
            </uix:contents>
           </uix:table>
        
          </uix:contents></uix:cellFormat>
         </uix:contents></uix:rowLayout>
        </uix:contents></uix:tableLayout>
       </uix:contents></uix:header>
      </uix:case>
     </uix:switcher>

    </uix:pageLayout>

   </uix:form>

  </uix:body>

 </uix:document>

</uix:renderingContext>
