<%--
  -- Page:        selectLOV.jsp
  -- Controller:  oracle.sysman.eml.page.lov.LovController
  --
  -- Description: Launched when user selects LOV action
  --
  --  MODIFIED    (MM/DD/YY)
  --  kchiasso    04/13/05 - close connection
  --  kchiasso    04/04/05 - add upper case
  --  kchiasso    02/28/05 - search on enter; init focus
  --  kchiasso    11/04/04 - set correct rb
  --  kchiasso    05/13/04 - stripped down version  
  --  chanchan    04/16/04 - Creation
  --
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.eml.page.lov.LovBean" %>
<script language="JavaScript" src="/em/cabo/jsLibs/TableProxy.js"></script> 
<script language="javascript">
function returnSelect()
{
    target = document.forms[0].<%=LovBean.ATTRIBUTE_TARGET_FIELD_NAME %>.value
    append = document.forms[0].<%=LovBean.ATTRIBUTE_APPEND_DATA %>.value
    lenName = "search:length";
    if ((document.forms[0][lenName] != null) && (target != null) && (target.length > 0))
    {
        selectItemValue=getSelectedItem();
        if (append == 1)
        {
            s=trim(window.opener.document.forms[0][target].value);
            separator = (s.length > 0) ? ", " : "";
            selectItemValue = s + separator + selectItemValue;
        }
        window.opener.document.forms[0][target].value = selectItemValue;
    }
    closeConn();
}

function closeConn()
{
    submitForm('pageForm', 1, {'event':'closeConn'});
    self.close();
}

function getSelectedItem()
{
    selectItemValue = "";
    proxy = new TableProxy('search');
    if (document.forms[0].selectMultiple.value != "1")
    {
        selectedIndex = proxy.getSelectedRow();
        if (selectedIndex >= 0)
        {
            selectItem = "search:selectValue:"+selectedIndex;
            selectItemValue = convertValue(document.forms[0][selectItem].value);
            if (selectItemValue == null)
                selectItemValue = "";
        }
    }
    else
    {
        selectItem = "search:length";
        len = document.forms[0][selectItem].value;
        selectedIndexes = proxy.getSelectedRows();
        selectItemValue = document.forms[0].<%= LovBean.ATTRIBUTE_SELECT_MULTIPLE_DATA %>.value;
        if (selectItemValue == null)
            selectItemValue = "";
        for (i=0; i < len; i++)
        {
            fieldSeparator = "<%= LovBean.FIELD_SEPARATOR %>";
            selectCheck = "search:selected:"+i;
            selectItem = "search:selectValue:"+i;
            sValue = convertValue(document.forms[0][selectItem].value);
            arrayOfStrings = selectItemValue.split(fieldSeparator);
            if (document.forms[0][selectCheck].checked)
            {
                if (selectItemValue != sValue)
                {
                    bNewItemChecked = true;
                    for (j=0; j < arrayOfStrings.length; j++)
                    {
                        if (arrayOfStrings[j] == sValue)
                        {
                            bNewItemChecked = false;
                            break;
                        }
                    }
                    if (bNewItemChecked)
                    {
                        separator = (selectItemValue.length > 0) ? fieldSeparator : "";
                        selectItemValue += separator + sValue;
                    }
                }
            }
            else if (selectItemValue.indexOf(sValue) >= 0)
            {
                if (selectItemValue == sValue)
                    selectItemValue = "";
                else
                {
                    separator = "";
                    selectItemValue = "";
                    for (j=0; j < arrayOfStrings.length; j++)
                    {
                        if (arrayOfStrings[j] != sValue)
                        {
                            selectItemValue += separator + arrayOfStrings[j];
                            separator = fieldSeparator;
                        }
                    }
                }
            }
        }
    }
    return selectItemValue;
}
function convertValue(sValue)
{
    if ((sValue != null) && (sValue != sValue.toUpperCase()) && (document.forms[
0].<%= LovBean.ATTRIBUTE_PRESERVE_CASE %>.value != "1"))
        sValue = '"' + sValue + '"';
    return sValue;
}
function updateData()
{
    if (document.forms[0].selectMultiple.value == "1")
    {
        document.forms[0].<%= LovBean.ATTRIBUTE_SELECT_MULTIPLE_DATA %>.value = getSelectedItem();
    }
}
function trim(sString)
{
    var lre = /^\s*/;
    var rre = /\s*$/;
    sString = sString.replace(lre, "");
    sString = sString.replace(rre, "");
    return sString;
}
function doSearchOnEnter(e,frm)
{
  var kc;
  if (window.event)
     kc=window.event.keyCode;
  else if (e)
     kc=e.which; 
  else return true;
  if (kc==13) 
  {
    submitForm('pageForm', 1, {'event':'changeSearchCriteria'});
    return false;
  }
}
</script>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="msg" class="oracle.sysman.eml.page.lov.util.LovMsg"/>
    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@lovBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoad="javascript:document.pageForm.filter0.focus();">


   <oem:form name="pageForm" method="post"
            destination="/console/page/selectLOV"
            copyParams="target" onSubmit="updateData()">

      <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:pageLayout titleBinding="header@lovBean@servletRequest">
        <uix:formValue name="pageName" value="/page/selectLOV"/>
        <uix:formValue name="<%= LovBean.LOV_IDENTIFIER %>" valueBinding="lovID@lovBean@servletRequest"/>
        <uix:formValue name="<%= LovBean.ATTRIBUTE_TARGET_FIELD_NAME %>" valueBinding="targetFieldName@lovBean@servletRequest"/>
        <uix:formValue name="<%= LovBean.ATTRIBUTE_APPEND_DATA %>" valueBinding="appendData@lovBean@servletRequest"/>
        <uix:formValue name="<%= LovBean.ATTRIBUTE_PRESERVE_CASE %>" valueBinding="preserveCase@lovBean@servletRequest"/>
        <uix:formValue name="<%= LovBean.ATTRIBUTE_SET_UPPER_CASE %>" valueBinding="convertToUpperCase@lovBean@servletRequest"/>
        <uix:formValue name="<%= LovBean.ATTRIBUTE_SELECT_MULTIPLE %>" valueBinding="selectMultiple@lovBean@servletRequest"/>
        <uix:formValue name="<%= LovBean.ATTRIBUTE_SELECT_MULTIPLE_DATA %>" valueBinding="selectMultipleData@lovBean@servletRequest"/>

        <uix:tableLayout cellSpacing="2" width="95%" >
            <%-- Search Criteria and Instruction --%>
            <uix:rowLayout>
	            <uix:stackLayout>
                  <uix:tableLayout cellPadding="3">
	                <uix:rowLayout renderedBinding="hasPreFilter0@lovBean@servletRequest">
                      <uix:cellFormat width="44">
                        <uix:spacer height="1" width="44"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right" vAlign="center">
                        <uix:messagePrompt promptBinding="labelPreFilter0@lovBean@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left" vAlign="center">
                        <uix:styledText styleClass="OraDataText" textBinding="preFilter0@lovBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
	                <uix:rowLayout renderedBinding="hasPreFilter1@lovBean@servletRequest">
                      <uix:cellFormat width="44">
                        <uix:spacer height="1" width="44"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right" vAlign="center">
                        <uix:messagePrompt promptBinding="labelPreFilter1@lovBean@servletRequest"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left" vAlign="center">
                        <uix:styledText styleClass="OraDataText" textBinding="preFilter1@lovBean@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
 
	              <uix:header textBinding="SEARCH@msg">
	                <uix:rowLayout>
                      <uix:styledText textBinding="bodyText@lovBean@servletRequest" styleClass="OraInstructionText" />
                    </uix:rowLayout>
                    <uix:tableLayout cellPadding="3">
	                  <uix:rowLayout renderedBinding="hasFilter0@lovBean@servletRequest">
                        <uix:cellFormat hAlign="right" vAlign="center">
                          <uix:messagePrompt promptBinding="labelFilter0@lovBean@servletRequest" labeledNodeId="filter0" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" vAlign="center">
                          <uix:textInput onKeyPress="doSearchOnEnter(event, this.form);" name="<%= LovBean.FILTER_0 %>" textBinding="filter0@lovBean@servletRequest" columns="30" id="filter0" shortDescBinding="labelFilter0@lovBean@servletRequest"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
	                  <uix:rowLayout renderedBinding="hasFilter1@lovBean@servletRequest">
                        <uix:cellFormat hAlign="right" vAlign="center">
                          <uix:messagePrompt promptBinding="labelFilter1@lovBean@servletRequest" labeledNodeId="filter1"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" vAlign="center">
                          <uix:textInput onKeyPress="doSearchOnEnter(event, this.form);" name="<%= LovBean.FILTER_1 %>" textBinding="filter1@lovBean@servletRequest" columns="30" id="filter1" shortDescBinding="labelFilter1@lovBean@servletRequest"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
	                  <uix:rowLayout renderedBinding="hasFilter2@lovBean@servletRequest">
                        <uix:cellFormat hAlign="right" vAlign="center">
                          <uix:messagePrompt promptBinding="labelFilter2@lovBean@servletRequest" labeledNodeId="filter2"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" vAlign="center">
                          <uix:textInput onKeyPress="doSearchOnEnter(event, this.form);" name="<%= LovBean.FILTER_2 %>" textBinding="filter2@lovBean@servletRequest" columns="30" id="filter2" shortDescBinding="labelFilter2@lovBean@servletRequest"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
	                  <uix:rowLayout>
                        <uix:cellFormat hAlign="right" vAlign="center">
                          <uix:styledText text=""/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" vAlign="center">
	                      <uix:submitButton textBinding="BUTTON_GO@msg" name="event" value="changeSearchCriteria" shortDescBinding="BUTTON_GO@msg" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>

              <uix:separator>
                <uix:spacer height="3"/>
              </uix:separator>
        
        <uix:table name="search"
                   width="100%"
                   formSubmitted="true"
                   columnFormatsBinding="columnFormat@lovBean@servletRequest"
                   tableDataBinding="tableData@lovBean@servletRequest"
                   blockSizeBinding="blockSize@lovBean@servletRequest"
                   maxValueBinding="length@lovBean@servletRequest"
                   valueBinding="startIndex@lovBean@servletRequest"
                   showAllBinding="showAll@lovBean@servletRequest"
                   alternateTextBinding="MSG_NO_ITEMS_FOUND@msg">
          <uix:tableFormat tableBanding="rowBanding"/>
          <uix:tableSelection>
             <uix:switcher childNameBinding="selectMultiple@lovBean@servletRequest">
               <uix:case name="0">
                 <uix:singleSelection selectedIndex="0" shortDescBinding="BUTTON_SELECT@msg"/>
               </uix:case>  
               <uix:case name="1">
                 <uix:multipleSelection  selectedBinding="isSelected@lovBean@servletRequest" shortDescBinding="BUTTON_SELECT@msg"/>
               </uix:case>
             </uix:switcher>
          </uix:tableSelection>
          <uix:column renderedBinding="hasColumn0@lovBean@servletRequest">
            <uix:columnHeader>
              <uix:sortableHeader textBinding="headerNameCol0@lovBean@servletRequest" sortableBinding="sortColumn0@lovBean@servletRequest" />
            </uix:columnHeader>
            <uix:contents>
              <uix:styledText textBinding="cellValueCol0@lovBean@servletRequest"/>
              <uix:formValue name="selectValue" valueBinding="selectValue@lovBean@servletRequest"/>
            </uix:contents>
          </uix:column>
          <uix:column renderedBinding="hasColumn1@lovBean@servletRequest">
            <uix:columnHeader>
              <uix:sortableHeader textBinding="headerNameCol1@lovBean@servletRequest" sortableBinding="sortColumn1@lovBean@servletRequest" />
            </uix:columnHeader>
            <uix:contents>
              <uix:styledText textBinding="cellValueCol1@lovBean@servletRequest"/>
            </uix:contents>
          </uix:column>
          <uix:column renderedBinding="hasColumn2@lovBean@servletRequest">
            <uix:columnHeader>
              <uix:sortableHeader textBinding="headerNameCol2@lovBean@servletRequest" sortableBinding="sortColumn2@lovBean@servletRequest" />
            </uix:columnHeader>
            <uix:contents>
              <uix:styledText textBinding="cellValueCol2@lovBean@servletRequest"/>
            </uix:contents>
          </uix:column>
          <uix:column renderedBinding="hasColumn3@lovBean@servletRequest">
            <uix:columnHeader>
              <uix:sortableHeader textBinding="headerNameCol3@lovBean@servletRequest" sortableBinding="sortColumn3@lovBean@servletRequest" />
            </uix:columnHeader>
            <uix:contents>
              <uix:styledText textBinding="cellValueCol3@lovBean@servletRequest"/>
            </uix:contents>
          </uix:column>
          <uix:column renderedBinding="hasColumn4@lovBean@servletRequest">
            <uix:columnHeader>
              <uix:sortableHeader textBinding="headerNameCol4@lovBean@servletRequest" sortableBinding="sortColumn4@lovBean@servletRequest" />
            </uix:columnHeader>
            <uix:contents>
              <uix:styledText textBinding="cellValueCol4@lovBean@servletRequest"/>
            </uix:contents>
          </uix:column>
          <uix:column renderedBinding="hasColumn5@lovBean@servletRequest">
            <uix:columnHeader>
              <uix:sortableHeader textBinding="headerNameCol5@lovBean@servletRequest" sortableBinding="sortColumn5@lovBean@servletRequest" />
            </uix:columnHeader>
            <uix:contents>
              <uix:styledText textBinding="cellValueCol5@lovBean@servletRequest"/>
            </uix:contents>
          </uix:column>
        </uix:table>

	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	      </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="BUTTON_CANCEL@msg" onClick="closeConn()"    shortDescBinding="BUTTON_CANCEL@msg"/>
            <uix:button textBinding="BUTTON_SELECT@msg" onClick="returnSelect()" shortDescBinding="BUTTON_SELECT@msg" />
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </oem:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>
