<%--
  - FILE
  -   admin.jsp
  -
  - DESCRIPTION
  -   Principal page for administration.
  -
  - MODIFIED   (MM/DD/YY)
    rattipal   12/04/05   - Backport gauragup_bugs1 from main 
    gauragup   11/11/05   - Adding nodestamp to hgrid 
    rattipal   12/05/05   - Backport gauragup_bugs1 from main 
    gauragup   11/11/05   - Adding nodestamp to hgrid 
    gauragup   07/15/05   - Fixing Table Accessibility Bug-adding Summary 
                            Attribute 
    makarapu   05/13/05   - adding alternateTextBinding
    ashwikum   04/27/05   - Adding view button to default image 
    ashwikum   04/10/05   - Changes in network config 
    ashwikum   04/21/05   - Fixing UI bugs 
    makarapu   03/15/05   - Support for Sofware Library Configuration 
  - ashwikum   02/28/05   - Support for network configuration 
  - ashwikum   02/01/05   - Preliminary UI review 
  - ashwikum   01/24/05   - add client action 
  - ashwikum   01/04/05   - Adding buttons to staging and default image table 
  - eworth     12/22/04   - Set hGrid id from data model 
  - ashwikum   12/22/04   - Adding button to enable edit of default image 
  - ashwikum   12/02/04   - ashwikum_provision_admin
  - ashwikum   11/23/04   - Making compatible with backend and improving layout
  - ashwikum   10/13/04   - Modifying/adding functionality 
  - ashwikum   09/29/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
  <%--To display the Timestamp--%>
  <%@ include file="/provision/timestamp.jspf" %>
</uix:buildTree>

<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:header textBinding="LBL_StagingHeader@localize@AdminData@servletRequest">
    <uix:contents>
      <uix:stackLayout>
        <uix:separator>
          <uix:spacer height="10" />
        </uix:separator>
        <uix:contents>
          <uix:styledText textBinding="MSG_NetworkStorageInstruction@localize@AdminData@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:hGrid id="stageConfigTable"
                     width="80%"
                     treeDataBinding="rootNode@resultSet@search@ProvisionContext@servletRequest"
                     columnHeaderDataBinding="columnHeaderData@search@ProvisionContext@servletRequest"
                     columnFormatsBinding="columnFormats@search@ProvisionContext@servletRequest"
                     summary="stageConfigTable">
            <uix:nodeStamp>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="nodeColumnHeader@search@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:styledText textBinding="text"/>
              </uix:column>
            </uix:nodeStamp>
            <uix:tableSelection>
              <uix:singleSelection selectedIndexBinding="selectedItemIndex@search@ProvisionContext@servletRequest"
              primaryClientActionBinding="clientAction@search@ProvisionContext@servletRequest">
                <uix:contents childDataBinding="selectionButtons@search@ProvisionContext@servletRequest">
                  <uix:submitButton textBinding="text"
                                    nameBinding="name"
                                    valueBinding="value"
                                    shortDescBinding="shortDesc"
                                    disabledBinding="disabled"/>
                </uix:contents>
              </uix:singleSelection> 
            </uix:tableSelection>
            <uix:tableActions>
              <uix:submitButton name="event" value="addStagingServer"
                                formNameBinding="formName@ProvisionContext@servletRequest"
                                textBinding="LBL_AddServerStage@localize@AdminData@servletRequest"
                                shortDescBinding="LBL_AddServerStageDesc@localize@AdminData@servletRequest"/>
            </uix:tableActions>
            <uix:columnHeaderStamp>
              <uix:text textBinding="text"/>
            </uix:columnHeaderStamp>
            <uix:contents>
              <uix:text textBinding="sizeLimit"/>
              <uix:text textBinding="currentSize" />
              <uix:text textBinding="baseURL" />
            </uix:contents> 
          </uix:hGrid>
        </uix:contents>
      </uix:stackLayout>
    </uix:contents>
  </uix:header>

  <uix:header textBinding="LBL_RpmReposHeader@localize@AdminData@servletRequest">
    <uix:contents>
      <uix:stackLayout>
        <uix:separator>
          <uix:spacer height="10" />
        </uix:separator>
        <uix:contents>
          <uix:styledText textBinding="MSG_RpmReposInstruction@localize@AdminData@servletRequest"
                          styleClass="OraInstructionText" />
          <uix:table name="RpmReposTable" 
                     width="80%"
                     formSubmitted="true"
                     tableDataBinding="tableRpmRepos@AdminData@servletRequest"
                     alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
                     summary="Rpm Repository Table">

            <uix:tableSelection>
              <uix:singleSelection  selectedIndexBinding="indexRpmRepos@AdminData@servletRequest"
                                    disabledBinding="disabledRpmRepos@AdminData@servletRequest">
                <uix:contents>
                  <uix:submitButton name="event" value="editRpm"
                                    textBinding="EDIT@commonResourceBundle"
                                    shortDescBinding="LBL_EditRpmDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/> 
                  <uix:submitButton name="event" value="removeRpm" 
                                    textBinding="REMOVE@commonResourceBundle"
                                    shortDescBinding="LBL_RemoveRpmDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/>
                </uix:contents>
              </uix:singleSelection> 
            </uix:tableSelection>
            <uix:tableActions>
              <uix:submitButton name="event" value="addRowsRpmReposTable"
                                formNameBinding="formName@ProvisionContext@servletRequest"
                                textBinding="ADD@commonResourceBundle"
                                shortDescBinding="LBL_AddRpmDesc@localize@AdminData@servletRequest"/>
            </uix:tableActions>
            <uix:contents>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_ReposName@localize@AdminData@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="reposname" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_DirPath@localize@AdminData@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="dirpath" />
                </uix:contents>
              </uix:column>
            </uix:contents>
          </uix:table> 
        </uix:contents>
      </uix:stackLayout>
    </uix:contents>
  </uix:header>


  <uix:header textBinding="LBL_BootServerHeader@localize@AdminData@servletRequest">
    <uix:contents>
      <uix:stackLayout>
        <uix:separator>
          <uix:spacer height="10" />
        </uix:separator>
        <uix:contents>
          <uix:styledText textBinding="MSG_BootServerInstruction@localize@AdminData@servletRequest"
                          styleClass="OraInstructionText" />
          <uix:table name="BootServerTable" 
                     width="80%"
                     formSubmitted="true"
                     tableDataBinding="tableBootSrvr@AdminData@servletRequest"
                     alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
                     summary="Boot Server Table">
            <uix:tableSelection>
              <uix:singleSelection  selectedIndexBinding="indexBootSrvr@AdminData@servletRequest"
                                    disabledBinding="disabledBootSrvr@AdminData@servletRequest">
                <uix:contents>
                  <uix:submitButton name="event" value="editBoot"
                                    textBinding="EDIT@commonResourceBundle"
                                    shortDescBinding="LBL_EditBootDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/> 
                  <uix:submitButton name="event" value="removeBoot" 
                                    textBinding="REMOVE@commonResourceBundle"
                                    shortDescBinding="LBL_RemoveBootDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/>
                </uix:contents>
              </uix:singleSelection> 
            </uix:tableSelection>
            <uix:tableActions>
              <uix:submitButton name="event" value="addRowsBootServerTable"
                                formNameBinding="formName@ProvisionContext@servletRequest"
                                textBinding="ADD@commonResourceBundle"
                                shortDescBinding="LBL_AddBootDesc@localize@AdminData@servletRequest"/>
            </uix:tableActions>
            <uix:contents>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_TFTPServerName@localize@AdminData@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="hostname" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_BootConfigDir@localize@AdminData@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="dir" />
                </uix:contents>
              </uix:column>
            </uix:contents>
          </uix:table> 
        </uix:contents>
      </uix:stackLayout>
    </uix:contents>
  </uix:header>

  <uix:header textBinding="LBL_DefaultImagesHeader@localize@AdminData@servletRequest">
    <uix:contents>
      <uix:stackLayout>
        <uix:separator>
          <uix:spacer height="10" />
        </uix:separator>
        <uix:contents>
          <uix:styledText textBinding="MSG_ImagesInstruction@localize@AdminData@servletRequest"
                          styleClass="OraInstructionText" />
          <uix:table name="DefaultImageTable" 
                     width="80%"
                     tableDataBinding="tableDefaultImage@AdminData@servletRequest"
                     alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
                     summary="Default Image Table">
            <uix:tableSelection>
              <uix:singleSelection selectedIndexBinding="indexDefaultImage@AdminData@servletRequest"
                                   disabledBinding="disabledDefaultImage@AdminData@servletRequest">
                <uix:contents>
                  <uix:submitButton name="event" value="viewImage"
                                    textBinding="VIEW@commonResourceBundle"
                                    shortDescBinding="LBL_ViewImageDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/>
                  <uix:submitButton name="event" value="editImage"
                                    textBinding="EDIT@commonResourceBundle"
                                    shortDescBinding="LBL_EditImageDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/>
                  <uix:submitButton name="event" value="editImageConfig"
                                    textBinding="LBL_EditImageConfig@localize@AdminData@servletRequest"
                                    shortDescBinding="LBL_EditImageConfigDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/> 
                  <uix:submitButton name="event" value="removeImage"
                                    textBinding="REMOVE@commonResourceBundle"
                                    shortDescBinding="LBL_RemoveImageDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/>
                  <uix:submitButton name="event" value="stageImage"
                                    textBinding="LBL_Stage@localize@AdminData@servletRequest"
                                    shortDescBinding="LBL_StageImageDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/>
                </uix:contents>
              </uix:singleSelection>
            </uix:tableSelection>
            <uix:tableActions>
              <uix:submitButton name="event" value="addRowsDefaultImageTable"
                                formNameBinding="formName@ProvisionContext@servletRequest"
                                textBinding="ADD@commonResourceBundle" 
                                shortDescBinding="LBL_AddImageDesc@localize@AdminData@servletRequest"/>
            </uix:tableActions>
            <uix:contents>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IPAddrPrefix@localize@AdminData@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="addr" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_DefaultImage@localize@AdminData@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="image" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="STATUS@commonResourceBundle"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="status" />
                </uix:contents>
              </uix:column> 
            </uix:contents>
          </uix:table> 
        </uix:contents>
      </uix:stackLayout>
    </uix:contents>
  </uix:header>

  <uix:header textBinding="LBL_NetConfigHeader@localize@AdminData@servletRequest">
    <uix:contents>
      <uix:stackLayout>
        <uix:separator>
          <uix:spacer height="10" />
        </uix:separator>
        <uix:contents>
          <uix:styledText textBinding="MSG_NetConfigInstruction@localize@AdminData@servletRequest"
                          styleClass="OraInstructionText" />
          <uix:table name="NetConfigTable" 
                     width="80%"
                     formSubmitted="true"
                     tableDataBinding="tableNetConfig@AdminData@servletRequest"
                     alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
                     summary="Network Configuration Table">
            <uix:tableSelection>
              <uix:singleSelection  selectedIndexBinding="indexNetConfig@AdminData@servletRequest"
                                    disabledBinding="disabledNetConfig@AdminData@servletRequest">
                <uix:contents>
                  <uix:submitButton name="event" value="viewNetConfig"
                                    textBinding="VIEW@commonResourceBundle"
                                    shortDescBinding="LBL_ViewNetConfigDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/> 
                  <uix:submitButton name="event" value="editNetConfig"
                                    textBinding="EDIT@commonResourceBundle"
                                    shortDescBinding="LBL_EditNetConfigDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/> 
                  <uix:submitButton name="event" value="removeNetConfig" 
                                    textBinding="REMOVE@commonResourceBundle"
                                    shortDescBinding="LBL_RemoveNetConfigDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/>
                </uix:contents>
              </uix:singleSelection> 
            </uix:tableSelection>
            <uix:tableActions>
              <uix:submitButton name="event" value="addRowsNetConfigTable"
                                formNameBinding="formName@ProvisionContext@servletRequest"
                                textBinding="ADD@commonResourceBundle"
                                shortDescBinding="LBL_AddNetConfigDesc@localize@AdminData@servletRequest"/>
            </uix:tableActions>
            <uix:contents>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_NetConfigName@localize@AdminData@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="netConfigName" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_NetConfigDomain@localize@AdminData@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="netDomainName" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_NetSubnetMask@localize@AdminData@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="netSubnetMask" />
                </uix:contents>
              </uix:column>
            </uix:contents>
          </uix:table> 
        </uix:contents>
      </uix:stackLayout>
    </uix:contents>
  </uix:header>


  <uix:header textBinding="LBL_SoftwareLibHeader@localize@AdminData@servletRequest">
    <uix:contents>
      <uix:stackLayout>
        <uix:separator>
          <uix:spacer height="10" />
        </uix:separator>
        <uix:contents>
          <uix:styledText textBinding="MSG_SoftwareLibInstruction@localize@AdminData@servletRequest"
                          styleClass="OraInstructionText" />
          <uix:table name="SoftwareLibDirLocTable" 
                     width="80%"
                     formSubmitted="true"
                     tableDataBinding="tableSoftwareLib@AdminData@servletRequest"
                     alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
                     summary="Software Library Directory Location Table">
            <uix:tableSelection>
              <uix:singleSelection  selectedIndexBinding="indexSoftwareLib@AdminData@servletRequest"
                                    disabledBinding="disabledSoftwareLib@AdminData@servletRequest">
                <uix:contents>
                  <uix:submitButton name="event" value="editSoftwareLibDir"
                                    textBinding="EDIT@commonResourceBundle"
                                    shortDescBinding="LBL_EditSoftwareLibDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/> 
                  <uix:submitButton name="event" value="removeSoftwareLibDir" 
                                    textBinding="REMOVE@commonResourceBundle"
                                    shortDescBinding="LBL_RemoveSoftwareLibDesc@localize@AdminData@servletRequest"
                                    formNameBinding="formName@ProvisionContext@servletRequest"/>
                </uix:contents>
              </uix:singleSelection> 
            </uix:tableSelection>
            <uix:tableActions>
              <uix:submitButton name="event" value="addRowsSoftwareLibDirTable"
                                id="_addLoc"
                                formNameBinding="formName@ProvisionContext@servletRequest"
                                textBinding="ADD@commonResourceBundle"
                                shortDescBinding="LBL_AddSoftwareLibDesc@localize@AdminData@servletRequest"/>
            </uix:tableActions>
            <uix:contents>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_SoftwareLibDir@localize@AdminData@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="dir" />
                </uix:contents>
              </uix:column>
            </uix:contents>
          </uix:table> 
        </uix:contents>
      </uix:stackLayout>
    </uix:contents>
  </uix:header>


</uix:buildTree>
<%@ include file="/provision/subtabTemplate.jspf" %>

