<%--
  - FILE
  -   edit_boot_server_configuration.jsp
  -
  - DESCRIPTION
  -   Principal page for managing boot server configuration. 
  -
  - MODIFIED   (MM/DD/YY)
  - rattipal   12/12/05   - Backport kashukla_help_pages from main 
  - kashukla   12/06/05   - changing boot server install directory prompt 
  - ashwikum   06/20/05   - Chooser for host 
  - ashwikum   04/21/05   - Fixing UI bugs 
  - ashwikum   02/01/05   - Preliminary UI review 
  - ashwikum   12/08/04   - Updating to use Ctx object instead of directly 
  -                         accessing servletRequest 
  - ashwikum   12/02/04   - ashwikum_provision_admin
  - ashwikum   10/15/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
  <%--To display the Timestamp--%>
  <%@ include file="/provision/timestamp.jspf" %>
</uix:buildTree>

<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:switcher childNameBinding="purpose@levelOnePage@ProvisionContext@servletRequest">

    <uix:case name="add">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrAddBootServer@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="10"/>
          <uix:labeledFieldLayout>
            <uix:contents>
              <uix:messageTextInput name="TFTPServerHostname"
                                    promptBinding="LBL_EntryTFTPHostname@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="hostname@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    disabled="true"
                                    columns="40"/>
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <oem:targetSelection textBinding="SELECT@commonResourceBundle"
                                       event="initializeBootServerSelection"/>
                </uix:contents>
              </uix:messageLayout>
              <uix:spacer height="8"/>
              <uix:spacer height="8"/>
              <uix:messageTextInput name="BootConfigDir"
                                    promptBinding="LBL_EntryBootDir@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="dir@levelOnePage@ProvisionContext@servletRequest"
                                    disabledBinding="dirDisable@levelOnePage@ProvisionContext@servletRequest"
                                    shortDescBinding="LBL_EntryBootDirShortDesc@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <uix:button textBinding="SELECT@commonResourceBundle"
                              disabledBinding="dirDisable@levelOnePage@ProvisionContext@servletRequest"
                              onClick="launchRfs();"/>
                </uix:contents>
              </uix:messageLayout>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

    <uix:case name="remove">
      <uix:tableLayout width="100%">
        <uix:contents>
          <uix:rowLayout>
            <uix:contents>
              <uix:styledText textBinding="LBL_InstrRemoveBootServer@levelOnePage@ProvisionContext@servletRequest"
                              styleClass="OraInstructionTextStrong"/>
            </uix:contents>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:contents>
              <uix:spacer height="15" />
            </uix:contents>
          </uix:rowLayout>
        </uix:contents>
      </uix:tableLayout>
    </uix:case>

    <uix:case name="edit">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrEditBootServer@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="10"/>
          <uix:labeledFieldLayout>
            <uix:contents>
              <uix:messageTextInput name="TFTPServerHostname"
                                    promptBinding="LBL_EntryTFTPHostname@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="hostname@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    disabled="true"
                                    columns="40"/>
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <oem:targetSelection textBinding="SELECT@commonResourceBundle"
                                       event="initializeBootServerSelection"/>
                </uix:contents>
              </uix:messageLayout>
              <uix:spacer height="8"/>
              <uix:spacer height="8"/>
              <uix:messageTextInput name="BootConfigDir"
                                    promptBinding="LBL_EntryBootDir@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="dir@levelOnePage@ProvisionContext@servletRequest"
                                    shortDescBinding="LBL_EntryBootDirShortDesc@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    disabledBinding="dirDisable@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <uix:button textBinding="SELECT@commonResourceBundle"
                              disabledBinding="dirDisable@levelOnePage@ProvisionContext@servletRequest"
                              onClick="launchRfs();"/>
                </uix:contents>
              </uix:messageLayout>
              <uix:spacer height="8"/>
              <uix:spacer height="8"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

  </uix:switcher>

  <script>
  
    function myCallBack(lovWindow, event)
    {
        return true;
    }
    
    function launchRfs()
    {
        openWindow(top, '../../page/rfs/postBackWithEvent$event=handleRfsLaunch', 'lovWindow', {width:750, height:550}, true, 'dialog', myCallBack);
    }
  </script>

</uix:buildTree>
<%@ include file="/provision/editorTemplate.jspf" %>
