<%--
  - FILE
  -   edit_default_image_configuration.jsp
  -
  - DESCRIPTION
  -   Page for handling default images to be provisioned.
  -
  - MODIFIED   (MM/DD/YY)
  - rattipal   12/12/05   - Backport kashukla_help_pages from main 
  - kashukla   12/06/05   - adding tooltip mesg 
  - kashukla   10/03/05   - disabling the override credientials selection 
  - jhazra     09/01/05   - turnoff autocomplete for passwd fields 
  - ashwikum   05/20/05   - Staging credentials 
  - ashwikum   04/26/05   - Fixing Bugs 
  - ashwikum   02/01/05   - Preliminary UI review 
  - ashwikum   01/05/05   - Highlighting boot server entry if present 
  - ashwikum   12/22/04   - Revamp of UI as default image should have its own 
  -                         edit/add page 
  - ashwikum   12/08/04   - Updating to use Ctx object instead of directly 
  -                         accessing servletRequest 
  - ashwikum   12/02/04   - ashwikum_provision_admin
  - ashwikum   11/22/04   - adding functionality
  - ashwikum   10/18/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
  <%--To display the Timestamp--%>
  <%@ include file="/provision/timestamp.jspf" %>
</uix:buildTree>

<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:switcher childNameBinding="purpose@levelOnePage@ProvisionContext@servletRequest">

    <uix:case name="add">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrAddDefaultImage@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="10" />
          <uix:labeledFieldLayout>
            <uix:contents>
              <uix:messageTextInput name="IPAddrPrefix"
                promptBinding="LBL_EntryIPAddrPrefix@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                shortDescBinding="LBL_IPAddrPrefixTip@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                textBinding="addr@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                columns="30"/>
              <uix:include nodeBinding="BootServerDataList@BootServer@DefImageData@levelOnePage@ProvisionContext@servletRequest"/>
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:include nodeBinding="StagingStorageDataList@StagingStorage@DefImageData@levelOnePage@ProvisionContext@servletRequest"/>
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:messageTextInput name="NetworkProfile"
                   promptBinding="LBL_Network@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                   textBinding="networkProfile@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                   disabled="true"
                   columns = "30" />
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <uix:submitButton name="event" value="NetworkDestination"
                                    textBinding="SELECT@commonResourceBundle"
                                    shortDescBinding="LBL_SelectNetwForImgDesc@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    formNameBinding="formName@levelOnePage@ProvisionContext@servletRequest" />
                </uix:contents>
              </uix:messageLayout>
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:messageTextInput name="ImageProfile"
                          promptBinding="LBL_Image@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          textBinding="imageProfile@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                          disabled="true"
                          columns= "30" />
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <uix:submitButton name="event" value="ImageDestination"
                                    textBinding="SELECT@commonResourceBundle"
                                    shortDescBinding="LBL_SelectImgForImgDesc@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    formNameBinding="formName@levelOnePage@ProvisionContext@servletRequest" />
                </uix:contents>
              </uix:messageLayout>
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:messageLayout promptBinding="LBL_StagingCredentials@localize@AdminData@levelOnePage@ProvisionContext@servletRequest">
                <uix:contents>
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:messageRadioButton name="Credential"
                          value="PrefCredential"
                          textBinding="LBL_UsePrefCredential@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          selectedBinding="PrefCredential@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                          onClickBinding="PrefCredentialOnclick@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                      />
                      <uix:cellFormat>
                        <uix:radioButton name="Credential"
                          value="OverrideCredential"
                          textBinding="LBL_OverridePrefCredential@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          selectedBinding="OverrideCredential@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                          onClickBinding="OverrideCredentialOnclick@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                          disabled="true"
                        />
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:contents>
              </uix:messageLayout>
              <uix:messageTextInput
                  promptBinding="LBL_StagingUsername@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                  renderedBinding="OverrideCredential@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                  name="stagingUsername"
                  columns="15"
                  noAutoComplete="true"
                  textBinding="stagingUsername@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                  />
              <uix:messageTextInput
                  renderedBinding="OverrideCredential@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                  promptBinding="LBL_StagingPassword@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                  name="stagingPassword"
                  columns="15"
                  secret="true"
                  noAutoComplete="true"
                  textBinding="stagingPassword@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                  />
              <uix:messageTextInput 
                  renderedBinding="OverrideCredential@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                  promptBinding="LBL_StagingPasswordConf@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                  name="stagingPasswordConfirm"
                  columns="15"
                  secret="true"
                  noAutoComplete="true"
                  textBinding="stagingPasswordConfirm@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                  />
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

    <uix:case name="edit">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrEditDefaultImage@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="10" />
          <uix:labeledFieldLayout>
            <uix:contents>
              <uix:messageTextInput name="IPAddrPrefix"
                        promptBinding="LBL_EntryIPAddrPrefix@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="addr@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                        columns="30"
                        readOnly = "true"/>
              <uix:include nodeBinding="BootServerDataList@BootServer@DefImageData@levelOnePage@ProvisionContext@servletRequest"/>
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:include nodeBinding="StagingStorageDataList@StagingStorage@DefImageData@levelOnePage@ProvisionContext@servletRequest"/>
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:messageTextInput name="NetworkProfile"
                                promptBinding="LBL_Network@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                textBinding="networkProfile@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                                columns="30" 
                                disabled="true" />
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <uix:submitButton name="event" value="NetworkDestination"
                                    textBinding="SELECT@commonResourceBundle"
                                    shortDescBinding="LBL_SelectNetwForImgDesc@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    formNameBinding="formName@levelOnePage@ProvisionContext@servletRequest"
                                    />
                </uix:contents>
              </uix:messageLayout>
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:messageTextInput name="ImageProfile"
                          promptBinding="LBL_Image@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          textBinding="imageProfile@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                          columns="30"
                          readOnly="true" />
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:messageLayout promptBinding="LBL_StagingCredentials@localize@AdminData@levelOnePage@ProvisionContext@servletRequest">
                <uix:contents>
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:messageRadioButton name="Credential"
                          value="PrefCredential"
                          textBinding="LBL_UsePrefCredential@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          selectedBinding="PrefCredential@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                          onClickBinding="PrefCredentialOnclick@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                      />
                      <uix:cellFormat>
                        <uix:radioButton name="Credential"
                          value="OverrideCredential"
                          textBinding="LBL_OverridePrefCredential@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          selectedBinding="OverrideCredential@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                          onClickBinding="OverrideCredentialOnclick@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                        />
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:contents>
              </uix:messageLayout>
              <uix:messageTextInput
                  promptBinding="LBL_StagingUsername@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                  renderedBinding="OverrideCredential@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                  name="stagingUsername"
                  noAutoComplete="true"
                  columns="15"
                  textBinding="stagingUsername@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                  />
              <uix:messageTextInput
                  renderedBinding="OverrideCredential@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                  promptBinding="LBL_StagingPassword@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                  name="stagingPassword"
                  columns="15"
                  secret="true"
                  noAutoComplete="true"
                  textBinding="stagingPassword@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                  />
              <uix:messageTextInput 
                  renderedBinding="OverrideCredential@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                  promptBinding="LBL_StagingPasswordConf@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                  name="stagingPasswordConfirm"
                  columns="15"
                  secret="true"
                  noAutoComplete="true"
                  textBinding="stagingPasswordConfirm@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                  />
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

    <uix:case name="view">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrViewDefaultImage@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText" />
          <uix:spacer height="10" />
          <uix:labeledFieldLayout>
            <uix:contents>
              <uix:messageStyledText
                        promptBinding="LBL_EntryIPAddrPrefix@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="addr@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                        contentStyleClass="OraDataText" />
              <uix:messageStyledText
                        promptBinding="LBL_BootServerPulldown@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="SelBootServer@BootServer@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                        contentStyleClass="OraDataText" />
              <uix:messageStyledText
                        promptBinding="LBL_StagingStoragePulldown@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="SelStagingStorage@StagingStorage@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                        contentStyleClass="OraDataText" />
              <uix:messageStyledText
                        promptBinding="LBL_Network@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="networkProfile@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                        contentStyleClass="OraDataText" />
              <uix:messageStyledText
                        promptBinding="LBL_Image@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="imageProfile@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                        contentStyleClass="OraDataText" />
              <uix:messageStyledText
                        promptBinding="LBL_StagingCredentials@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="Credential@DefImageData@levelOnePage@ProvisionContext@servletRequest"
                        contentStyleClass="OraDataText" />
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

    <uix:case name="remove">
      <uix:tableLayout>
        <uix:contents>
          <uix:rowLayout>
            <uix:contents>
              <uix:styledText textBinding="LBL_InstrRemoveDefaultImage@levelOnePage@ProvisionContext@servletRequest"
                              styleClass="OraInstructionTextStrong"/>
            </uix:contents>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:contents>
              <uix:spacer height="15" />
            </uix:contents>
          </uix:rowLayout>
        </uix:contents>
      </uix:tableLayout>
    </uix:case>

  </uix:switcher>
</uix:buildTree>
<%@ include file="/provision/editorTemplate.jspf" %>
