<%--
  - FILE
  -   edit_boot_server_configuration.jsp
  -
  - DESCRIPTION
  -   Principal page for managing network configuration. 
  -
  - MODIFIED   (MM/DD/YY)
  - gauragup    07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                          Attribute 
  - ashwikum    04/22/05   - Fixing UI bugs 
  - ashwikum    04/10/05   - Supporting one-address range and other changes 
  - ashwikum    03/10/05   - ashwikum_prov_net_config_050209
  - ashwikum    02/23/05   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
  <%--To display the Timestamp--%>
  <%@ include file="/provision/timestamp.jspf" %>
</uix:buildTree>

<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:switcher childNameBinding="purpose@levelOnePage@ProvisionContext@servletRequest">

    <uix:case name="remove">
      <uix:tableLayout>
        <uix:contents>
          <uix:rowLayout>
            <uix:contents>
              <uix:styledText textBinding="LBL_InstrRemoveNetConfig@levelOnePage@ProvisionContext@servletRequest"
                              styleClass="OraInstructionTextStrong"/>
            </uix:contents>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:contents>
              <uix:spacer height="15" />
            </uix:contents>
          </uix:rowLayout>
        </uix:contents>
      </uix:tableLayout>
    </uix:case>
    
    <uix:case name="view">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrViewNetConfig@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="10"/>
          <uix:labeledFieldLayout width="40%">
            <uix:contents>
              <uix:messageStyledText promptBinding="LBL_EntryNetConfigName@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                     textBinding="netConfigName@levelOnePage@ProvisionContext@servletRequest"
                                     contentStyleClass="OraDataText" />
              <uix:messageStyledText promptBinding="LBL_EntryNetConfigDomainName@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                     textBinding="netDomainName@levelOnePage@ProvisionContext@servletRequest"
                                     contentStyleClass="OraDataText" />
              <uix:messageStyledText promptBinding="LBL_EntryNetConfigSubnetMask@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                     textBinding="netSubnetMask@levelOnePage@ProvisionContext@servletRequest"
                                     contentStyleClass="OraDataText" />
              <uix:messageChoice promptBinding="LBL_EntryNetConfigGatewayAddrs@localize@AdminData@levelOnePage@ProvisionContext@servletRequest">
                <uix:contents childDataBinding="netGatewayAddrs@levelOnePage@ProvisionContext@servletRequest">
                  <uix:option textBinding="addr"/>
                </uix:contents>
              </uix:messageChoice>
              <uix:messageChoice promptBinding="LBL_EntryNetConfigDnsServers@localize@AdminData@levelOnePage@ProvisionContext@servletRequest">
                <uix:contents childDataBinding="netDnsServers@levelOnePage@ProvisionContext@servletRequest">
                  <uix:option textBinding="addr"/>
                </uix:contents>
              </uix:messageChoice>
            </uix:contents>
          </uix:labeledFieldLayout>
          <uix:spacer height="10"/>
          <uix:separator/>
          <uix:spacer height="5"/>
          <uix:messageStyledText textBinding="LBL_EntryNetConfigIpAddresses@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                styleClass="OraHeaderSub"/>
          <uix:spacer height="5"/>
          <uix:table name="IPAddressesTable"
                     formSubmitted="true"
                     width="50%"
                     tableDataBinding="tableIpAddresses@levelOnePage@ProvisionContext@servletRequest"
                     summary="IP Addresses Table">
            <uix:contents>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IpAddressHostname@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="name" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IPAddress@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="address" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IPAddressState@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="selectedState" />
                </uix:contents>
              </uix:column>
            </uix:contents>
          </uix:table>
          <uix:spacer height="10"/>
          <uix:separator/>
          <uix:spacer height="5"/>
          <uix:messageStyledText textBinding="LBL_EntryNetConfigIpAddrRanges@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                styleClass="OraHeaderSub"/>
          <uix:spacer height="5"/>
          <uix:table name="IPAddressRangesTable" 
                     formSubmitted="true"
                     width="70%"
                     tableDataBinding="tableIpRanges@levelOnePage@ProvisionContext@servletRequest"
                     summary="IP Address Ranges Table">
            <uix:contents>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IpRangePattern@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="rangeHostPattern" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_FirstIPAddress@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="firstAddr" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_LastIPAddress@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="lastAddr" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnFormat columnDataFormat="numberFormat" />
                <uix:columnHeader>
                  <uix:text textBinding="LBL_StartValue@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="startValue" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IPRangeState@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:text textBinding="selectedState" />
                </uix:contents>
              </uix:column>
            </uix:contents>
          </uix:table> 
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

    <uix:case name="add">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrAddNetConfig@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="20"/>
          <uix:labeledFieldLayout width="40%">
            <uix:contents>
              <uix:messageTextInput name="netConfigNameEntry" 
                                    promptBinding="LBL_EntryNetConfigName@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="netConfigNameStr@levelOnePage@ProvisionContext@servletRequest"
                                    columns="30" />
              <uix:messageTextInput name="netDomainNameEntry" 
                                    promptBinding="LBL_EntryNetConfigDomainName@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="netDomainNameStr@levelOnePage@ProvisionContext@servletRequest"
                                    columns="30" />
              <uix:messageTextInput name="netSubnetMaskEntry"
                                    promptBinding="LBL_EntryNetConfigSubnetMask@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="netSubnetMaskStr@levelOnePage@ProvisionContext@servletRequest"
                                    columns="30" />
              <uix:messageTextInput name="netGatewayAddrsEntry"
                                    promptBinding="LBL_EntryNetConfigGatewayAddrs@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="netGatewayAddrsStr@levelOnePage@ProvisionContext@servletRequest"
                                    tipBinding="LBL_NetConfigGatewayAddrsTip@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    columns="60" />
              <uix:messageTextInput name="netDnsServersEntry"
                                    promptBinding="LBL_EntryNetConfigDnsServers@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="netDnsServersStr@levelOnePage@ProvisionContext@servletRequest"
                                    tipBinding="LBL_NetConfigDnsServersTip@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    columns="60" />
            </uix:contents>
          </uix:labeledFieldLayout>
          <uix:spacer height="10"/>
          <uix:separator/>
          <uix:spacer height="5"/>
          <uix:messageStyledText textBinding="LBL_EntryNetConfigIpAddresses@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                 styleClass="OraHeaderSub" />

          <uix:spacer height="5"/>
          <uix:table name="IPAddressesTable"
                     formSubmitted="true"
                     tableDataBinding="tableIpAddresses@levelOnePage@ProvisionContext@servletRequest"
                     summary="IP Addresses Table">
                   
            <uix:tableSelection>
              <uix:singleSelection selectedIndexBinding="indexIPAddressesTable@levelOnePage@ProvisionContext@servletRequest"
                                   disabledBinding="disabledIPAddressesTable@levelOnePage@ProvisionContext@servletRequest">
                <uix:contents>
                  <uix:submitButton name="event" value="removeRowsIPAddressesTable"
                                    formNameBinding="formName@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="LBL_RemoveIPAddress@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    shortDescBinding="LBL_RemoveAddrAndAddrRanges@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    />
                </uix:contents>
              </uix:singleSelection> 
            </uix:tableSelection>
            <uix:contents>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IpAddressHostname@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:textInput columns="20" name="HostName" textBinding="name"  shortDesc="HostName"/>
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IPAddress@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:textInput columns="20" name="IpAddressName" textBinding="address" shortDesc="IpAddressName" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IPAddressState@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:messageChoice name="stateChoicesName"
                                     selectedValueBinding="selectedState">
                    <uix:contents childDataBinding="stateChoices@levelOnePage@ProvisionContext@servletRequest">
                      <uix:option textBinding="text"/>
                    </uix:contents>
                  </uix:messageChoice>
                </uix:contents>
              </uix:column>
            </uix:contents>
            <uix:footer>
              <uix:addTableRow/>
            </uix:footer>
          </uix:table>
          <uix:spacer height="10"/>
          <uix:separator/>
          <uix:spacer height="5"/>
          <uix:messageStyledText textBinding="LBL_EntryNetConfigIpAddrRanges@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                styleClass="OraHeaderSub"/>
          <uix:spacer height="5"/>
          <uix:styledText textBinding="MSG_InstrAddNetConfigIpRange@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="5"/>
          <uix:table name="IPAddressRangesTable" 
                     formSubmitted="true"
                     tableDataBinding="tableIpRanges@levelOnePage@ProvisionContext@servletRequest"
                     summary="IP Address ranges Table">
            <uix:tableSelection>
              <uix:singleSelection selectedIndexBinding="indexIPAddressRangesTable@levelOnePage@ProvisionContext@servletRequest"
                                   disabledBinding="disabledIPAddressRangesTable@levelOnePage@ProvisionContext@servletRequest">
                <uix:contents>
                  <uix:submitButton name="event" value="removeRowsIPAddressRangesTable"
                                    formNameBinding="formName@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="LBL_RemoveIPAddressRange@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    shortDescBinding="LBL_RemoveAddrAndAddrRanges@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    />
                </uix:contents>
              </uix:singleSelection> 
            </uix:tableSelection>
            <uix:contents>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IpRangePattern@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:textInput columns="20" name="IpRangeHostPattern" textBinding="rangeHostPattern" shortDesc="IpRangeHostPattern"/>
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_FirstIPAddress@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:textInput columns="20" name="firstAddrName" textBinding="firstAddr" shortDesc="FirstAddrName" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_LastIPAddress@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:textInput columns="20" name="lastAddrName" textBinding="lastAddr" shortDesc="lastAddrName" />
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnFormat columnDataFormat="numberFormat" />
                <uix:columnHeader>
                  <uix:text textBinding="LBL_StartValue@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:textInput columns="10" name="startValueName" textBinding="startValue" shortDesc="startValueName">
                    <uix:onBlurValidater>
                      <uix:decimal/>
                    </uix:onBlurValidater>
                    <uix:contents/>
                  </uix:textInput>
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IPRangeState@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:messageChoice name="stateChoicesName"
                                     selectedValueBinding="selectedState">
                    <uix:contents childDataBinding="stateChoices@levelOnePage@ProvisionContext@servletRequest">
                      <uix:option textBinding="text"/>
                    </uix:contents>
                  </uix:messageChoice>
                </uix:contents>
              </uix:column>
            </uix:contents>
            <uix:footer>
              <uix:addTableRow/>
            </uix:footer>
          </uix:table> 
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

    <uix:case name="edit">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrEditNetConfig@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="10"/>
          <uix:labeledFieldLayout width="40%">
            <uix:contents>
              <uix:messageTextInput name="netConfigNameEntry" 
                                    promptBinding="LBL_EntryNetConfigName@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="netConfigNameStr@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="30" />
              <uix:messageTextInput name="netDomainNameEntry" 
                                    promptBinding="LBL_EntryNetConfigDomainName@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="netDomainNameStr@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="30" />
              <uix:messageTextInput name="netSubnetMaskEntry"
                                    promptBinding="LBL_EntryNetConfigSubnetMask@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="netSubnetMaskStr@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="30" />
              <uix:messageTextInput name="netGatewayAddrsEntry"
                                    promptBinding="LBL_EntryNetConfigGatewayAddrs@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    tipBinding="LBL_NetConfigGatewayAddrsTip@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="netGatewayAddrsStr@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="60" />
              <uix:messageTextInput name="netDnsServersEntry"
                                    promptBinding="LBL_EntryNetConfigDnsServers@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="netDnsServersStr@levelOnePage@ProvisionContext@servletRequest"
                                    tipBinding="LBL_NetConfigDnsServersTip@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="60" />
            </uix:contents>
          </uix:labeledFieldLayout>
          <uix:spacer height="10"/>
          <uix:separator/>
          <uix:spacer height="5"/>
          <uix:messageStyledText textBinding="LBL_EntryNetConfigIpAddresses@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                styleClass="OraHeaderSub"/>
          <uix:spacer height="5"/>
          <uix:table name="IPAddressesTable"
                     formSubmitted="true"
                     tableDataBinding="tableIpAddresses@levelOnePage@ProvisionContext@servletRequest"
                     summary="IP Addresses Table">
            <uix:tableSelection>
              <uix:singleSelection selectedIndexBinding="indexIPAddressesTable@levelOnePage@ProvisionContext@servletRequest"
                                   disabledBinding="disabledIPAddressesTable@levelOnePage@ProvisionContext@servletRequest">
                <uix:contents>
                  <uix:submitButton name="event" value="removeRowsIPAddressesTable"
                                    formNameBinding="formName@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="LBL_RemoveIPAddress@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    shortDescBinding="LBL_RemoveAddrAndAddrRanges@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    />
                </uix:contents>
              </uix:singleSelection> 
            </uix:tableSelection>
            <uix:contents>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IpAddressHostname@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:switcher childNameBinding="allowStateMod">
                    <uix:case name="allow">
                      <uix:textInput columns="20" name="HostName" textBinding="name" shortDesc="Hostname"/>
                    </uix:case>
                    <uix:case name="disallow">
                      <uix:text textBinding="name" />
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IPAddress@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:switcher childNameBinding="allowStateMod">
                    <uix:case name="allow">
                      <uix:textInput columns="20" name="IpAddressName" textBinding="address" shortDesc="IpAddressName"/>
                    </uix:case>
                    <uix:case name="disallow">
                      <uix:text textBinding="address" />
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IPAddressState@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:switcher childNameBinding="allowStateMod">
                    <uix:case name="allow">
                      <uix:messageChoice name="stateChoicesName"
                                         selectedValueBinding="selectedState">
                        <uix:contents childDataBinding="stateChoices@levelOnePage@ProvisionContext@servletRequest">
                          <uix:option textBinding="text"/>
                        </uix:contents>
                      </uix:messageChoice>
                    </uix:case>
                    <uix:case name="disallow">
                      <uix:text textBinding="selectedSate" />
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:column>
            </uix:contents>
            <uix:footer>
              <uix:addTableRow/>
            </uix:footer>
          </uix:table>
          <uix:spacer height="10"/>
          <uix:separator/>
          <uix:spacer height="5"/>
          <uix:messageStyledText textBinding="LBL_EntryNetConfigIpAddrRanges@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                styleClass="OraHeaderSub"/>
          <uix:spacer height="5"/>
          <uix:styledText textBinding="MSG_InstrAddNetConfigIpRange@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="5"/>
          <uix:table name="IPAddressRangesTable" 
                     formSubmitted="true"
                     tableDataBinding="tableIpRanges@levelOnePage@ProvisionContext@servletRequest"
                     summary="IP Address Ranges Table">
            <uix:tableSelection>
              <uix:singleSelection selectedIndexBinding="indexIPAddressRangesTable@levelOnePage@ProvisionContext@servletRequest"
                                   disabledBinding="disabledIPAddressRangesTable@levelOnePage@ProvisionContext@servletRequest">
                <uix:contents>
                  <uix:submitButton name="event" value="removeRowsIPAddressRangesTable"
                                    formNameBinding="formName@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="LBL_RemoveIPAddressRange@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    shortDescBinding="LBL_RemoveAddrAndAddrRanges@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    />
                </uix:contents>
              </uix:singleSelection> 
            </uix:tableSelection>
            <uix:contents>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IpRangePattern@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:switcher childNameBinding="allowStateMod">
                    <uix:case name="allow">
                      <uix:textInput columns="20" name="IpRangeHostPattern" textBinding="rangeHostPattern" shortDesc="IpRangeHostPattern"/>
                    </uix:case>
                    <uix:case name="disallow">
                      <uix:text textBinding="rangeHostPattern" />
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_FirstIPAddress@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:switcher childNameBinding="allowStateMod">
                    <uix:case name="allow">
                      <uix:textInput columns="20" name="firstAddrName" textBinding="firstAddr" shortDesc="firstAddrName"/>
                    </uix:case>
                    <uix:case name="disallow">
                      <uix:text textBinding="firstAddr" />
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_LastIPAddress@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:switcher childNameBinding="allowStateMod">
                    <uix:case name="allow">
                      <uix:textInput columns="20" name="lastAddrName" textBinding="lastAddr" shortDesc="lastAddrName"/>
                    </uix:case>
                    <uix:case name="disallow">
                      <uix:text textBinding="lastAddr" />
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnFormat columnDataFormat="numberFormat" />
                <uix:columnHeader>
                  <uix:text textBinding="LBL_StartValue@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:switcher childNameBinding="allowStateMod">
                    <uix:case name="allow">
                      <uix:textInput columns="10" name="startValueName" textBinding="startValue"  shortDesc="startValueName">
                        <uix:onBlurValidater>
                          <uix:decimal/>
                        </uix:onBlurValidater>
                        <uix:contents/>
                      </uix:textInput>
                    </uix:case>
                    <uix:case name="disallow">
                      <uix:text textBinding="startValue" />
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:column>
              <uix:column>
                <uix:columnHeader>
                  <uix:text textBinding="LBL_IPRangeState@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:switcher childNameBinding="allowStateMod">
                    <uix:case name="allow">
                      <uix:messageChoice name="stateChoicesName"
                                         selectedValueBinding="selectedState">
                        <uix:contents childDataBinding="stateChoices@levelOnePage@ProvisionContext@servletRequest">
                          <uix:option textBinding="text"/>
                        </uix:contents>
                      </uix:messageChoice>
                    </uix:case>
                  </uix:switcher>
                </uix:contents>
              </uix:column>
            </uix:contents>
            <uix:footer>
              <uix:addTableRow/>
            </uix:footer>
          </uix:table> 
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

  </uix:switcher>
</uix:buildTree>
<%@ include file="/provision/editorTemplate.jspf" %>
