<%--
  - FILE
  -   edit_rpm_repos_configuration.jsp
  -
  - DESCRIPTION
  -   Principal page for managing rpm repository configuration. 
  -
  - MODIFIED   (MM/DD/YY)
  - ashwikum   04/21/05   - Fixing UI bugs 
  - ashwikum   02/01/05   - Preliminary UI review 
  - ashwikum   12/08/04   - Updating to use Ctx object instead of directly 
  -                         accessing servletRequest 
  - ashwikum   12/02/04   - ashwikum_provision_admin
  - ashwikum   11/22/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
  <%--To display the Timestamp--%>
  <%@ include file="/provision/timestamp.jspf" %>
</uix:buildTree>

<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:switcher childNameBinding="purpose@levelOnePage@ProvisionContext@servletRequest">

    <uix:case name="add">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrAddRpmRepos@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="10"/>
          <uix:labeledFieldLayout>
            <uix:contents>
              <uix:messageTextInput name="ReposName"
                                    promptBinding="LBL_EntryReposName@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="reposname@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
              <uix:messageTextInput name="DirPath"
                                    promptBinding="LBL_EntryDirPath@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="dirpath@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

    <uix:case name="remove">
      <uix:tableLayout width="100%">
        <uix:contents>
          <uix:rowLayout>
            <uix:contents>
              <uix:styledText textBinding="LBL_InstrRemoveRpmRepos@levelOnePage@ProvisionContext@servletRequest"
                              styleClass="OraInstructionTextStrong"/>
            </uix:contents>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:contents>
              <uix:spacer height="15" />
            </uix:contents>
          </uix:rowLayout>
        </uix:contents>
      </uix:tableLayout>
    </uix:case>

    <uix:case name="edit">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrEditRpmRepos@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="10"/>
          <uix:labeledFieldLayout>
            <uix:contents>
              <uix:messageTextInput name="ReposName"
                                    promptBinding="LBL_EntryReposName@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="reposname@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
              <uix:messageTextInput name="DirPath"
                                    promptBinding="LBL_EntryDirPath@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="dirpath@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

    </uix:switcher>
</uix:buildTree>
<%@ include file="/provision/editorTemplate.jspf" %>
