<%--
  - FILE
  -   edit_staging_configuration.jsp
  -
  - DESCRIPTION
  -   Page for managing staging server configuration within Administration page.
  -
  - MODIFIED   (MM/DD/YY)
  - rattipal   12/12/05   - Backport kashukla_help_pages from main 
  - kashukla   12/05/05   - adding tooltip for stage base url 
  - kashukla   08/24/05   - marking Baseurl field as Mandatory 
  - kashukla   08/07/05   - marking url field as non mandatory 
  - kashukla   07/27/05   - marking base url field as non mandatory 
  - gauragup   07/15/05   - Fixing ADA issues 
  - ashwikum   06/19/05   - Chooser for staging directory 
  - ashwikum   05/20/05   - using host chooser 
  - ashwikum   04/21/05   - Fixing UI bugs 
  - ashwikum   04/05/05   - Allowing display of entered text inspite of errors 
  - ashwikum   01/30/05   - Preliminary UI review
  - ashwikum   01/25/05   - Display improvement 
  - ashwikum   01/06/05   - Adding support for removing staging server 
  - ashwikum   12/08/04   - Adding support for adding new staging service 
  - ashwikum   12/02/04   - ashwikum_provision_admin
  - ashwikum   10/18/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
  <%--To display the Timestamp--%>
  <%@ include file="/provision/timestamp.jspf" %>
</uix:buildTree>

<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:switcher childNameBinding="purpose@levelOnePage@ProvisionContext@servletRequest">

    <uix:case name="addStageServer">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrAddStagingServer@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="10"/>
          <uix:labeledFieldLayout>
            <uix:contents>
              <uix:messageTextInput name="StagingServer"
                                    promptBinding="LBL_EntryStagingServer@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="StagingServer@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    disabled="true"
                                    columns="40"/>
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <oem:targetSelection textBinding="SELECT@commonResourceBundle"
                                       event="initializeStageServerSelection"/>
                </uix:contents>
              </uix:messageLayout>
              <uix:spacer height="8"/>
              <uix:spacer height="8"/>
              <uix:messageTextInput name="StagingDir"
                                    promptBinding="LBL_EntryStagingDir@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="StagingDir@levelOnePage@ProvisionContext@servletRequest"
                                    disabledBinding="dirDisable@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <uix:button textBinding="SELECT@commonResourceBundle"
                              disabledBinding="dirDisable@levelOnePage@ProvisionContext@servletRequest"
                              onClick="launchRfs();"/>
                </uix:contents>
              </uix:messageLayout>
              <uix:spacer height="8"/>
              <uix:spacer height="8"/>
              <uix:messageTextInput name="SizeLimit"
                                    promptBinding="LBL_EntryStagingDirSizeLimit@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="SizeLimit@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
              <uix:spacer height="4"/>
              <uix:spacer height="4"/>
              <uix:messageTextInput name="BaseUrl"
                                    promptBinding="LBL_EntryStagingBaseUrl@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="BaseUrl@levelOnePage@ProvisionContext@servletRequest"
                                    shortDescBinding="LBL_EntryStagingBaseUrlShortDesc@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

    <uix:case name="removeStageServer">
      <uix:tableLayout width="100%" hAlign="center">
        <uix:contents>
          <uix:rowLayout>
            <uix:contents>
              <uix:styledText textBinding="LBL_InstrRemoveStagingServer@levelOnePage@ProvisionContext@servletRequest" 
                              styleClass="OraInstructionTextStrong"/>
            </uix:contents>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:contents>
              <uix:spacer height="15" />
            </uix:contents>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:contents>
              <uix:styledText textBinding="LBL_AddInstrRemoveStagingServer@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                              styleClass="OraInstructionText"/>
            </uix:contents>
          </uix:rowLayout>
        </uix:contents>
      </uix:tableLayout>
    </uix:case>
    
    <uix:case name="add">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrAddStagingDir@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="10"/>
          <uix:labeledFieldLayout>
            <uix:contents>
              <uix:messageStyledText promptBinding="LBL_EntryStagingServer@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                     textBinding="StagingServer@levelOnePage@ProvisionContext@servletRequest"
                                     styleClass="OraDataText"/>
              <uix:messageTextInput name="StagingDir"
                                    promptBinding="LBL_EntryStagingDir@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="StagingDir@levelOnePage@ProvisionContext@servletRequest"
                                    disabledBinding="dirDisable@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <uix:button textBinding="SELECT@commonResourceBundle"
                              disabledBinding="dirDisable@levelOnePage@ProvisionContext@servletRequest"
                              onClick="launchRfs();"/>
                </uix:contents>
              </uix:messageLayout>
              <uix:messageTextInput name="SizeLimit"
                                    promptBinding="LBL_EntryStagingDirSizeLimit@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="SizeLimit@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
              <uix:messageTextInput name="BaseUrl"
                                    promptBinding="LBL_EntryStagingBaseUrl@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="BaseUrl@levelOnePage@ProvisionContext@servletRequest"
                                    shortDescBinding="LBL_EntryStagingBaseUrlShortDesc@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

    <uix:case name="remove">
      <uix:tableLayout width="100%" hAlign="center">
        <uix:contents>
          <uix:rowLayout>
            <uix:contents>
              <uix:styledText textBinding="LBL_InstrRemoveStagingDir@levelOnePage@ProvisionContext@servletRequest"
                              styleClass="OraInstructionTextStrong" />
            </uix:contents>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:contents>
              <uix:spacer height="15" />
            </uix:contents>
          </uix:rowLayout>
        </uix:contents>
      </uix:tableLayout>
    </uix:case>

    <uix:case name="view">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrViewStagingDir@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="10" />
          <uix:labeledFieldLayout>
            <uix:contents>
                <uix:messageStyledText
                  promptBinding="LBL_EntryStagingServer@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                  textBinding="StagingServer@levelOnePage@ProvisionContext@servletRequest"
                  styleClass="OraDataText"/>
                <uix:messageStyledText
                  promptBinding="LBL_EntryStagingDir@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                  textBinding="StagingDir@levelOnePage@ProvisionContext@servletRequest"
                  styleClass="OraDataText"/>
                <uix:messageStyledText
                  promptBinding="LBL_EntryStagingDirSizeLimit@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                  textBinding="SizeLimit@levelOnePage@ProvisionContext@servletRequest"
                  styleClass="OraDataText"/>
                <uix:messageStyledText
                  promptBinding="LBL_EntryStagingBaseUrl@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                  textBinding="BaseUrl@levelOnePage@ProvisionContext@servletRequest"
                  styleClass="OraDataText"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

    <uix:case name="edit">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrEditStagingDir@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="10"/>
          <uix:labeledFieldLayout>
            <uix:contents>
              <uix:messageStyledText promptBinding="LBL_EntryStagingServer@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                     textBinding="StagingServer@levelOnePage@ProvisionContext@servletRequest"
                                     styleClass="OraDataText"/>
              <uix:messageTextInput name="StagingDir"
                                    promptBinding="LBL_EntryStagingDir@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="StagingDir@levelOnePage@ProvisionContext@servletRequest"
                                    disabledBinding="dirDisable@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <uix:button textBinding="SELECT@commonResourceBundle"
                              disabledBinding="dirDisable@levelOnePage@ProvisionContext@servletRequest"
                              onClick="launchRfs();"/>
                </uix:contents>
              </uix:messageLayout>
              <uix:messageTextInput name="SizeLimit"
                                    textBinding="SizeLimit@levelOnePage@ProvisionContext@servletRequest"
                                    promptBinding="LBL_EntryStagingDirSizeLimit@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
              <uix:messageTextInput name="BaseUrl"
                                    textBinding="BaseUrl@levelOnePage@ProvisionContext@servletRequest"
                                    promptBinding="LBL_EntryStagingBaseUrl@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    shortDescBinding="LBL_EntryStagingBaseUrlShortDesc@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

  </uix:switcher>

  <script>
  
    function myCallBack(lovWindow, event)
    {
        return true;
    }
    
    function launchRfs()
    {
        openWindow(top, '../../page/rfs/postBackWithEvent$event=handleRfsLaunch', 'lovWindow', {width:750, height:550}, true, 'dialog', myCallBack);
    }
  </script>

</uix:buildTree>
<%@ include file="/provision/editorTemplate.jspf" %>
