<%--
  - FILE
  -   edit_sw_lib_dir_configuration.jsp
  -
  - DESCRIPTION
  -   Principal page for managing Software Library directory location. 
  -
  - MODIFIED   (MM/DD/YY)
  - ptorreti   02/22/07   - Adding pardeploy message
  - ashwikum   04/22/05   - Fixing UI bugs 
  - makarapu   03/29/05   - makarapu_admin_tab
  - makarapu   03/15/05   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
  <%--To display the Timestamp--%>
  <%@ include file="/provision/timestamp.jspf" %>
</uix:buildTree>

<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:switcher childNameBinding="purpose@levelOnePage@ProvisionContext@servletRequest">

    <uix:case name="add">
      <uix:stackLayout>
        <uix:contents>
          <uix:messageBox messageType="information"
                            renderedBinding="parDeploy@levelOnePage@ProvisionContext@servletRequest"
                            messageBinding="MSG_InstrUploadParFiles2@localize@AdminData@levelOnePage@ProvisionContext@servletRequest">
                            <uix:contents/>
          </uix:messageBox>
          <uix:spacer height="10"
            renderedBinding="parDeploy@levelOnePage@ProvisionContext@servletRequest"/>

          <uix:styledText textBinding="LBL_InstrAddSoftwareLibDir@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
          <uix:spacer height="10"/>
          <uix:labeledFieldLayout>
            <uix:contents>
              <uix:messageTextInput name="SoftwareLibDirLoc"
                                    promptBinding="LBL_EntrySoftwareLibDir2@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="dir@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
        <uix:contents>
        <uix:spacer height="10"/>
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

    <uix:case name="remove">
      <uix:tableLayout width="100%">
        <uix:contents>
          <uix:rowLayout>
            <uix:contents>
              <uix:styledText textBinding="LBL_InstrRemoveAddSoftwareLibDir@levelOnePage@ProvisionContext@servletRequest"
                              styleClass="OraInstructionTextStrong"/>
            </uix:contents>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:contents>
              <uix:spacer height="15" />
            </uix:contents>
          </uix:rowLayout>
        </uix:contents>
      </uix:tableLayout>
    </uix:case>

    <uix:case name="edit">
      <uix:stackLayout>
        <uix:contents>
          <uix:styledText textBinding="LBL_InstrEditSoftwareLibDir@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
         <uix:spacer height="10"/>
          <uix:labeledFieldLayout>
            <uix:contents>
              <uix:messageTextInput name="SoftwareLibDirLoc"
                                    promptBinding="LBL_EntrySoftwareLibDir@localize@AdminData@levelOnePage@ProvisionContext@servletRequest"
                                    textBinding="dir@levelOnePage@ProvisionContext@servletRequest"
                                    required="yes"
                                    columns="40"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:contents>
      </uix:stackLayout>
    </uix:case>

  </uix:switcher>
</uix:buildTree>
<%@ include file="/provision/editorTemplate.jspf" %>
