<%--
  - FILE
  -   assignments.jsp
  -
  - DESCRIPTION
  -   Principal page for viewing/editing asignments.
  -
  - MODIFIED   (MM/DD/YY)
  -   rattipal   12/04/05 - Backport gauragup_bugs1 from main 
  -   gauragup   11/11/05 - Adding nodestamp to hgrid 
  -   rattipal   12/05/05 - Backport gauragup_bugs1 from main 
  -   gauragup   11/11/05 - Adding nodestamp to hgrid 
  -   jhazra     07/29/05 - bug:4523961
  -   gauragup   07/15/05 - Fixing ADA bug 
  -   jhazra     06/16/05 - Remove ready column 
  -   jhazra     02/16/05 - add name col 
  -   jhazra     01/12/05 - fire selection event 
  -   jhazra     11/23/04   - Adding edit configuration properties button
  -   jhazra     11/18/04   - created
  -
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
  <%--To display the Timestamp--%>
  <%@ include file="/provision/timestamp.jspf" %>
</uix:buildTree>

<%--All page content witin the subtab is within this tag--%>
<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <%--Render This for default search mode--%>
  <uix:tableLayout width="100%" cellSpacing="10" hAlign="center" 
                   renderedBinding="isDefaultSearch@ProvisionContext@servletRequest">
    <uix:rowLayout>
      <uix:rowLayout>
        <uix:messageChoice name="filterChoice"
                           selectedValueBinding="selectedValue@criteria@search@ProvisionContext@servletRequest"
                           promptBinding="VIEW@commonResourceBundle">
          <uix:contents childDataBinding="filterChoices@criteria@search@ProvisionContext@servletRequest">
             <uix:option textBinding="text" valueBinding="value"/>
          </uix:contents>
        </uix:messageChoice>
        <uix:spacer height="1" width="10"/>
         <uix:submitButton name="event" value="doSimpleSearch"
            textBinding="GO@commonResourceBundle"/>
      </uix:rowLayout>
      <uix:rowLayout hAlign="right">
         <%--uix:button textBinding="searchToggleLabel@ProvisionContext@servletRequest"
                     destinationBinding="searchToggleDest@ProvisionContext@servletRequest"/--%>
         <uix:spacer height="1" width="10"/>
         <uix:submitButton textBinding="LBL_ProvisionAssignment@localize@ProvisionContext@servletRequest"
                     shortDescBinding="LBL_ProvisionAssignmentDesc@localize@ProvisionContext@servletRequest"
                     name="event" value="provisionReadyAssignments"/>
      </uix:rowLayout>
    </uix:rowLayout>
    <uix:rowLayout>
      <uix:cellFormat columnSpan="2">
        <uix:hGrid id="assignmentsEditor"
                   width="100%"
                   childBlockSizeBinding="childBlockSize@search@ProvisionContext@servletRequest"
                   proxyBinding="hGridProxy@search@ProvisionContext@servletRequest"
                   treeDataBinding="rootNode@resultSet@search@ProvisionContext@servletRequest"
                   columnHeaderDataBinding="columnHeaderData@search@ProvisionContext@servletRequest"
                   columnFormatsBinding="columnFormats@search@ProvisionContext@servletRequest"
                   summary="assignmentsEditor">
            <uix:nodeStamp>
              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="nodeColumnHeader@search@ProvisionContext@servletRequest"/>
                </uix:columnHeader>
                <uix:styledText textBinding="text"/>
              </uix:column>
            </uix:nodeStamp>
          <uix:tableSelection>
            <uix:singleSelection selectedIndexBinding="selectedItemIndex@search@ProvisionContext@servletRequest"
                primaryClientActionBinding="clientAction@search@ProvisionContext@servletRequest"
                renderedBinding="isSelectable">
              <uix:contents childDataBinding="selectionButtons@search@ProvisionContext@servletRequest">
                <uix:submitButton textBinding="text"
                                  shortDescBinding="shortDesc"
                                  nameBinding="name"
                                  valueBinding="value"
                                  disabledBinding="disabled"
                                  renderedBinding="rendered"/>
              </uix:contents>
            </uix:singleSelection>
          </uix:tableSelection>
          <uix:tableActions>
             <uix:submitButton textBinding="LBL_CreateAssignment@localize@ProvisionContext@servletRequest"
                         shortDescBinding="LBL_CreateAssignmentDesc@localize@ProvisionContext@servletRequest"
                         name="event" value="createAssignment"/>
          </uix:tableActions>
          <uix:columnHeaderStamp>
            <uix:text textBinding="text"/>
          </uix:columnHeaderStamp>
          <uix:contents>
            <uix:text textBinding="imagePath"/>
            <uix:text textBinding="imageType"/>
            <uix:text textBinding="startTime"/>
            <uix:text textBinding="lastModifiedBy"/>
            <uix:text textBinding="status"/>
            <uix:text textBinding="lastModified"/>
          </uix:contents>
        </uix:hGrid>
      </uix:cellFormat>
    </uix:rowLayout>
    <%--uix:rowLayout>
      <uix:flowLayout>
         <uix:button textBinding="LBL_CreateAssignment@localize@ProvisionContext@servletRequest"
                     shortDescBinding="LBL_CreateAssignmentDesc@localize@ProvisionContext@servletRequest"
                     destination="../assignments/assignments?event=createAssignment"/>
      </uix:flowLayout>
    </uix:rowLayout--%>
  </uix:tableLayout>
</uix:buildTree>
<%@ include file="/provision/subtabTemplate.jspf" %>
