<%--
  - FILE
  -   provision_assignment.jsp
  -
  - DESCRIPTION
  -   Principal page for viewing/editing asignments.
  -
  - MODIFIED   (MM/DD/YY)
  -   kashukla   02/01/06   - disabling selection for child assignments 
  -   jhazra     09/01/05   - turnoff autocomplete for passwd fields 
  -   jhazra     07/29/05   - bug:4506999
  -   gauragup   07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                           Attribute 
  -   jhazra     07/13/05   - Add oms registration pasword 
  -   jhazra     02/15/05   - incorrect buttons 
  -   jhazra     01/18/05   - jhazra_suite_beg
  -   jhazra     01/17/04   - created
  -
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.page.seg.PageSegmentContext"%>

<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
      <%--include the schedule jspf--%>
<%
        if ((((PageSegmentContext) request.getAttribute("pageSegmentContext")).getAttribute("selectedStartOption")).equals("repeating"))
        {
            ((PageSegmentContext) request.getAttribute("pageSegmentContext")).setAttribute("selectedStartOption", "now");
        }
%>
    <uix:styledText textBinding="MSG_ProvisionReady@localize@levelOnePage@ProvisionContext@servletRequest"
                          styleClass="OraInstructionText"/>
    <uix:header textBinding="LBL_Schedule@localize@levelOnePage@ProvisionContext@servletRequest">
        <uix:ref refID="SCHEDULE_SEGMENT" />
    </uix:header>
    <uix:spacer height="20" width="20"/>
    <uix:rowLayout>
      <uix:labeledFieldLayout labelWidth="270">
        <uix:messageTextInput promptBinding="LBL_RegPassword@localize@levelOnePage@ProvisionContext@servletRequest"
                  name="regPassword" columns="15" required="yes" secret="true" noAutoComplete="true"/>
      </uix:labeledFieldLayout>
    </uix:rowLayout>
    <uix:rowLayout>
      <uix:labeledFieldLayout labelWidth="270">
        <uix:messageTextInput promptBinding="LBL_RegPasswordConf@localize@levelOnePage@ProvisionContext@servletRequest"
                  name="regPasswordConf" columns="15" secret="true" noAutoComplete="true" required="yes"/>
      </uix:labeledFieldLayout>
    </uix:rowLayout>
    
    
    <uix:header textBinding="LBL_ReadyAssignments@localize@levelOnePage@ProvisionContext@servletRequest">
        <uix:table id="assignmentsTable"
                   width="100%"
                   tableDataBinding="nodes@rootNode@resultSet@data@levelOnePage@ProvisionContext@servletRequest"
                   columnHeaderDataBinding="columnHeaderData@data@levelOnePage@ProvisionContext@servletRequest"
                   columnFormatsBinding="columnFormats@data@levelOnePage@ProvisionContext@servletRequest"
                   alternateTextBinding="MSG_NoReadyAssignments@localize@levelOnePage@ProvisionContext@servletRequest"
                   summary="Assignments Table">
          <uix:tableSelection>
            <uix:multipleSelection shortDesc="Select" disabledBinding="isDisabled">
              <%--uix:contents childDataBinding="selectionButtons@data@levelOnePage@ProvisionContext@servletRequest">
                <uix:submitButton textBinding="text"
                                  shortDescBinding="shortDesc"
                                  nameBinding="name"
                                  valueBinding="value"
                                  disabledBinding="disabled"
                                  renderedBinding="rendered"/>
              </uix:contents--%>
            </uix:multipleSelection>
          </uix:tableSelection>
          <uix:columnHeaderStamp>
            <uix:text textBinding="text"/>
          </uix:columnHeaderStamp>
          <uix:contents>
            <uix:text textBinding="text"/>
            <uix:text textBinding="imageType"/>
            <uix:text textBinding="startTime"/>
            <uix:text textBinding="lastModifiedBy"/>
            <uix:text textBinding="status"/>
            <uix:text textBinding="isReady"/>
            <uix:text textBinding="lastModified"/>
          </uix:contents>
        </uix:table>
    </uix:header>
    <uix:formValue name="event" value="dummy_event_val_to_fool_ScheduleSegmentHandler.updateForm"/>
</uix:buildTree>
<%@ include file="/provision/pageTemplate.jspf" %>
