<%--
  - FILE
  -   view_assignment.jsp
  -
  - DESCRIPTION
  -   Page for (read-only) viewing asignment properties.
  -
  - MODIFIED   (MM/DD/YY)
  -   ssdas      08/09/06   - Backport rshetty_cf3 from main
  -   rshetty    04/05/06   - showing patching group and monitoring template info 
  -   jhazra     08/25/05   - show image path also 
  -   jhazra     08/09/05   - add/rem hw chages 
  -   jhazra     08/03/05   - show assignment status 
  -   gauragup   07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                           Attribute 
  -   jhazra     03/22/05   - Comment is repeated 
  -   jhazra     02/17/05   - view suite assignment 
  -   jhazra     12/03/04   - jhazra_assign2
  -   jhazra     11/30/04   - created
  -
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%--All page content within the editor is within this tag--%>

<uix:buildTree nodeID="pageContent" scope="request">
<uix:stackLayout>
 <uix:contents>
  <uix:styledText textBinding="MSG_ViewAssignments@localize@data@levelOnePage@ProvisionContext@servletRequest"
            styleClass="OraInstructionText"/>
  <uix:stackLayout>
  <uix:contents childDataBinding="dataList@levelOnePage@ProvisionContext@servletRequest">
    <uix:header textBinding="assignmentNameView">
        <uix:tableLayout width="100%">
            <uix:rowLayout>
             <uix:labeledFieldLayout>
              <uix:messageStyledText promptBinding="LBL_AssignmentLabel@localize@"
                                     textBinding="assignmentName"
                                     contentStyleClass="OraDataText" 
                                     renderedBinding="isNameRendered"/>                
             </uix:labeledFieldLayout>
             <uix:labeledFieldLayout>
              <uix:messageStyledText promptBinding="LBL_AssignmentDesc@localize@"
                                     textBinding="assignmentDesc"
                                     contentStyleClass="OraDataText"
                                     renderedBinding="isNameRendered"/>                
             </uix:labeledFieldLayout>
            </uix:rowLayout>
            <uix:rowLayout>
             <uix:labeledFieldLayout>
              <uix:messageStyledText promptBinding="LBL_NewNetwork@localize@"
                                     textBinding="networkProfile"
                                     contentStyleClass="OraDataText" 
                                     renderedBinding="isHWServerRendered"/>                
             </uix:labeledFieldLayout>
             <uix:labeledFieldLayout>
              <uix:messageStyledText promptBinding="LBL_StagingCredential@localize@"
                                     textBinding="Credential"
                                     contentStyleClass="OraDataText" />                
             </uix:labeledFieldLayout>
            </uix:rowLayout>
            <uix:rowLayout renderedBinding="isHWServerRendered">
             <uix:labeledFieldLayout>
              <uix:messageStyledText promptBinding="LBL_StagingStorage@localize@"
                                     textBinding="SelStagingStorage"
                                     contentStyleClass="OraDataText" />                
             </uix:labeledFieldLayout>
             <uix:labeledFieldLayout>
              <uix:messageStyledText promptBinding="LBL_BootServer@localize@"
                                     textBinding="SelBootServer"
                                     contentStyleClass="OraDataText" />                
             </uix:labeledFieldLayout>
            </uix:rowLayout>
            <uix:rowLayout>
             <uix:labeledFieldLayout>
              <uix:messageStyledText promptBinding="LBL_Status@localize@"
                                     textBinding="asnStatus"
                                     contentStyleClass="OraDataText" />                
             </uix:labeledFieldLayout>
             <uix:labeledFieldLayout>
              <uix:messageStyledText promptBinding="LBL_TargetReset@localize@"
                                     textBinding="resetTimeout"
                                     contentStyleClass="OraDataText" 
                                     renderedBinding="isHWServerRendered"/>                
             </uix:labeledFieldLayout>
            </uix:rowLayout>
            
            <uix:rowLayout>
             <uix:labeledFieldLayout>
              <uix:messageStyledText promptBinding="LBL_PatchGroup@localize@"
                                     textBinding="SelPatchGroup"
                                     contentStyleClass="OraDataText" />                 
             </uix:labeledFieldLayout>
 
             <uix:labeledFieldLayout>
              <uix:messageStyledText promptBinding="LBL_MonitoringTemplate@localize@"
                                     textBinding="SelMonitoringTemplate"
                                     contentStyleClass="OraDataText" />                 
             </uix:labeledFieldLayout>
            </uix:rowLayout>
        </uix:tableLayout>
            <uix:header textBinding="LBL_HardwareTable@localize@"
                renderedBinding="isHWServerRendered">
                <uix:styledText textBinding="initClusterSize"
                    styleClass="OraInstructionText"/>    
                <uix:table width="100%" id="hardwareTable"
                           tableDataBinding="hardwareTableData@hardwareData@"
                           columnFormatsBinding="columnFormats@hardwareData@"
                           columnHeaderDataBinding="columnFormats@hardwareData@"
                           alternateTextBinding="MSG_NoHardwareServer@localize@"
                           summary="Hardware Table">
                  <uix:columnHeaderStamp>
                    <uix:text textBinding="text"/>
                  </uix:columnHeaderStamp>
                  <uix:contents>
                    <uix:text textBinding="label"/>
                    <uix:text textBinding="currHostName"/>
                    <uix:text textBinding="currImg"/>
                    <uix:text textBinding="currNetwork"/>
                  </uix:contents>
                </uix:table>
            </uix:header>
    </uix:header>
    </uix:contents>
    </uix:stackLayout>
  </uix:contents>
</uix:stackLayout>
</uix:buildTree>
<%@ include file="/provision/editorTemplate.jspf" %>


