<%--
  - FILE
  -   adapter_map_form.jsp
  -
  - DESCRIPTION
  -   Page for editing a map of named values on a form for a network adapter.
  -
  - MODIFIED   (MM/DD/YY)
  - rattipal    08/08/06   - bonding support
  - ashwikum    06/29/05   - ashwikum_prov050628
  - ashwikum    06/06/05   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
    <uix:radioButton name="bondingButtons"
        textBinding="bonding@map@pageContext@servletRequest" 
        selectedBinding="bondButton@map@pageContext@servletRequest" 
        value="bondButton"
      onClick="handleBondingMechanism('yes')"  />
    <uix:radioButton name="bondingButtons"
        textBinding="nonBonding@map@pageContext@servletRequest" 
        selectedBinding="nonBondButton@map@pageContext@servletRequest" 
        value="nonBondButton"
	 onClick="handleBondingMechanism('no')"    />

      <script>

      function handleBondingMechanism(obj)
       {
        formObj = document.forms[0];
        var url = formObj.action+"?event=toggleBondingMechanism&isBonding="+obj;
        window.location.href = url;
       }
      </script>


 <uix:labeledFieldLayout labelWidth="150">
    <uix:contents childDataBinding="fields@map@pageContext@servletRequest">
      <uix:switcher childNameBinding="name">
        <uix:case name="NAME_NetConfigId">
          <uix:messageChoice nameBinding="name"
                             selectedValueBinding="value"
                             promptBinding="prompt"
                             tipBinding="tip"
                             renderedBinding="rendered">
            <uix:contents childDataBinding="choices">
               <uix:option textBinding="text" valueBinding="value"/>
            </uix:contents>
          </uix:messageChoice>
        </uix:case>
        <uix:case name="NAME_IsBonding">
          <uix:messageTextInput nameBinding="name"
                                promptBinding="prompt"
                                textBinding="value"
                                tipBinding="tip"
                                rendered="false"/>

        </uix:case>
         <uix:case name="NAME_SlaveDevicesList">
            <uix:messageTextInput nameBinding="name"
                                    promptBinding="prompt"
                                    textBinding="value"
                                    tipBinding="tip"
                                    renderedBinding="bondButton@map@pageContext@servletRequest"/>
        </uix:case>

         <uix:case name="NAME_PrimarySlave">
            <uix:messageTextInput nameBinding="name"
                                    promptBinding="prompt"
                                    textBinding="value"
                                    tipBinding="tip"
                                    renderedBinding="bondButton@map@pageContext@servletRequest"/>
        </uix:case>

         <uix:case name="NAME_BondingMode">
            <uix:messageTextInput nameBinding="name"
                                    promptBinding="prompt"
                                    textBinding="value"
                                    tipBinding="tip"
                                    renderedBinding="bondButton@map@pageContext@servletRequest"/>
        </uix:case>

         <uix:case name="NAME_ARPInterval">
            <uix:messageTextInput nameBinding="name"
                                    promptBinding="prompt"
                                    textBinding="value"
                                    tipBinding="tip"
                                    renderedBinding="bondButton@map@pageContext@servletRequest"/>
        </uix:case>

         <uix:case name="NAME_ARPIPTarget">
            <uix:messageTextInput nameBinding="name"
                                    promptBinding="prompt"
                                    textBinding="value"
                                    tipBinding="tip"
                                    renderedBinding="bondButton@map@pageContext@servletRequest"/>
        </uix:case>

         <uix:case name="NAME_MIIInterval">
            <uix:messageTextInput nameBinding="name"
                                    promptBinding="prompt"
                                    textBinding="value"
                                    tipBinding="tip"
                                    renderedBinding="bondButton@map@pageContext@servletRequest"/>
        </uix:case>

         <uix:case name="NAME_DownDelay">
            <uix:messageTextInput nameBinding="name"
                                    promptBinding="prompt"
                                    textBinding="value"
                                    tipBinding="tip"
                                    renderedBinding="bondButton@map@pageContext@servletRequest"/>
        </uix:case>

         <uix:case name="NAME_UpDelay">
            <uix:messageTextInput nameBinding="name"
                                    promptBinding="prompt"
                                    textBinding="value"
                                    tipBinding="tip"
                                    renderedBinding="bondButton@map@pageContext@servletRequest"/>
        </uix:case>


        <uix:default>
          <uix:messageTextInput nameBinding="name"
                                promptBinding="prompt"
                                textBinding="value"
                                tipBinding="tip"
                                renderedBinding="rendered"/>
        </uix:default>
      </uix:switcher>
      <uix:spacer width="100" height="10"/>
    </uix:contents>
  </uix:labeledFieldLayout>
</uix:buildTree>
<%@ include file="/provision/pageTemplate.jspf" %>
