<%-- 
  - FILE
  -   components.jsp
  -
  - DESCRIPTION
  -   Principal page for maintaining components in the software library.
  -
  - MODIFIED   (MM/DD/YY)
  -   rattipal  12/04/05   - Backport gauragup_bugs1 from main 
  -   gauragup  11/11/05   - Adding nodestamp to hgrid 
  -   rattipal  12/05/05   - Backport gauragup_bugs1 from main 
  -   gauragup  11/11/05   - Adding nodestamp to hgrid 
  -   gauragup  09/16/05   - display values not to serve as inputs for drop down
  -   gauragup  08/23/05   - chnage the fields names to have product fields in 
  -                          search columns 
  -   gauragup  07/27/05   - fixing vendor prompt 
  -   gauragup  07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                          Attribute 
  -   gauragup  06/29/05   - Adding search by product version and vendor in 
  -                          adv search 
  -   gauragup  06/06/05   - Adding product version and vendor fields to adv 
  -                          search 
  -   ashwikum  05/02/05   - Fixing UI bugs 
  -   gauragup  03/28/05   - adding more search crtiteria for adv search 
  -   gauragup  03/21/05   - changing tag atrib 
  -   gauragup  21/03/05   - added advanced search options 
  -   eworth    12/28/04   - Use primary Client action 
  -   eworth    12/22/04   - Add shortDesc attribute to buttons 
  -   jhazra    11/25/04   - Add renderedBinding to supress unwanted Assign 
  -                          button 
  -   eworth    10/15/04   - Use submitButton instead of button within hGrid 
  -   eworth    10/13/04   - Fix bugs 
  -   eworth    10/12/04   - Support view filter 
  -   eworth    10/04/04   - eworth_prov_api_040920
  -   eworth    09/30/04   - Have hGrid access rootNode from the search result 
  -                          set 
  -   eworth    09/29/04   - Add functionality. 
  -   eworth    09/28/04   - Add content
  -   eworth    09/23/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
  <%--To display the Timestamp--%>
  <%@ include file="/provision/timestamp.jspf" %>
</uix:buildTree>

<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <%--Render This for default search mode--%>
  <uix:tableLayout width="100%" cellSpacing="10" hAlign="center" 
                   renderedBinding="isDefaultSearch@ProvisionContext@servletRequest">
    <uix:rowLayout>
      <uix:rowLayout>
        <uix:messageChoice name="filterChoice"
                           selectedValueBinding="selectedValue@criteria@search@ProvisionContext@servletRequest"
                           promptBinding="VIEW@commonResourceBundle">
          <uix:contents childDataBinding="filterChoices@criteria@search@ProvisionContext@servletRequest">
             <uix:option textBinding="text" valueBinding="value"/>
          </uix:contents>
        </uix:messageChoice>
        <uix:spacer width="10"/>
        <uix:submitButton name="event" value="doBrowseSearch" 
                            textBinding="GO@commonResourceBundle" 
                            shortDescBinding="LBL_GoDesc@localize@search@ProvisionContext@servletRequest"
                            formNameBinding="formName@ProvisionContext@servletRequest"/>
        <uix:spacer width="10"/>
          <uix:link textBinding="searchToggleLabel@ProvisionContext@servletRequest"
                      shortDescBinding="searchToggleDesc@ProvisionContext@servletRequest"
                      destinationBinding="searchToggleDest@ProvisionContext@servletRequest"/>
      </uix:rowLayout>
    </uix:rowLayout>
    <uix:rowLayout>
      <uix:cellFormat columnSpan="2">
        <uix:hGrid id="libraryTreeEditor"
                   width="100%"
                   treeDataBinding="rootNode@resultSet@search@ProvisionContext@servletRequest"
                   columnHeaderDataBinding="columnHeaderData@search@ProvisionContext@servletRequest"
                   columnFormatsBinding="columnFormats@search@ProvisionContext@servletRequest"
                   summary="Component Listing">
         <uix:nodeStamp>
           <uix:column>
             <uix:columnHeader>
               <uix:styledText textBinding="nodeColumnHeader@search@ProvisionContext@servletRequest"/>
             </uix:columnHeader>
             <uix:styledText textBinding="text"/>
           </uix:column>
         </uix:nodeStamp>
         <uix:tableSelection>
            <uix:singleSelection selectedIndexBinding="selectedItemIndex@search@ProvisionContext@servletRequest"
                                 primaryClientActionBinding="clientAction@search@ProvisionContext@servletRequest"
                                 shortDesc="Select">
              <uix:contents childDataBinding="selectionButtons@search@ProvisionContext@servletRequest">
                <uix:submitButton textBinding="text"
                                  shortDescBinding="shortDesc"
                                  nameBinding="name"
                                  valueBinding="value"
                                  disabledBinding="disabled"
                                  renderedBinding="rendered"/>
              </uix:contents>
            </uix:singleSelection>
          </uix:tableSelection>
          <uix:columnHeaderStamp>
            <uix:text textBinding="text"/>
          </uix:columnHeaderStamp>
          <uix:contents>
            <uix:text textBinding="subtype"/>
            <uix:text textBinding="version"/>
            <uix:text textBinding="state"/>
            <uix:text textBinding="maturity"/>
            <uix:text textBinding="productName"/>
            <uix:text textBinding="productVersion"/>
            <uix:text textBinding="description"/>
          </uix:contents>
        </uix:hGrid>
      </uix:cellFormat>
    </uix:rowLayout>
  </uix:tableLayout>


  <uix:header textBinding="LBL_AdvSearchTxt@localize@search@ProvisionContext@servletRequest"
              renderedBinding="isAdvSearch@ProvisionContext@servletRequest"> 
    <uix:contents>
      <uix:stackLayout>
        <uix:contents>
          <uix:spacer height="10" />
          <uix:labeledFieldLayout columns="2" width="70%">
            <uix:contents>
              <uix:messageTextInput name="compName" 
                     promptBinding="LBL_Name@localize@criteria@search@ProvisionContext@servletRequest"
                     textBinding="compName@criteria@search@ProvisionContext@servletRequest"
                     columns="20" />
              <uix:messageChoice name="versionOptions" 
                     selectedValueBinding="selectedVersion@criteria@search@ProvisionContext@servletRequest"
                     promptBinding="LBL_Version@localize@criteria@search@ProvisionContext@servletRequest">
                <uix:contents childDataBinding="versionOptions@criteria@search@ProvisionContext@servletRequest">
                  <uix:option textBinding="displayValueKey"
                               valueBinding="messageKeyKey"/>
                </uix:contents>
              </uix:messageChoice>
              <uix:messageChoice name="subtypeOptions"
                         selectedValueBinding="selectedSubtype@criteria@search@ProvisionContext@servletRequest"
                         promptBinding="LBL_Subtype@localize@criteria@search@ProvisionContext@servletRequest"
                         renderedBinding="subtypesExist@criteria@search@ProvisionContext@servletRequest">
                <uix:contents childDataBinding="subtypeOptions@criteria@search@ProvisionContext@servletRequest">
                  <uix:option textBinding="displayValueKey"
                               valueBinding="messageKeyKey"/>
                </uix:contents>
              </uix:messageChoice>
              <uix:messageTextInput name="fileName"
                        promptBinding="LBL_Filename@localize@criteria@search@ProvisionContext@servletRequest"
                        textBinding="fileName@criteria@search@ProvisionContext@servletRequest"
                        columns="20" />
              <uix:messageChoice name="maturityOptions"
                        selectedValueBinding="selectedMaturity@criteria@search@ProvisionContext@servletRequest"
                        promptBinding="LBL_Maturity@localize@criteria@search@ProvisionContext@servletRequest">
                <uix:contents childDataBinding="maturityOptions@criteria@search@ProvisionContext@servletRequest">
                  <uix:option textBinding="displayValueKey"
                               valueBinding="messageKeyKey"/>
                </uix:contents>
              </uix:messageChoice>
              <uix:messageChoice name="statusOptions"
                      selectedValueBinding="selectedStatus@criteria@search@ProvisionContext@servletRequest"
                      promptBinding="LBL_Status@localize@criteria@search@ProvisionContext@servletRequest">
                <uix:contents childDataBinding="statusOptions@criteria@search@ProvisionContext@servletRequest">
                  <uix:option textBinding="displayValueKey"
                               valueBinding="messageKeyKey"/>
                </uix:contents>
              </uix:messageChoice>
              <uix:messageTextInput name="author"
                      promptBinding="LBL_Author@localize@criteria@search@ProvisionContext@servletRequest"
                      textBinding="author@criteria@search@ProvisionContext@servletRequest"
                      columns="10" />
              <uix:messageTextInput name="product"
                      promptBinding="LBL_ProductName@localize@criteria@search@ProvisionContext@servletRequest"
                      textBinding="product@criteria@search@ProvisionContext@servletRequest"
                      columns="10" />
              <uix:messageTextInput name="productVersion"
                      promptBinding="LBL_ProductVersion@localize@search@ProvisionContext@servletRequest"
                      textBinding="productVersion@criteria@search@ProvisionContext@servletRequest"
                      columns="10" />

              <uix:messageTextInput name="vendor"
                      promptBinding="LBL_VendorPrompt@localize@search@ProvisionContext@servletRequest"
                      textBinding="vendor@criteria@search@ProvisionContext@servletRequest"
                      columns="10" />
              <uix:spacer
                renderedBinding="subtypesDontExist@criteria@search@ProvisionContext@servletRequest"
                height="7" />
              <uix:spacer 
                renderedBinding="subtypesDontExist@criteria@search@ProvisionContext@servletRequest"
                height="7" />
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <uix:submitButton name="event" value="doAdvSearch" 
                      textBinding="GO@commonResourceBundle" 
                      shortDescBinding="LBL_GoDesc@localize@search@ProvisionContext@servletRequest"
                      formNameBinding="formName@ProvisionContext@servletRequest"/>
                  <uix:spacer width="10" />
                  <uix:link textBinding="searchToggleLabel@ProvisionContext@servletRequest"
                            shortDescBinding="searchToggleDesc@ProvisionContext@servletRequest"
                            destinationBinding="searchToggleDest@ProvisionContext@servletRequest"/>
                </uix:contents>
              </uix:messageLayout>
            </uix:contents>
          </uix:labeledFieldLayout>
          <uix:separator />
          <uix:tableLayout width="100%" hAlign="center">
            <uix:contents>
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat columnSpan="2">
                    <uix:contents>
                      <uix:spacer height="10" />
                        <uix:table name="ComponentTable"
                           tableDataBinding="dataList@resultSet@search@ProvisionContext@servletRequest"
                           formSubmitted="true"
                           valueBinding="firstVisibleIndexKey@search@ProvisionContext@servletRequest"
                           minValueBinding="firstIndexKey@search@ProvisionContext@servletRequest"
                           maxValueBinding="lastIndexKey@search@ProvisionContext@servletRequest"
                           blockSizeBinding="blockSizeKey@search@ProvisionContext@servletRequest"
                           alternateTextBinding="MSG_NoComponentFound@localize@search@ProvisionContext@servletRequest"
                           width="100%"
                           summary="Component Table">
                          <uix:tableSelection>
                            <uix:singleSelection selectedIndexBinding="selectedItemIndex@search@ProvisionContext@servletRequest"
                                                 primaryClientActionBinding="clientAction@search@ProvisionContext@servletRequest">
                              <uix:contents childDataBinding="selectionButtons@search@ProvisionContext@servletRequest">
                                <uix:submitButton textBinding="text"
                                     nameBinding="name"
                                     shortDescBinding="shortDesc"
                                     valueBinding="value"
                                     disabledBinding="disabled"
                                     formNameBinding="formName@ProvisionContext@servletRequest"/>
                              </uix:contents>
                            </uix:singleSelection>
                          </uix:tableSelection>
                          <uix:contents>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_Name@localize@search@ProvisionContext@servletRequest" />
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageStyledText textBinding="componentName" />
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_Type@localize@search@ProvisionContext@servletRequest" />
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:link textBinding="type" />
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_Version@localize@search@ProvisionContext@servletRequest" />
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:text textBinding="version" />
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_Status@localize@search@ProvisionContext@servletRequest" />
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:text textBinding="status" />
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_Maturity@localize@search@ProvisionContext@servletRequest" />
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:text textBinding="maturity" />
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_ProductName@localize@search@ProvisionContext@servletRequest" />
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:text textBinding="productName" />
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_ProductVersion@localize@search@ProvisionContext@servletRequest" />
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:text textBinding="productVersion" />
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_Description@localize@search@ProvisionContext@servletRequest" />
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:text textBinding="description" />
                              </uix:contents>
                            </uix:column>
                          </uix:contents>
                        </uix:table>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>
          <uix:spacer height="20" />
        </uix:contents>
      </uix:stackLayout>
    </uix:contents>
  </uix:header>

</uix:buildTree>
<%@ include file="/provision/subtabTemplate.jspf" %>
