<%--
  - FILE
  -   edit_proptype.jsp
  -
  - DESCRIPTION
  -   Principal page for creating property types.
  -
  - MODIFIED   (MM/DD/YY)
  -   gaurgupt   08/23/07   - fixing the bug# 4456712 
  -   jhazra     09/20/05   - disable the secure property checkbox 
  -   jhazra     08/03/05   - add secure prop type 
  -   gauragup   07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                           Attribute 
  -   jhazra     04/28/05   - Remove tip text from some fields 
  -   jhazra     03/18/05   - jhazra_prop_edit_0310
  -   jhazra     07/07/05   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page content within the editor is within this tag--%>
<uix:body onLoadBinding="focusJavaScript@servletRequest">
<uix:buildTree nodeID="pageContent" scope="request">
 <uix:stackLayout>
    <uix:styledText textBinding="MSG_PropTypeInst@localize@data@pageContext@servletRequest"
                             styleClass="OraInstructionText" /> 
    <uix:spacer height="15"/>
    <uix:labeledFieldLayout labelWidth="150">
      <uix:messageTextInput name="propName"
                            promptBinding="LBL_PropName@localize@data@pageContext@servletRequest"
                            textBinding="propName@data@pageContext@servletRequest"
                            required="yes"
                            readOnlyBinding="isPropNameReadOnly@data@pageContext@servletRequest"/>
      <uix:messageChoice name="types" id="viewChoice"
                         promptBinding="LBL_PropType@localize@data@pageContext@servletRequest"
                         selectedValueBinding="selectedType@data@pageContext@servletRequest"
                         onChange="submitForm('propertyForm',0, {'event':'typeSelectionChanged'})">
	
        <uix:contents childDataBinding="types@data@pageContext@servletRequest">
           <uix:option textBinding="displayValueKey"
                       valueBinding="messageKeyKey"/>
        </uix:contents>
        <uix:end>
            <uix:styledText textBinding="selectedTypeUIInfo@data@pageContext@servletRequest"
                            styleClass="OraInstructionText"/>
        </uix:end>
      </uix:messageChoice>
      <uix:messageCheckBox  name="isSecret"
                            readOnly="true"
                            textBinding="LBL_Secret@localize@data@pageContext@servletRequest"
                            tipBinding="LBL_SecretDesc@localize@data@pageContext@servletRequest"
                            renderedBinding="showIsSecret@data@pageContext@servletRequest"
                            checkedBinding="isSecret@data@pageContext@servletRequest"/>
      <uix:messageTextInput name="initValue"
                            promptBinding="LBL_InitValue@localize@data@pageContext@servletRequest"
                            renderedBinding="isInitValString@data@pageContext@servletRequest"
                            tipBinding="LBL_InitValueDesc@localize@data@pageContext@servletRequest"
                            textBinding="initValue@data@pageContext@servletRequest"
                            />
      <uix:messageRadioSet  name="initValue"
                            promptBinding="LBL_InitValue@localize@data@pageContext@servletRequest"
                            selectedValueBinding="selectedType@data@pageContext@servletRequest"
                            tipBinding="LBL_InitValueDesc@localize@data@pageContext@servletRequest"
                            renderedBinding="isInitValBoolean@data@pageContext@servletRequest">
        <uix:option textBinding="TRUE@data@pageContext@servletRequest"
                    valueBinding="TRUE@data@pageContext@servletRequest"/>
        <uix:option textBinding="FALSE@data@pageContext@servletRequest"
                    valueBinding="FALSE@data@pageContext@servletRequest"/>
        <uix:option textBinding="LBL_Empty@localize@data@pageContext@servletRequest"
                    value="NONE"/>
      </uix:messageRadioSet>
      
      <uix:messageDateField name="initValue"
                            promptBinding="LBL_InitValue@localize@data@pageContext@servletRequest"
                            renderedBinding="isInitValDate@data@pageContext@servletRequest"
                            tipBinding="LBL_InitValueDesc@localize@data@pageContext@servletRequest"
                            textBinding="initValue@data@pageContext@servletRequest"
                            >      
              <uix:onSubmitValidater>  
                <uix:date dateStyle="medium" timeStyle="medium"/>
              </uix:onSubmitValidater>
      </uix:messageDateField>
      <%--uix:messageTextInput name="mapElemName"
                            promptBinding="LBL_MapElemName@localize@data@pageContext@servletRequest"
                            tipBinding="LBL_MapElemNameDesc@localize@data@pageContext@servletRequest"
                            textBinding="mapElemName@data@pageContext@servletRequest"
                            renderedBinding="isMapElemName@data@pageContext@servletRequest"
                            required="yes"/--%>      
      <uix:messageTextInput name="enumElems"
                            promptBinding="LBL_EnumElems@localize@data@pageContext@servletRequest"
                            tipBinding="LBL_EnumElemsDesc@localize@data@pageContext@servletRequest"
                            textBinding="enumElems@data@pageContext@servletRequest"
                            renderedBinding="isEnumType@data@pageContext@servletRequest"
                            required="yes"/>      
      <uix:messageChoice name="selectedMemberType"
                         promptBinding="LBL_MemberType@localize@data@pageContext@servletRequest"
                         tipBinding="LBL_MemberTypeDesc@localize@data@pageContext@servletRequest"
                         selectedValueBinding="selectedMemberType@data@pageContext@servletRequest"
                         renderedBinding="isMemberType@data@pageContext@servletRequest">
        <uix:contents childDataBinding="types@data@pageContext@servletRequest">
           <uix:option textBinding="displayValueKey"
                       valueBinding="messageKeyKey"/>
        </uix:contents>
        <uix:end>
            <uix:styledText textBinding="selectedMemberTypeUIInfo@data@pageContext@servletRequest"
                            styleClass="OraInstructionText"/>
        </uix:end>        
      </uix:messageChoice>
      <uix:messageTextInput name="arrayLength"
                            promptBinding="LBL_ArrayLength@localize@data@pageContext@servletRequest"
                            tipBinding="LBL_ArrayLengthDesc@localize@data@pageContext@servletRequest"
                            textBinding="arrayLength@data@pageContext@servletRequest"
                            renderedBinding="isArrayLength@data@pageContext@servletRequest"
                            required="yes"/>
      <uix:messageRadioButton textBinding="LBL_TopLevelType@localize@data@pageContext@servletRequest"
                              name="purpose"
                              value="isTopLevel"
                              disabledBinding="isFixedType@data@pageContext@servletRequest"
                              selectedBinding="isTopLevel@data@pageContext@servletRequest"/>
      <uix:messageRadioButton textBinding="LBL_SharedType@localize@data@pageContext@servletRequest"
                              name="purpose"
                              value="isShared"
                              disabledBinding="isFixedType@data@pageContext@servletRequest"
                              selectedBinding="isShared@data@pageContext@servletRequest"/>
      <uix:messageChoice name="supportedConstraints"
                         promptBinding="LBL_SupportedConstraints@localize@data@pageContext@servletRequest"
                         messageBinding="LBL_SupportedConstraintsDesc@localize@data@pageContext@servletRequest"
                         selectedValueBinding="supportedConstraints@data@pageContext@servletRequest"
                         renderedBinding="isConstraintsSupported@data@pageContext@servletRequest"
                         >
        <uix:contents childDataBinding="supportedConstraints@data@pageContext@servletRequest">
           <uix:option textBinding="constraintName"
                       valueBinding="constraintNameKey"/>
        </uix:contents>
        <uix:end>
          <uix:flowLayout>
            <uix:textInput name="configuredValue" columns="4" shortDesc="configuredValue"/>
            <uix:submitButton name="event" value="addConstraint" 
            unvalidated="true"
            textBinding="LBL_AddConstraint@localize@data@pageContext@servletRequest"
            shortDescBinding="LBL_AddConstraintDesc@localize@data@pageContext@servletRequest"/>
          </uix:flowLayout>
        </uix:end>
      </uix:messageChoice>
    </uix:labeledFieldLayout>
    <uix:header textBinding="LBL_ConfiguredConstraints@@localize@data@pageContext@servletRequest"
        size="10"
        renderedBinding="isConstraintsSupported@data@pageContext@servletRequest">
        <uix:table id="configConstraints"
                   width="75%"
                   tableDataBinding="configConstraints@data@pageContext@servletRequest"
                   alternateTextBinding="MSG_NoConstraintsConfigured@localize@data@pageContext@servletRequest"
                   summary="Config Constraints">
          <uix:tableSelection>
            <uix:multipleSelection>
                <uix:contents>
                    <uix:submitButton textBinding="OP_Remove@localize@data@pageContext@servletRequest"
                                shortDescBinding="OP_RemoveDesc@localize@data@pageContext@servletRequest"
                                unvalidated="true"
                                name="event" value="deleteConstraint"
                                 />
                  </uix:contents>
            </uix:multipleSelection>
          </uix:tableSelection>
          <uix:column>
              <uix:columnHeader>            
                <uix:text textBinding="LBL_Constraint@localize@data@pageContext@servletRequest"/>
              </uix:columnHeader>            
              <uix:contents>
                <uix:text textBinding="constraintName"/>
              </uix:contents>
          </uix:column>
          <uix:column>
              <uix:columnHeader>            
                <uix:text textBinding="LBL_Value@localize@data@pageContext@servletRequest"/>
              </uix:columnHeader>
              <uix:contents>
                <uix:text textBinding="constraintValue"/>
              </uix:contents>
          </uix:column>
        </uix:table>        
    </uix:header>
 </uix:stackLayout>    
</uix:buildTree>
</uix:body>
<%@ include file="/provision/pageTemplate.jspf" %>
