<%--
  - FILE
  -   edit_components.jsp
  -
  - DESCRIPTION
  -   Specify references to components and images for images or suites.
  -
  - MODIFIED   (MM/DD/YY)
  -   gauragup  08/23/05   - fix bug to show version in version column 
  -   gauragup  07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                          Attribute 
  -   eworth    12/10/04   - Use submit buttons 
  -   eworth    12/09/04   - Use table for static references 
  -   eworth    11/11/04   - eworth_prov_ui_041101
  -   eworth    11/10/04   - Bind reference field names 
  -   eworth    11/09/04   - Use table name from data object
  -   eworth    11/08/04   - Set column text value binding 
  -   eworth    11/05/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:header textBinding="fixedCompRefsHeader@levelOnePage@ProvisionContext@servletRequest"
            renderedBinding="fixedCompRefsRendered@levelOnePage@ProvisionContext@servletRequest">
  <uix:stackLayout>
    <uix:styledText textBinding="fixedCompRefsDesc@levelOnePage@ProvisionContext@servletRequest"
                    styleClass="OraInstructionText"/>
    <uix:spacer height="10" width="200"/>
  </uix:stackLayout>
  <uix:table nameBinding="tableName@fixedCompRefs@data@levelOnePage@ProvisionContext@servletRequest"
             width="100%"
             tableDataBinding="resultSet@fixedCompRefs@data@levelOnePage@ProvisionContext@servletRequest"
             columnFormatsBinding="columnFormats@fixedCompRefs@data@levelOnePage@ProvisionContext@servletRequest"
             columnHeaderDataBinding="columnFormats@fixedCompRefs@data@levelOnePage@ProvisionContext@servletRequest"
             alternateTextBinding="altText@fixedCompRefs@data@levelOnePage@ProvisionContext@servletRequest"
             summary="Reference Table">
    <uix:tableSelection>
      <uix:singleSelection selectedIndexBinding="selectedItemIndex@fixedCompRefs@data@levelOnePage@ProvisionContext@servletRequest"
                               shortDesc="Select">
        <uix:contents childDataBinding="selectionButtons@fixedCompRefs@data@levelOnePage@ProvisionContext@servletRequest">
          <uix:submitButton textBinding="text"
                            nameBinding="name"
                            valueBinding="value"
                            shortDescBinding="shortDesc"
                            disabledBinding="disabled"/>
        </uix:contents>
      </uix:singleSelection>
    </uix:tableSelection>
    <uix:columnHeaderStamp>
      <uix:text textBinding="text"/>
    </uix:columnHeaderStamp>
    <uix:contents>
      <uix:text textBinding="refNamePrompt"/>
      <uix:text textBinding="refTextValue"/>
      <uix:text textBinding="refVersion"/>
      <uix:text textBinding="maturityText"/>
    </uix:contents>
  </uix:table>
</uix:header>
<uix:spacer height="10" width="200"/>
<uix:header textBinding="dynamicRefsHeader@levelOnePage@ProvisionContext@servletRequest">
  <uix:stackLayout>
    <uix:styledText textBinding="dynamicRefsDesc@levelOnePage@ProvisionContext@servletRequest"
                    styleClass="OraInstructionText"/>
    <uix:spacer height="10" width="200"/>
  </uix:stackLayout>
  <uix:table nameBinding="tableName@dynamicCompRefs@data@levelOnePage@ProvisionContext@servletRequest"
             width="100%"
             tableDataBinding="resultSet@dynamicCompRefs@data@levelOnePage@ProvisionContext@servletRequest"
             columnFormatsBinding="columnFormats@dynamicCompRefs@data@levelOnePage@ProvisionContext@servletRequest"
             columnHeaderDataBinding="columnFormats@dynamicCompRefs@data@levelOnePage@ProvisionContext@servletRequest"
             alternateTextBinding="altText@dynamicCompRefs@data@levelOnePage@ProvisionContext@servletRequest"
             summaryBinding="tableName@dynamicCompRefs@data@levelOnePage@ProvisionContext@servletRequest">
    <uix:tableSelection>
      <uix:singleSelection selectedIndexBinding="selectedItemIndex@dynamicCompRefs@data@levelOnePage@ProvisionContext@servletRequest">
        <uix:contents childDataBinding="selectionButtons@dynamicCompRefs@data@levelOnePage@ProvisionContext@servletRequest">
          <uix:submitButton textBinding="text"
                            nameBinding="name"
                            valueBinding="value"
                            shortDescBinding="shortDesc"
                            disabledBinding="disabled"/>
        </uix:contents>
      </uix:singleSelection>
    </uix:tableSelection>
    <uix:columnHeaderStamp>
      <uix:text textBinding="text"/>
    </uix:columnHeaderStamp>
    <uix:columnFooter>
      <uix:addTableRow/>
    </uix:columnFooter>
    <uix:contents>
      <uix:text textBinding="refNamePrompt"/>
      <uix:text textBinding="refTextValue"/>
      <uix:text textBinding="refVersion"/>
      <uix:text textBinding="maturityText"/>
    </uix:contents>
  </uix:table>
</uix:header>
