<%--
  - FILE
  -   edit_describe.jsp
  -
  - DESCRIPTION
  -   Gathers the component subtype, name and description.
  -
  - MODIFIED   (MM/DD/YY)
  -   gauragup  07/11/05   - Fix bug-Type appearing when editing a 
  -                          directive/network 
  -   gauragup  06/03/05   - add more fields 
  -   gauragup  05/24/05   - Adding job info message 
  -   gauragup  04/25/05   - remove status as now messageBox is coming at the 
  -                          top 
  -   kashukla  04/05/05   - adding status 
  -   eworth    10/29/04   - eworth_prov_ui_041025
  -   eworth    10/28/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<uix:switcher childNameBinding="operationType@levelOnePage@ProvisionContext@servletRequest">
  <uix:case name="Create">
    <uix:labeledFieldLayout labelWidth="150">
       <uix:messageChoice nameBinding="subtypeName@data@levelOnePage@ProvisionContext@servletRequest"
                     selectedValueBinding="subtypeValue@data@levelOnePage@ProvisionContext@servletRequest"
                     promptBinding="subtypePrompt@levelOnePage@ProvisionContext@servletRequest"
                     renderedBinding="hasSubtypeMetadata@data@levelOnePage@ProvisionContext@servletRequest"
                     required="true">
        <uix:contents
          childDataBinding="subtypeMetadata@data@levelOnePage@ProvisionContext@servletRequest">
            <uix:option textBinding="displayName"  valueBinding="value"/>
        </uix:contents>
      </uix:messageChoice>
    </uix:labeledFieldLayout>
  </uix:case>
  <uix:case name="Edit">
    <uix:labeledFieldLayout labelWidth="150">
      <uix:styledText
          textBinding="subtypePrompt@levelOnePage@ProvisionContext@servletRequest"
          renderedBinding="hasSubtypeMetadata@data@levelOnePage@ProvisionContext@servletRequest"
          styleClass="OraPromptText"/>
        <uix:styledText
          textBinding="subtypeDisplayValue@data@levelOnePage@ProvisionContext@servletRequest"
          renderedBinding="hasSubtypeMetadata@data@levelOnePage@ProvisionContext@servletRequest"
          styleClass="OraDataText"/>
      </uix:labeledFieldLayout>
  </uix:case>
</uix:switcher>

<uix:labeledFieldLayout labelWidth="150">
  <uix:spacer width="20" height="10"/>
  <uix:messageTextInput nameBinding="nameName@data@levelOnePage@ProvisionContext@servletRequest"
                        promptBinding="namePrompt@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="displayName@data@levelOnePage@ProvisionContext@servletRequest"
                        tipBinding="nameTip@levelOnePage@ProvisionContext@servletRequest"
                        required="yes"/>
  <uix:spacer width="20" height="10"/>
  <uix:messageTextInput nameBinding="descName@data@levelOnePage@ProvisionContext@servletRequest"
                        promptBinding="descPrompt@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="description@data@levelOnePage@ProvisionContext@servletRequest"
                        columns="70" maximumLength="100"/>
  <uix:spacer width="20" height="10"/>
  <uix:messageTextInput nameBinding="productName@data@levelOnePage@ProvisionContext@servletRequest"
                        promptBinding="productPrompt@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="product@data@levelOnePage@ProvisionContext@servletRequest"/>
  <uix:spacer width="20" height="10"/>
  <uix:messageTextInput nameBinding="productVersionName@data@levelOnePage@ProvisionContext@servletRequest"
                        promptBinding="productVersionPrompt@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="productVersion@data@levelOnePage@ProvisionContext@servletRequest"/>
  <uix:spacer width="20" height="10"/>
  <uix:messageTextInput nameBinding="vendorName@data@levelOnePage@ProvisionContext@servletRequest"
                        promptBinding="vendorPrompt@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="vendor@data@levelOnePage@ProvisionContext@servletRequest"/>
  <uix:spacer width="20" height="10"/>
  <uix:link textBinding="jobMesg@levelOnePage@ProvisionContext@servletRequest" 
                 destinationBinding="jobURL@levelOnePage@ProvisionContext@servletRequest"
                 renderedBinding="showJobInfo@levelOnePage@ProvisionContext@servletRequest"/>
</uix:labeledFieldLayout>
