<%--
  - FILE
  -   edit_directives.jsp
  -
  - DESCRIPTION
  -   Specify references to directives for the component.
  -
  - MODIFIED   (MM/DD/YY)
  -   gauragup  07/28/05   - Add version to the referred entity 
  -   gauragup  07/15/05   - Fixing ADA bug 
  -   makarapu  05/13/05   - updating alternateTextBinding
  -   eworth    12/10/04   - Replace table layout with a table. 
  -   eworth    11/11/04   - eworth_prov_ui_041101
  -   eworth    11/10/04   - Bind reference field names 
  -   eworth    11/03/04   - Fix layout problem 
  -   eworth    11/02/04   - Add content 
  -   eworth    11/01/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:header textBinding="directivesRefsHeader@levelOnePage@ProvisionContext@servletRequest"
            renderedBinding="directivesRefsRendered@levelOnePage@ProvisionContext@servletRequest">
  <uix:stackLayout>
    <uix:styledText textBinding="directivesRefsDesc@levelOnePage@ProvisionContext@servletRequest"
                    styleClass="OraInstructionText"/>
    <uix:spacer height="10" width="200"/>
  </uix:stackLayout>
  <uix:table nameBinding="tableName@directivesRefs@data@levelOnePage@ProvisionContext@servletRequest"
             width="100%"
             tableDataBinding="resultSet@directivesRefs@data@levelOnePage@ProvisionContext@servletRequest"
             columnFormatsBinding="columnFormats@directivesRefs@data@levelOnePage@ProvisionContext@servletRequest"
             columnHeaderDataBinding="columnFormats@directivesRefs@data@levelOnePage@ProvisionContext@servletRequest"
             alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest">
    <uix:tableSelection>
      <uix:singleSelection selectedIndexBinding="selectedItemIndex@directivesRefs@data@levelOnePage@ProvisionContext@servletRequest"
                            shortDesc="Select">
        <uix:contents childDataBinding="selectionButtons@directivesRefs@data@levelOnePage@ProvisionContext@servletRequest">
          <uix:submitButton textBinding="text"
                            nameBinding="name"
                            valueBinding="value"
                            shortDescBinding="shortDesc"
                            disabledBinding="disabled"/>
        </uix:contents>
      </uix:singleSelection>
    </uix:tableSelection>
    <uix:columnHeaderStamp>
      <uix:text textBinding="text"/>
    </uix:columnHeaderStamp>
    <uix:contents>
      <uix:text textBinding="refNamePrompt"/>
      <uix:text textBinding="refTextValue"/>
      <uix:text textBinding="refVersion"/>
      <uix:text textBinding="maturityText"/>
      <uix:text textBinding="statusText"/>
    </uix:contents>
  </uix:table>
</uix:header>
