<%--
  - FILE
  -   edit_directives_properties.jsp
  -
  - DESCRIPTION
  -   Editor for built-in properties for directives components.
  -
  - MODIFIED   (MM/DD/YY)
  -   makarapu  05/13/05   - add button made part of table level action button
  -   makarapu  05/13/05   - updating alternateTextBinding
  -   eworth    03/09/05   - move command line directly below table and make 
  -                          read-only 
  -   eworth    03/08/05   - Add Shell Type and Argument Table 
  -   eworth    10/29/04   - eworth_prov_ui_041025
  -   eworth    10/29/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:header textBinding="NAME_ArgsList_HEADER@localize@data@levelOnePage@ProvisionContext@servletRequest">
  <uix:stackLayout>
    <uix:styledText textBinding="NAME_ArgsList_DESC@localize@data@levelOnePage@ProvisionContext@servletRequest"
                    styleClass="OraInstructionText"/>
    <uix:spacer width="20" height="10"/>
    <uix:table nameBinding="tableName@NAME_ArgsList@data@levelOnePage@ProvisionContext@servletRequest"
               width="80%"
               tableDataBinding="resultSet@NAME_ArgsList@data@levelOnePage@ProvisionContext@servletRequest"
               columnFormatsBinding="columnFormats@NAME_ArgsList@data@levelOnePage@ProvisionContext@servletRequest"
               columnHeaderDataBinding="columnFormats@NAME_ArgsList@data@levelOnePage@ProvisionContext@servletRequest"
               alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest">
      <uix:tableSelection>
        <uix:singleSelection selectedIndexBinding="selectedItemIndex@NAME_ArgsList@data@levelOnePage@ProvisionContext@servletRequest">
          <uix:contents childDataBinding="selectionButtons@NAME_ArgsList@data@levelOnePage@ProvisionContext@servletRequest">
            <uix:submitButton textBinding="text"
                              nameBinding="name"
                              valueBinding="value"
                              shortDescBinding="shortDesc"
                              disabledBinding="disabled"/>
          </uix:contents>
        </uix:singleSelection>
      </uix:tableSelection>
      <uix:tableActions>
        <uix:button  textBinding="ADD@commonResourceBundle"
                     destination="?event=addRows&source=NAME_ArgsList&size=1"/>
      </uix:tableActions>
      <uix:columnHeaderStamp>
        <uix:text textBinding="text"/>
      </uix:columnHeaderStamp>
      <uix:contents>
        <uix:text textBinding="NAME_ArgsPrefix"/>
        <uix:text textBinding="NAME_ArgsName"/>
        <uix:text textBinding="NAME_ArgsSuffix"/>
      </uix:contents>
    </uix:table>
    <uix:spacer height="10"/>
    <uix:messageStyledText promptBinding="NAME_CmdLine@localize@data@levelOnePage@ProvisionContext@servletRequest"
                           textBinding="NAME_CmdLine@data@levelOnePage@ProvisionContext@servletRequest"
                           contentStyleClass="OraDataText"/>
  </uix:stackLayout>
</uix:header>
<uix:header textBinding="NAME_Other_HEADER@localize@data@levelOnePage@ProvisionContext@servletRequest">
  <uix:labeledFieldLayout labelWidth="150">
    <uix:spacer height="10" />
    <uix:messageChoice name="NAME_Executor"
                       selectedValueBinding="NAME_Executor@data@levelOnePage@ProvisionContext@servletRequest"
                       promptBinding="NAME_Executor@localize@data@levelOnePage@ProvisionContext@servletRequest"
                       required="true">
      <uix:contents childDataBinding="NAME_Executor@enumChoices@data@levelOnePage@ProvisionContext@servletRequest">
         <uix:option textBinding="text"
                     valueBinding="value"/>
      </uix:contents>
    </uix:messageChoice>
    <uix:spacer height="10" />
    <uix:messageCheckBox name="NAME_RunPrivileged"
                         value="true"
                         textBinding="NAME_RunPrivileged@localize@data@levelOnePage@ProvisionContext@servletRequest"
                         checkedBinding="NAME_RunPrivileged@data@levelOnePage@ProvisionContext@servletRequest"/>
    <uix:spacer height="10" />
  </uix:labeledFieldLayout>
</uix:header>
