<%--
  - FILE
  -   edit_disk_properties.jsp
  -
  - DESCRIPTION
  -   Editor for built-in properties for disk layout template components.
  -
  - MODIFIED   (MM/DD/YY)
  -   rshetty   09/06/06   - Fixing raid table and logical volume table	
  -   gauragup  07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                          Attribute 
  -   makarapu  05/13/05   - add button made part of table level action button
  -   makarapu  05/12/05   - Adding a key for alternateTextBinding 
  -   eworth    12/13/04   - eworth_prov_ui_041201
  -   eworth    12/08/04   - Add volume table 
  -   eworth    12/03/04   - Add volumn table 
  -   eworth    12/02/04   - Use multiple tables rather than a tree 
  -   eworth    12/01/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:header textBinding="NAME_HardDisks_HEADER@localize@data@levelOnePage@ProvisionContext@servletRequest">
  <uix:stackLayout>
    <uix:styledText textBinding="NAME_HardDisks_DESC@localize@data@levelOnePage@ProvisionContext@servletRequest"
                    styleClass="OraInstructionText"/>
    <uix:spacer width="20" height="10"/>
    <uix:table nameBinding="tableName@NAME_HardDisks@data@levelOnePage@ProvisionContext@servletRequest"
               width="80%"
               tableDataBinding="resultSet@NAME_HardDisks@data@levelOnePage@ProvisionContext@servletRequest"
               columnFormatsBinding="columnFormats@NAME_HardDisks@data@levelOnePage@ProvisionContext@servletRequest"
               columnHeaderDataBinding="columnFormats@NAME_HardDisks@data@levelOnePage@ProvisionContext@servletRequest"
               alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
               summaryBinding="tableName@NAME_HardDisks@data@levelOnePage@ProvisionContext@servletRequest" >
      <uix:tableSelection>
        <uix:singleSelection selectedIndexBinding="selectedItemIndex@NAME_HardDisks@data@levelOnePage@ProvisionContext@servletRequest">
          <uix:contents childDataBinding="selectionButtons@NAME_HardDisks@data@levelOnePage@ProvisionContext@servletRequest">
            <uix:submitButton textBinding="text"
                              nameBinding="name"
                              valueBinding="value"
                              shortDescBinding="shortDesc"
                              disabledBinding="disabled"/>
          </uix:contents>
        </uix:singleSelection>
      </uix:tableSelection>
      <uix:tableActions>
        <uix:button  textBinding="ADD@commonResourceBundle"
                     destination="?event=addRows&source=NAME_HardDisks&size=1"/>
      </uix:tableActions>
      <uix:columnHeaderStamp>
        <uix:text textBinding="text"/>
      </uix:columnHeaderStamp>
      <uix:contents>
        <uix:text textBinding="NAME_DiskDeviceName"/>
        <uix:text textBinding="NAME_MinDiskSize"/>
        <uix:text textBinding="NAME_MaxDiskSize"/>
      </uix:contents>
    </uix:table>
  </uix:stackLayout>
</uix:header>
<uix:header textBinding="NAME_Partitions_HEADER@localize@data@levelOnePage@ProvisionContext@servletRequest">
  <uix:stackLayout>
    <uix:styledText textBinding="NAME_Partitions_DESC@localize@data@levelOnePage@ProvisionContext@servletRequest"
                    styleClass="OraInstructionText"/>
    <uix:spacer width="20" height="10"/>
    <uix:table nameBinding="tableName@NAME_Partitions@data@levelOnePage@ProvisionContext@servletRequest"
               width="80%"
               tableDataBinding="resultSet@NAME_Partitions@data@levelOnePage@ProvisionContext@servletRequest"
               columnFormatsBinding="columnFormats@NAME_Partitions@data@levelOnePage@ProvisionContext@servletRequest"
               columnHeaderDataBinding="columnFormats@NAME_Partitions@data@levelOnePage@ProvisionContext@servletRequest"
               alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
               summaryBinding="tableName@NAME_Partitions@data@levelOnePage@ProvisionContext@servletRequest">
      <uix:tableSelection>
        <uix:singleSelection selectedIndexBinding="selectedItemIndex@NAME_Partitions@data@levelOnePage@ProvisionContext@servletRequest">
          <uix:contents childDataBinding="selectionButtons@NAME_Partitions@data@levelOnePage@ProvisionContext@servletRequest">
            <uix:submitButton textBinding="text"
                              nameBinding="name"
                              valueBinding="value"
                              shortDescBinding="shortDesc"
                              disabledBinding="disabled"/>
          </uix:contents>
        </uix:singleSelection>
      </uix:tableSelection>
      <uix:tableActions>
        <uix:button  textBinding="ADD@commonResourceBundle"
                     destination="?event=addRows&source=NAME_Partitions&size=1"/>
      </uix:tableActions>
      <uix:columnHeaderStamp>
        <uix:text textBinding="text"/>
      </uix:columnHeaderStamp>
      <uix:contents>
        <uix:text textBinding="NAME_MountPoint"/>
        <uix:text textBinding="NAME_DiskDeviceName"/>
        <uix:text textBinding="NAME_FileSysType"/>
        <uix:text textBinding="NAME_PartitionSize"/>
      </uix:contents>
    </uix:table>
  </uix:stackLayout>
</uix:header>
<uix:header textBinding="NAME_RAIDs_HEADER@localize@data@levelOnePage@ProvisionContext@servletRequest">
  <uix:stackLayout>
    <uix:styledText textBinding="NAME_RAIDs_DESC@localize@data@levelOnePage@ProvisionContext@servletRequest"
                    styleClass="OraInstructionText"/>
    <uix:spacer width="20" height="10"/>
    <uix:table nameBinding="tableName@NAME_RAIDs@data@levelOnePage@ProvisionContext@servletRequest"
               width="80%"
               tableDataBinding="resultSet@NAME_RAIDs@data@levelOnePage@ProvisionContext@servletRequest"
               columnFormatsBinding="columnFormats@NAME_RAIDs@data@levelOnePage@ProvisionContext@servletRequest"
               columnHeaderDataBinding="columnFormats@NAME_RAIDs@data@levelOnePage@ProvisionContext@servletRequest"
               alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
               summaryBinding="tableName@NAME_RAIDs@data@levelOnePage@ProvisionContext@servletRequest">
      <uix:tableSelection>
        <uix:singleSelection selectedIndexBinding="selectedItemIndex@NAME_RAIDs@data@levelOnePage@ProvisionContext@servletRequest">
          <uix:contents childDataBinding="selectionButtons@NAME_RAIDs@data@levelOnePage@ProvisionContext@servletRequest">
            <uix:submitButton textBinding="text"
                              nameBinding="name"
                              valueBinding="value"
                              shortDescBinding="shortDesc"
                              disabledBinding="disabled"/>
          </uix:contents>
        </uix:singleSelection>
      </uix:tableSelection>
      <uix:tableActions>
        <uix:button  textBinding="ADD@commonResourceBundle"
                     destination="?event=addRows&source=NAME_RAIDs&size=1"/>
      </uix:tableActions>
      <uix:columnHeaderStamp>
        <uix:text textBinding="text"/>
      </uix:columnHeaderStamp>
      <uix:contents>
        <uix:text textBinding="NAME_MountPoint"/>
        <uix:text textBinding="NAME_RAIDLevel"/>
        <uix:text textBinding="NAME_Partitions"/>
        <uix:text textBinding="NAME_FileSysType"/>
      </uix:contents>
    </uix:table>
  </uix:stackLayout>
</uix:header>
<uix:header textBinding="NAME_LogicalVolumeGroups_HEADER@localize@data@levelOnePage@ProvisionContext@servletRequest">
  <uix:stackLayout>
    <uix:styledText textBinding="NAME_LogicalVolumeGroups_DESC@localize@data@levelOnePage@ProvisionContext@servletRequest"
                    styleClass="OraInstructionText"/>
    <uix:spacer width="20" height="10"/>
    <uix:table nameBinding="tableName@NAME_LogicalVolumeGroups@data@levelOnePage@ProvisionContext@servletRequest"
               width="80%"
               tableDataBinding="resultSet@NAME_LogicalVolumeGroups@data@levelOnePage@ProvisionContext@servletRequest"
               columnFormatsBinding="columnFormats@NAME_LogicalVolumeGroups@data@levelOnePage@ProvisionContext@servletRequest"
               columnHeaderDataBinding="columnFormats@NAME_LogicalVolumeGroups@data@levelOnePage@ProvisionContext@servletRequest"
               alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
               summaryBinding="tableName@NAME_LogicalVolumeGroups@data@levelOnePage@ProvisionContext@servletRequest">
      <uix:tableSelection>
        <uix:singleSelection selectedIndexBinding="selectedItemIndex@NAME_LogicalVolumeGroups@data@levelOnePage@ProvisionContext@servletRequest">
          <uix:contents childDataBinding="selectionButtons@NAME_LogicalVolumeGroups@data@levelOnePage@ProvisionContext@servletRequest">
            <uix:submitButton textBinding="text"
                              nameBinding="name"
                              valueBinding="value"
                              shortDescBinding="shortDesc"
                              disabledBinding="disabled"/>
          </uix:contents>
        </uix:singleSelection>
      </uix:tableSelection>
      <uix:tableActions>
        <uix:button  textBinding="ADD@commonResourceBundle"
                     destination="?event=addRows&source=NAME_LogicalVolumeGroups&size=1"/>
      </uix:tableActions>
      <uix:columnHeaderStamp>
        <uix:text textBinding="text"/>
      </uix:columnHeaderStamp>
      <uix:contents>
        <uix:text textBinding="NAME_LogicalGroupName"/>
        <uix:text textBinding="NAME_Partitions"/>
	<uix:text textBinding="NAME_RAIDs"/>
      </uix:contents>
    </uix:table>
  </uix:stackLayout>
</uix:header>
<uix:header textBinding="NAME_LogicalVolumes_HEADER@localize@data@levelOnePage@ProvisionContext@servletRequest">
  <uix:stackLayout>
    <uix:styledText textBinding="NAME_LogicalVolumes_DESC@localize@data@levelOnePage@ProvisionContext@servletRequest"
                    styleClass="OraInstructionText"/>
    <uix:spacer width="20" height="10"/>
    <uix:table nameBinding="tableName@NAME_LogicalVolumes@data@levelOnePage@ProvisionContext@servletRequest"
               width="80%"
               tableDataBinding="resultSet@NAME_LogicalVolumes@data@levelOnePage@ProvisionContext@servletRequest"
               columnFormatsBinding="columnFormats@NAME_LogicalVolumes@data@levelOnePage@ProvisionContext@servletRequest"
               columnHeaderDataBinding="columnFormats@NAME_LogicalVolumes@data@levelOnePage@ProvisionContext@servletRequest"
               alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
               summaryBinding="tableName@NAME_LogicalVolumes@data@levelOnePage@ProvisionContext@servletRequest">
      <uix:tableSelection>
        <uix:singleSelection selectedIndexBinding="selectedItemIndex@NAME_LogicalVolumes@data@levelOnePage@ProvisionContext@servletRequest">
          <uix:contents childDataBinding="selectionButtons@NAME_LogicalVolumes@data@levelOnePage@ProvisionContext@servletRequest">
            <uix:submitButton textBinding="text"
                              nameBinding="name"
                              valueBinding="value"
                              shortDescBinding="shortDesc"
                              disabledBinding="disabled"/>
          </uix:contents>
        </uix:singleSelection>
      </uix:tableSelection>
      <uix:tableActions>
        <uix:button  textBinding="ADD@commonResourceBundle"
                     destination="?event=addRows&source=NAME_LogicalVolumes&size=1"/>
      </uix:tableActions>
      <uix:columnHeaderStamp>
        <uix:text textBinding="text"/>
      </uix:columnHeaderStamp>
      <uix:contents>
        <uix:text textBinding="NAME_MountPoint"/>
        <uix:text textBinding="NAME_LogicalVolumeName"/>
        <uix:text textBinding="NAME_LogicalGroupName"/>
        <uix:text textBinding="NAME_FileSysType"/>
        <uix:text textBinding="NAME_PartitionSize"/>
      </uix:contents>
    </uix:table>
  </uix:stackLayout>
</uix:header>
