<%--
  - FILE
  -   edit_linux_properties.jsp
  -
  - DESCRIPTION
  -   Editor for built-in properties for Linux OS software components.
  -
  - MODIFIED   (MM/DD/YY)
  -   sacgoel   11/17/06   - Fix for root password required field
  -   sacgoel   11/06/06   - fixed bug 5624008
  -   jhazra    09/14/05   - disable the MD5 checkbox 
  -   suvmalho  09/20/05   - fixing bug 4609540 
  -   kashukla  09/08/05   - fixing bug-4594222 
  -   jhazra    09/01/05   - turnoff autocomplete for secure props 
  -   gauragup  08/09/05   - Removing * from password fields 
  -   gauragup  07/27/05   - making some props mandatory 
  -   rbhanush  06/08/05   - Removing RPM links checkbox option
  -   rbhanush  03/18/05   - fix rpm repository dropdown list
  -   eworth    03/15/05   - fix check boxes and drop-down lists
  -   wsmit     03/07/05   - fix target selector
  -   wsmit     02/03/05   - add target selector 
  -   eworth    11/30/04   - eworth_prov_ui_041112
  -   eworth    11/19/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:labeledFieldLayout labelWidth="150">
  <uix:messageTextInput name="NAME_Hostname"
                       promptBinding="NAME_RefInstallation@localize@data@levelOnePage@ProvisionContext@servletRequest"
                       textBinding="NAME_Hostname@data@levelOnePage@ProvisionContext@servletRequest"
                       tipBinding="NAME_RefInstallationTip@localize@data@levelOnePage@ProvisionContext@servletRequest"
                       columns="80"
                       required="yes"/>
  <uix:spacer width="20" height="10"/>
<%--
  <oem:targetSelection textBinding="selectTargetLabel@levelOnePage@ProvisionContext@servletRequest" event="initializeTargetSelection:NAME_RefInstallation"/>
--%>
  <oem:targetSelection textBinding="selectTargetLabel@levelOnePage@ProvisionContext@servletRequest" event="initializeTargetSelection:NAME_Hostname"/>

  <uix:spacer width="20" height="10"/>

 <uix:include nodeBinding="NAME_RpmRepository@data@levelOnePage@ProvisionContext@servletRequest" />
  
  <uix:spacer width="20" height="10"/>

  <uix:messageChoice name="NAME_TimeZone"
                     selectedValueBinding="NAME_TimeZone@data@levelOnePage@ProvisionContext@servletRequest"
                     promptBinding="NAME_TimeZone@localize@data@levelOnePage@ProvisionContext@servletRequest">
    <uix:contents childDataBinding="NAME_TimeZone@enumChoices@data@levelOnePage@ProvisionContext@servletRequest">
       <uix:option textBinding="text"
                   valueBinding="value"/>
    </uix:contents>
  </uix:messageChoice>

  <uix:spacer width="20" height="10"/>
  <uix:messageCheckBox name="NAME_UseUtcClock"
                       value="true"
                       promptBinding="NAME_UseUtcClock@localize@data@levelOnePage@ProvisionContext@servletRequest"
                       checkedBinding="NAME_UseUtcClock@data@levelOnePage@ProvisionContext@servletRequest"/>
  <uix:spacer width="20" height="10"/>
  <uix:messageCheckBox name="NAME_RootPasswordEncrypt"
                       value="true"
                       readOnly="true"
                       promptBinding="NAME_RootPasswordEncrypt@localize@data@levelOnePage@ProvisionContext@servletRequest"
                       checked="true"
		       disabled="true"
                       textBinding="NAME_RootPasswordEncryptTip@localize@data@levelOnePage@ProvisionContext@servletRequest"/>
  <uix:spacer width="20" height="10"/>
  <uix:messageTextInput name="NAME_RootPassword"
                        secret="false" 
                        noAutoComplete="true"
                        promptBinding="NAME_RootPassword@localize@data@levelOnePage@ProvisionContext@servletRequest"
			textBinding="NAME_RootPassword@data@levelOnePage@ProvisionContext@servletRequest"
			required="yes"/>
  <uix:spacer width="20" height="10"/>
  <uix:messageTextInput name="NAME_RootPasswordConf"
                        secret="false"
	                noAutoComplete="true"
                        promptBinding="NAME_RootPasswordConf@localize@data@levelOnePage@ProvisionContext@servletRequest"
			textBinding="NAME_RootPasswordConf@data@levelOnePage@ProvisionContext@servletRequest"
			required="yes"/>
  <uix:spacer width="20" height="10"/>
  <uix:messageCheckBox name="NAME_InstallMode"
                       value="true"
                       promptBinding="NAME_InstallMode@localize@data@levelOnePage@ProvisionContext@servletRequest"
                       checkedBinding="NAME_InstallMode@data@levelOnePage@ProvisionContext@servletRequest"
                       textBinding="NAME_InstallModeTip@localize@data@levelOnePage@ProvisionContext@servletRequest"/>
  <uix:spacer width="20" height="10"/>
</uix:labeledFieldLayout>
