<%--
  - FILE
  -   edit_network_properties.jsp
  -
  - DESCRIPTION
  -   Editor for built-in properties for the network profile component.
  -
  - MODIFIED   (MM/DD/YY)
  -   gauragup  07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                          Attribute 
  -   ashwikum  06/04/05   - Support various kinds of network adapters 
  -   makarapu  05/13/05   - add button made part of table level action button
  -   makarapu  05/13/05   - updating alternateTextBinding
  -   eworth    11/30/04   - eworth_prov_ui_041112
  -   eworth    11/29/04   - Use submit buttons 
  -   eworth    11/18/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:header textBinding="NAME_NetworkConfig@localize@data@levelOnePage@ProvisionContext@servletRequest">
  <uix:contents>
    <uix:table nameBinding="tableName@NAME_NetworkConfig@data@levelOnePage@ProvisionContext@servletRequest"
               width="100%"
               tableDataBinding="resultSet@NAME_NetworkConfig@data@levelOnePage@ProvisionContext@servletRequest"
               columnFormatsBinding="columnFormats@NAME_NetworkConfig@data@levelOnePage@ProvisionContext@servletRequest"
               columnHeaderDataBinding="columnFormats@NAME_NetworkConfig@data@levelOnePage@ProvisionContext@servletRequest"
               alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
               summaryBinding="tableName@NAME_NetworkConfig@data@levelOnePage@ProvisionContext@servletRequest">
      <uix:tableSelection>
        <uix:singleSelection selectedIndexBinding="selectedItemIndex@NAME_NetworkConfig@data@levelOnePage@ProvisionContext@servletRequest">
          <uix:contents childDataBinding="selectionButtons@NAME_NetworkConfig@data@levelOnePage@ProvisionContext@servletRequest">
            <uix:submitButton textBinding="text"
                              nameBinding="name"
                              valueBinding="value"
                              shortDescBinding="shortDesc"
                              disabledBinding="disabled"/>
          </uix:contents>
        </uix:singleSelection>
      </uix:tableSelection>
      <uix:tableActions>
        <uix:flowLayout>
          <uix:contents>
            <uix:button textBinding="LBL_AddStaticAdapter@localize@data@levelOnePage@ProvisionContext@servletRequest"
                        destination="?event=addRows&source=NAME_NetworkConfig&size=1&adapterType=static"/>
            <uix:button textBinding="LBL_AddDynamicAdapter@localize@data@levelOnePage@ProvisionContext@servletRequest"
                        destination="?event=addRows&source=NAME_NetworkConfig&size=1&adapterType=dynamic"/>
            <uix:button textBinding="LBL_AddNetConfigAdapter@localize@data@levelOnePage@ProvisionContext@servletRequest"
                        destination="?event=addRows&source=NAME_NetworkConfig&size=1&adapterType=netconfig"/>
          </uix:contents>
        </uix:flowLayout>
      </uix:tableActions>
      <uix:columnHeaderStamp>
        <uix:text textBinding="text"/>
      </uix:columnHeaderStamp>
      <uix:contents>
        <uix:text textBinding="NAME_DeviceName"/>
        <uix:text textBinding="NAME_NetworkName"/>
        <uix:text textBinding="NAME_Hostname"/>
        <uix:text textBinding="NAME_DomainName"/>
        <uix:text textBinding="NAME_AddrType"/>
        <uix:text textBinding="NAME_IPAddr"/>
        <uix:text textBinding="NAME_SubnetMask"/>
        <uix:text textBinding="NAME_Gateways"/>
        <uix:text textBinding="NAME_DNSServers"/>
      </uix:contents>
    </uix:table>
  </uix:contents>
</uix:header>
