<%--
  - FILE
  -   edit_property.jsp
  -
  - DESCRIPTION
  -   Principal page for viewing/editing properties.
  -
  - MODIFIED   (MM/DD/YY)
  -   gauragup   11/17/05   - Fixing 4691805, getting localized button texts 
  -   rattipal   12/05/05   - Backport gauragup_cbugs from main 
  -   rattipal   12/04/05   - Backport gauragup_bugs1 from main 
  -   gauragup   11/11/05   - Adding nodestamp to hgrid 
  -   rattipal   12/05/05   - Backport gauragup_bugs1 from main 
  -   gauragup   11/11/05   - Adding nodestamp to hgrid 
  -   gauragup   07/15/05   - Fixing ADA bug 
  -   jhazra     12/15/04   - Move from levelOnePage context to any pageContext
  -   jhazra     12/09/04   - jhazra_edit2
  -   jhazra     11/18/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page content within the editor is within this tag--%>

<uix:buildTree nodeID="pageContent" scope="request">
  <uix:subTabLayout>
    <%--Display the subtabs--%>
    <uix:subTabs>
      <uix:subTabBar selectedIndexBinding="tab@PageContext@ProvisionContext@servletRequest">
        <uix:contents childDataBinding="allTabs@PageContext@ProvisionContext@servletRequest">
          <uix:link textBinding="text" shortDescBinding="shortDesc"
            destinationBinding="destination" renderedBinding="rendered"
            onClick="submitForm()"/>
        </uix:contents>
      </uix:subTabBar>
    </uix:subTabs>
    <uix:tableLayout width="100%" cellSpacing="10">
        <uix:rowLayout>
          <uix:cellFormat columnSpan="2">
            <uix:hGrid id="propEditTree"
                       treeDataBinding="rootNode@data@pageContext@servletRequest"
                       formSubmitted="true"
                       formSubmittedBinding="true"
                       columnHeaderDataBinding="columnHeader@data@pageContext@servletRequest"
                       columnFormatsBinding="columnHeader@data@pageContext@servletRequest"
                       summary="Property Edit Tree">
              <uix:nodeStamp>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="nodeColumnHeader@search@ProvisionContext@servletRequest"/>
                  </uix:columnHeader>
                  <uix:styledText textBinding="text"/>
                </uix:column>
              </uix:nodeStamp>
              <uix:tableSelection>
                
                <uix:singleSelection selectedIndexBinding="selectedIndex@data@pageContext@servletRequest"
                  renderedBinding="isSelectable"
                  shortDesc="Select">
                  <uix:contents>
                    <uix:submitButton textBinding="editButton@data@pageContext@servletRequest"
                                destination="../components/edit_property?event=edit"
                                renderedBinding="isReadOnly@data@pageContext@servletRequest"
                                name="event" 
                                value="edit"/>
                    <uix:submitButton textBinding="readOnlyButton@data@pageContext@servletRequest"
                                destination="../components/edit_property?event=readOnly"
                                renderedBinding="isEditable@data@pageContext@servletRequest"
                                name="event" 
                                value="readOnly"/>
                    <uix:submitButton textBinding="addFieldButton@data@pageContext@servletRequest"
                                destination="../components/edit_property?event=addField"
                                renderedBinding="isEditable@data@pageContext@servletRequest"
                                name="event" 
                                value="addField"/>
                    <uix:submitButton textBinding="removeFieldButton@data@pageContext@servletRequest"
                                destination="../components/edit_property?event=removeField"
                                renderedBinding="isEditable@data@pageContext@servletRequest"
                                name="event" 
                                value="removeField"/>
                  </uix:contents>
                  <%--
                  <uix:primaryClientAction>
                    <uix:fireAction event="selectEvent"
                                    source="TreeButton"/>
                  </uix:primaryClientAction>
                  --%>
                </uix:singleSelection>
              </uix:tableSelection>
              <uix:columnHeaderStamp>
                <uix:text textBinding="text"/>
              </uix:columnHeaderStamp>
              
              <uix:contents>
                <uix:include nodeBinding="value"/>
                <%--uix:text textBinding="initValue"/--%>
              </uix:contents>
            </uix:hGrid>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
            <uix:formValue name="nodeId" />
        </uix:rowLayout>
    </uix:tableLayout>
  </uix:subTabLayout>
  <script>
    function hanldeNodeClick(id)
    {
        submitForm('propertyForm',0,{'event':'expand', 'nodeId' : id});
    }
  </script>  
</uix:buildTree>
<%@ include file="/provision/pageTemplate.jspf" %>

