<%--
  - FILE
  -   edit_upload.jsp
  -
  - DESCRIPTION
  -   Component binary file upload form.
  -
  - MODIFIED   (MM/DD/YY)
  -   ramalhot  03/07/06 - 
  -   kashukla  08/25/05 - adding file viewer/editor support 
  -   kashukla  07/26/05   - 
  -   kashukla  05/19/05   - adding select target button 
  -   kashukla  04/18/05   - adding more upload options 
  -   eworth    10/29/04   - eworth_prov_ui_041025
  -   eworth    10/29/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>



<uix:labeledFieldLayout width="70%">
  <uix:contents>
      <uix:messageStyledText promptBinding="currentFilenamePrompt@levelOnePage@ProvisionContext@servletRequest"
                                 textBinding="filenameValue@data@levelOnePage@ProvisionContext@servletRequest"
                                 destinationBinding="viewFilename@data@levelOnePage@ProvisionContext@servletRequest"
                                 styleClass="OraDataText"/>
   </uix:contents>
   
</uix:labeledFieldLayout>
                                                              


<uix:stackLayout>
  <uix:contents>
    <uix:messageRadioButton name="uploadCriteria"

		     textBinding="uploadLaterName@data@levelOnePage@ProvisionContext@servletRequest" 
		     selectedBinding="uploadLater@data@levelOnePage@ProvisionContext@servletRequest" 
		     value="localMachine"
		     onClick="handleUploadMechanism('uploadLater')"
		     />



    <uix:radioButton name="uploadCriteria"
		textBinding="uploadAgentName@data@levelOnePage@ProvisionContext@servletRequest" 
		selectedBinding="uploadFromAgentMachine@data@levelOnePage@ProvisionContext@servletRequest" 
		value="uploadthruJob"
		onClick="handleUploadMechanism('uploadFromAgentMachine')"
     />
	<uix:labeledFieldLayout labelWidth="150" 
				renderedBinding="uploadFromAgentMachine@data@levelOnePage@ProvisionContext@servletRequest">
		<uix:messageTextInput nameBinding="hostName@data@levelOnePage@ProvisionContext@servletRequest"
                                        textBinding="hostNameValue@data@levelOnePage@ProvisionContext@servletRequest"
					promptBinding="hostNamePrompt@data@levelOnePage@ProvisionContext@servletRequest"
					required="yes"
                                        disabled="true">
                    <uix:end>
                        <oem:targetSelection textBinding="selectTargetLabel@levelOnePage@ProvisionContext@servletRequest" event="initializeTargetSelection:hostNameValue"/>
                    </uix:end>
                </uix:messageTextInput>
                

                <uix:messageTextInput nameBinding="filenameName@data@levelOnePage@ProvisionContext@servletRequest"
                                      promptBinding="filenamePrompt@levelOnePage@ProvisionContext@servletRequest"
                                      required="yes"
                                      disabled="false"
                                      id="fileName">
                    <uix:end>
                        <uix:button textBinding="selectFilename@data@levelOnePage@ProvisionContext@servletRequest"
                                        onClick="launchRfs(\"handleRfsLaunch\");"/>
                    </uix:end>
                </uix:messageTextInput>
	</uix:labeledFieldLayout>

    <uix:radioButton name="uploadCriteria"

		     textBinding="uploadLocalName@data@levelOnePage@ProvisionContext@servletRequest" 
		     selectedBinding="uploadFromLocalMachine@data@levelOnePage@ProvisionContext@servletRequest" 
		     value="localMachine"
		     onClick="handleUploadMechanism('uploadFromLocalMachine')"
		     />
      <uix:labeledFieldLayout labelWidth="150"
				renderedBinding="uploadFromLocalMachine@data@levelOnePage@ProvisionContext@servletRequest">
        <uix:messageFileUpload nameBinding="filenameName@data@levelOnePage@ProvisionContext@servletRequest"
                                promptBinding="filenamePrompt@levelOnePage@ProvisionContext@servletRequest"
                                tipBinding="uploadMesgTip@levelOnePage@ProvisionContext@servletRequest"
                                required="yes"/>
      </uix:labeledFieldLayout>
  </uix:contents>
      <script>

       function myCallBack(lovWindow, event)
       {
           return true;
       }

       function launchRfs(obj)
       {
           openWindow(top, '../../page/rfs/postBackWithEvent$event='+obj, 'lovWindow', {width:750, height:550}, true, 'dialog', myCallBack);
       }

      
      function handleUploadMechanism(obj)
       {
        formObj = document.forms[0];
        var url = formObj.action+"?event=toggleUploadMechanism&uploadMechanism="+obj;
        window.location.href = url;
       }
      </script>
</uix:stackLayout>
