<%--
  - FILE
  -   map_form.jsp
  -
  - DESCRIPTION
  -   Page for editing a map of named values on a form.
  -
  - MODIFIED   (MM/DD/YY)
  -   eworth    12/08/04   - Support list of enumerated types 
  -   eworth    12/03/04   - Support tip text for enumerated types 
  -   eworth    11/30/04   - eworth_prov_ui_041112
  -   eworth    11/29/04   - Add value binding to options 
  -   eworth    11/16/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:labeledFieldLayout labelWidth="150">
    <uix:contents childDataBinding="fields@map@pageContext@servletRequest">
      <uix:switcher childNameBinding="typeCode">
        <uix:case name="TYPE_Enumerated">
          <uix:messageChoice nameBinding="name"
                             selectedValueBinding="value"
                             promptBinding="prompt"
                             tipBinding="tip">
            <uix:contents childDataBinding="choices">
               <uix:option textBinding="text" valueBinding="value"/>
            </uix:contents>
          </uix:messageChoice>
        </uix:case>
        <uix:case name="TYPE_ListOfEnumerated">
          <uix:messageList nameBinding="name"
                           multiple="true"
                           promptBinding="prompt"
                           tipBinding="tip">
            <uix:contents childDataBinding="choices">
               <uix:option textBinding="text" valueBinding="value"/>
            </uix:contents>
          </uix:messageList>
        </uix:case>
        <uix:default>
          <uix:messageTextInput nameBinding="name"
                                promptBinding="prompt"
                                textBinding="value"
                                tipBinding="tip"/>
        </uix:default>
      </uix:switcher>
      <uix:spacer width="100" height="10"/>
    </uix:contents>
  </uix:labeledFieldLayout>
</uix:buildTree>
<%@ include file="/provision/pageTemplate.jspf" %>
