<%--
  - FILE
  -   select_clone_source.jsp
  -
  - DESCRIPTION
  -   LOV that allows the user to select a clonable home to be archived in the 
  -   software library.
  -
  - MODIFIED   (MM/DD/YY)
  -   audupi    09/15/05   - Licensing changes 
  -   audupi    09/05/05   - 4590333 - Adding alternate text for source-home 
  -                          table 
  -   gauragup  07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                          Attribute 
  -   audupi    07/07/05   - 4467739 - Addition of maximum length for 
  -                          text-input 
  -   mnosseir  01/17/05   - add search fields 
  -   mnosseir  12/10/04   - mnosseir_clone_comp_packager
  -   mnosseir  11/22/04   - Creation
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:rowLayout>
    <uix:labeledFieldLayout width="30">
      <uix:messageChoice promptBinding="LBL_SearchCols@pageContext@servletRequest" name="searchCol">
        <uix:contents childDataBinding="searchCols@pageContext@servletRequest">
          <uix:option textBinding="text" valueBinding="value"/>
        </uix:contents>
      </uix:messageChoice>
    </uix:labeledFieldLayout>
    <uix:spacer width="20"/>
    <uix:messageTextInput promptBinding="LBL_SearchVal@pageContext@servletRequest" columns="40" name="searchVal" maximumLength="1024"/>
    <uix:submitButton textBinding="LBL_goBtn@pageContext@servletRequest" name="go" event="go_search"/>
  </uix:rowLayout>
  <uix:spacer height="20"/>

    <uix:table tableDataBinding="cloneHomes@pageContext@servletRequest" columnHeaderDataBinding="colHeaders@pageContext@servletRequest" blockSize="10" nameBinding="cloneHomesTbl@pageContext@servletRequest" valueBinding="value@pageContext@servletRequest" maxValueBinding="maxSize@pageContext@servletRequest" summaryBinding="cloneHomesTbl@pageContext@servletRequest" width="100%" alternateTextBinding="altNoHomes@pageContext@servletRequest">
      <uix:singleSelection selectedIndex="0" shortDesc="Select"/>
      <uix:column>
        <uix:styledText textBinding="host"/>
      </uix:column>
      <uix:column>
        <oem:license>
          <uix:link textBinding="locHome" destinationBinding="dest"/>
        </oem:license>
      </uix:column>
      <uix:column>
        <uix:styledText textBinding="platform"/>
      </uix:column>
      <uix:column>
        <uix:styledText textBinding="targets"/>
      </uix:column>
      <uix:column>
        <uix:styledText textBinding="products"/>
      </uix:column>
      <uix:columnHeaderStamp>
        <uix:styledText textBinding="hdr">
        </uix:styledText>
      </uix:columnHeaderStamp>
    </uix:table>
</uix:buildTree>
<%@ include file="/provision/pageTemplate.jspf" %>
