<%--
  - FILE
  -   view_hardware_profile.jsp
  -
  - DESCRIPTION
  -   Viewer for built-in properties for the hardware profile component.
  -
  - MODIFIED   (MM/DD/YY)
  -   gauragup  07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                          Attribute 
  -   makarapu  05/13/05   - updating alternateTextBinding
  -   wsmit     12/16/04   - wsmit_viewer_files
  -   wsmit     12/13/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:header textBinding="MSG_CpuInfoHeader@localize@data@levelOnePage@ProvisionContext@servletRequest">
  <uix:labeledFieldLayout labelWidth="200">
    <uix:messageChoice name="NAME_CpuType"
                       selectedValueBinding="NAME_CpuType@data@levelOnePage@ProvisionContext@servletRequest"
                       promptBinding="NAME_CpuType@localize@data@levelOnePage@ProvisionContext@servletRequest"
                       readOnly="true">
      <uix:contents childDataBinding="cpuTypes@data@levelOnePage@ProvisionContext@servletRequest">
         <uix:option textBinding="displayValueKey"
                     valueBinding="messageKeyKey"/>
      </uix:contents>
    </uix:messageChoice>
    <uix:spacer width="20" height="10"/>
    <uix:messageTextInput name="NAME_MinCpuNumber"
                        promptBinding="NAME_MinCpuNumber@localize@data@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="NAME_MinCpuNumber@data@levelOnePage@ProvisionContext@servletRequest"
                        readOnly="true"/>
    <uix:spacer width="20" height="10"/>
    <uix:messageTextInput name="NAME_MaxCpuNumber"
                        promptBinding="NAME_MaxCpuNumber@localize@data@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="NAME_MaxCpuNumber@data@levelOnePage@ProvisionContext@servletRequest"
                        readOnly="true"/>
    <uix:spacer width="20" height="10"/>
    <uix:messageTextInput name="NAME_MinCpuSpeed"
                        promptBinding="NAME_MinCpuSpeed@localize@data@levelOnePage@ProvisionContext@servletRequest"
                        tipBinding="NAME_CpuSpeedTip@localize@data@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="NAME_MinCpuSpeed@data@levelOnePage@ProvisionContext@servletRequest"
                        readOnly="true"/>
    <uix:spacer width="20" height="10"/>
    <uix:messageTextInput name="NAME_MaxCpuSpeed"
                        promptBinding="NAME_MaxCpuSpeed@localize@data@levelOnePage@ProvisionContext@servletRequest"
                        tipBinding="NAME_CpuSpeedTip@localize@data@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="NAME_MaxCpuSpeed@data@levelOnePage@ProvisionContext@servletRequest"
                        readOnly="true"/>
    <uix:spacer width="20" height="10"/>
  </uix:labeledFieldLayout>
</uix:header>
<uix:header textBinding="MSG_RamInfoHeader@localize@data@levelOnePage@ProvisionContext@servletRequest">
  <uix:labeledFieldLayout labelWidth="200">
    <uix:messageTextInput name="NAME_MinRam"
                        promptBinding="NAME_MinRam@localize@data@levelOnePage@ProvisionContext@servletRequest"
                        tipBinding="NAME_RamTip@localize@data@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="NAME_MinRam@data@levelOnePage@ProvisionContext@servletRequest"
                        readOnly="true"/>
    <uix:spacer width="20" height="10"/>
    <uix:messageTextInput name="NAME_MaxRam"
                        promptBinding="NAME_MaxRam@localize@data@levelOnePage@ProvisionContext@servletRequest"
                        tipBinding="NAME_RamTip@localize@data@levelOnePage@ProvisionContext@servletRequest"
                        textBinding="NAME_MaxRam@data@levelOnePage@ProvisionContext@servletRequest"
                        readOnly="true"/>
    <uix:spacer width="20" height="10"/>
  </uix:labeledFieldLayout>
</uix:header>
<uix:header textBinding="NAME_NetworkAdapters_HEADER@localize@data@levelOnePage@ProvisionContext@servletRequest">
  <uix:stackLayout>
    <uix:styledText textBinding="NAME_NetworkAdapters_DESC@data@levelOnePage@ProvisionContext@servletRequest"
                    styleClass="OraInstructionText"/>
    <uix:spacer width="20" height="10"/>
    <uix:table nameBinding="tableName@NAME_NetworkAdapters@data@levelOnePage@ProvisionContext@servletRequest"
               width="80%"
               tableDataBinding="resultSet@NAME_NetworkAdapters@data@levelOnePage@ProvisionContext@servletRequest"
               columnFormatsBinding="columnFormats@NAME_NetworkAdapters@data@levelOnePage@ProvisionContext@servletRequest"
               columnHeaderDataBinding="columnFormats@NAME_NetworkAdapters@data@levelOnePage@ProvisionContext@servletRequest"
               alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
               summaryBinding="tableName@NAME_NetworkAdapters@data@levelOnePage@ProvisionContext@servletRequest">
<%--
      <uix:tableSelection>
        <uix:singleSelection selectedIndexBinding="selectedItemIndex@NAME_NetworkAdapters@data@levelOnePage@ProvisionContext@servletRequest">
          <uix:contents childDataBinding="selectionButtons@NAME_NetworkAdapters@data@levelOnePage@ProvisionContext@servletRequest">
            <uix:submitButton textBinding="text"
                              nameBinding="name"
                              valueBinding="value"
                              shortDescBinding="shortDesc"
                              disabledBinding="disabled"/>
          </uix:contents>
        </uix:singleSelection>
      </uix:tableSelection>
      --%>
      <uix:columnHeaderStamp>
        <uix:text textBinding="text"/>
      </uix:columnHeaderStamp>
      <uix:contents>
        <uix:text textBinding="NAME_AdapterName"/>
        <uix:text textBinding="NAME_AdapterType"/>
      </uix:contents>
    </uix:table>
  </uix:stackLayout>
</uix:header>
