<%--
  - FILE
  -   cluster_body.jsp
  -
  - DESCRIPTION
  -   A template to be included in JSPs to show the cluster page.
  -
  - MODIFIED   (MM/DD/YY)
  -   gauragup  07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                          Attribute 
  -   jhazra    06/11/05   - jhazra_cluster
  -   jhazra    05/18/05   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
  <uix:tableLayout width="100%" cellSpacing="10" hAlign="center" 
                   renderedBinding="isDefaultSearch@ProvisionContext@servletRequest">
      <uix:rowLayout>
       <uix:rowLayout>
        <uix:messageChoice name="filterChoice"
                           selectedValueBinding="selectedValue@criteria@search@ProvisionContext@servletRequest"
                           promptBinding="VIEW@commonResourceBundle">
          <uix:contents childDataBinding="filterChoices@criteria@search@ProvisionContext@servletRequest">
             <uix:option textBinding="text" valueBinding="value"/>
          </uix:contents>
        </uix:messageChoice>
        <uix:spacer height="1" width="10"/>
         <uix:submitButton name="event" value="doSimpleSearch"
            textBinding="GO@commonResourceBundle"/>
       </uix:rowLayout>
      </uix:rowLayout>
        <uix:table id="ClusterTable"
                   width="100%"
                   tableDataBinding="dataList@resultSet@search@ProvisionContext@servletRequest"
                   columnHeaderDataBinding="columnHeaderData@search@ProvisionContext@servletRequest"
                   columnFormatsBinding="columnFormats@search@ProvisionContext@servletRequest"
                   alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
                   summary="Cluster Table">
          <uix:tableSelection>
            <uix:singleSelection selectedIndexBinding="selectedItemIndex@search@ProvisionContext@servletRequest"
                primaryClientActionBinding="clientAction@search@ProvisionContext@servletRequest"
                shortDesc="Select">
              <uix:contents childDataBinding="selectionButtons@search@ProvisionContext@servletRequest">
                <uix:submitButton textBinding="text"
                                  shortDescBinding="shortDesc"
                                  nameBinding="name"
                                  valueBinding="value"
                                  disabledBinding="disabled"
                                  renderedBinding="rendered"/>
              </uix:contents>
            </uix:singleSelection>
          </uix:tableSelection>
          <uix:columnHeaderStamp>
            <uix:text textBinding="text"/>
          </uix:columnHeaderStamp>
          <uix:contents>
            <uix:text textBinding="name"/>
            <uix:text textBinding="desc"/>
            <uix:text textBinding="imagePath"/>
            <uix:text textBinding="status"/>
            <uix:text textBinding="suiteInst"/>
            <uix:text textBinding="assignment"/>
            <uix:text textBinding="nodeCount"/>
          </uix:contents>
        </uix:table>      
  </uix:tableLayout>
