<%--
  - FILE
  -   hardware.jsp
  -
  - DESCRIPTION
  -   Principal page for hardware server search and selection.
  -
  - MODIFIED   (MM/DD/YY)
  - kashukla   07/31/05   - adding Current Assignment column 
  - gauragup   07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                         Attribute 
  - rmadampa   05/13/05   - drop down changes 
  - ashwikum   04/25/05   - Fixing alignment bug 
  - ashwikum   04/22/05   - Fixing UI bugs 
  - ashwikum   03/09/05   - Changing name pattern parameter 
  - ashwikum   02/02/05   - Preliminary UI review 
  - ashwikum   01/17/05   - Supporting button tip 
  - ashwikum   12/16/04   - Adding open window popup to search tips 
  - ashwikum   12/09/04   - Adding search tip and other functionalities 
  - ashwikum   12/06/04   - Modification for supporting hyperlink based 
  -                         property view for hardware displayed in a row 
  - ashwikum   11/05/04   - Adding advanced search support 
  - ashwikum   11/02/04   - ashwikum_hardwareui
  - ashwikum   10/25/04   - Adding functionality 
  - ashwikum   10/04/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="timestamp" scope="request">
  <%--To display the Timestamp--%>
  <%@ include file="/provision/timestamp.jspf" %>
</uix:buildTree>

<%--All page content witin the subtab is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:tableLayout width="100%" cellSpacing="10" hAlign="center" 
                   renderedBinding="isDefaultSearch@ProvisionContext@servletRequest">
    <uix:contents>
      <uix:rowLayout>
        <uix:contents> 
          <uix:rowLayout>
            <uix:contents>
              <uix:messageChoice name="viewHardwareChoices"
                                 selectedValueBinding="selectedValue@criteria@search@ProvisionContext@servletRequest"
                                 promptBinding="VIEW@commonResourceBundle">
                <uix:contents childDataBinding="filterChoices@criteria@search@ProvisionContext@servletRequest">
                  <uix:option textBinding="text"/>
                </uix:contents>
              </uix:messageChoice>
              <uix:spacer width="20"/>
              <uix:messageTextInput name="namePatternSimple"
                                    columns="20"
                                    promptBinding="LBL_NamePattern@localize@HardwareData@servletRequest"
                                    textBinding="namePatternSimple@criteria@search@ProvisionContext@servletRequest"/>
              <uix:spacer width="10"/>
              <uix:submitButton name="event" value="doSimpleSearch" 
                                textBinding="GO@commonResourceBundle" 
                                shortDescBinding="LBL_GoDesc@localize@HardwareData@servletRequest"
                                formNameBinding="formName@ProvisionContext@servletRequest"/>
              <uix:spacer width="10"/>
            <uix:link textBinding="searchToggleLabel@ProvisionContext@servletRequest"
                        shortDescBinding="searchToggleDesc@ProvisionContext@servletRequest"
                        destinationBinding="searchToggleDest@ProvisionContext@servletRequest"/>
            </uix:contents>
          </uix:rowLayout>
        </uix:contents>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:messageText messageType="info"
                         tipBinding="LBL_SimpleSearchGuideline@localize@HardwareData@servletRequest"/>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:contents>
          <uix:cellFormat columnSpan="2">
            <uix:contents>
              <uix:separator/>
            </uix:contents>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:contents>
          <uix:cellFormat columnSpan="2">
            <uix:contents>
              <uix:table name="HardwareServerTable"
                         tableDataBinding="dataList@resultSet@search@ProvisionContext@servletRequest"
                         formSubmitted="true"
                         valueBinding="firstVisibleIndexKey@search@ProvisionContext@servletRequest"
                         minValueBinding="firstIndexKey@search@ProvisionContext@servletRequest"
                         maxValueBinding="lastIndexKey@search@ProvisionContext@servletRequest"
                         blockSizeBinding="blockSizeKey@search@ProvisionContext@servletRequest"
                         alternateTextBinding="MSG_NoHardwareFound@localize@HardwareData@servletRequest"
                         width="100%"
                         summary="Hardware Server Table" >
                <uix:tableSelection>
                  <uix:singleSelection 
                       selectedIndexBinding="selectedItemIndex@search@ProvisionContext@servletRequest"
                       shortDesc="Select">
                    <uix:contents childDataBinding="selectionButtons@search@ProvisionContext@servletRequest">
                      <uix:submitButton textBinding="text"
                                        nameBinding="name"
                                        shortDescBinding="shortDesc"
                                        valueBinding="value"
                                        disabledBinding="disabled"
                                        formNameBinding="formName@ProvisionContext@servletRequest"/>
                    </uix:contents>
                  </uix:singleSelection>
                </uix:tableSelection>
                <uix:contents>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_Label@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:messageStyledText textBinding="label" shortDescBinding="hwdesc"/>
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_Hostname@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:link textBinding="hostname" destinationBinding="viewDestination" />
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_Status@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:text textBinding="status" />
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_Image@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:text textBinding="image" />
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_CurrAssignment@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:link textBinding="currAssignment" destinationBinding="viewAssignment" />
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_Network@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:text textBinding="network" />
                    </uix:contents>
                  </uix:column>
                </uix:contents>
              </uix:table>
            </uix:contents>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
    </uix:contents>
  </uix:tableLayout>

  <uix:header textBinding="LBL_AdvSearchTxt@localize@HardwareData@servletRequest"
              renderedBinding="isAdvSearch@ProvisionContext@servletRequest"> 
    <uix:contents>
      <uix:stackLayout>
        <uix:contents>
          <uix:spacer height="10" />
          <uix:labeledFieldLayout columns="2" width="70%">
            <uix:contents>
              <uix:messageChoice name="statusChoices"
                selectedValueBinding="selectedStatus@criteria@search@ProvisionContext@servletRequest"
                promptBinding="LBL_ProvStatus@localize@HardwareData@servletRequest">
                <uix:contents childDataBinding="statusOptions@criteria@search@ProvisionContext@servletRequest">
                  <uix:option textBinding="text"/>
                </uix:contents>
              </uix:messageChoice>
              <uix:messageChoice name="purposeChoices"
                selectedValueBinding="selectedPurpose@criteria@search@ProvisionContext@servletRequest"
                promptBinding="LBL_Purpose@localize@HardwareData@servletRequest">
                <uix:contents childDataBinding="purposeOptions@criteria@search@ProvisionContext@servletRequest">
                  <uix:option textBinding="text"/>
                </uix:contents>
              </uix:messageChoice>
              <uix:messageTextInput name="namePatternAdv"
                   promptBinding="LBL_Hostname@localize@HardwareData@servletRequest"
                   textBinding="namePatternAdv@criteria@search@ProvisionContext@servletRequest"
                   tipBinding="LBL_namePatternTip@localize@HardwareData@servletRequest"
                   columns="20" />
              <uix:messageChoice name="platformChoices"
                   selectedValueBinding="selectedPlatform@criteria@search@ProvisionContext@servletRequest"
                   promptBinding="LBL_Platform@localize@HardwareData@servletRequest">
                <uix:contents childDataBinding="platformOptions@criteria@search@ProvisionContext@servletRequest">
                  <uix:option textBinding="text"/>
                </uix:contents>
              </uix:messageChoice>
              <uix:messageTextInput name="NetworkProfile"
                   columns="20"
                   promptBinding="LBL_Network@localize@HardwareData@servletRequest"
                   textBinding="networkProfile@criteria@search@ProvisionContext@servletRequest"
                   disabled="true"/>
              <uix:messageTextInput name="ImageProfile"
                   columns="20"
                   promptBinding="LBL_Image@localize@HardwareData@servletRequest"
                   textBinding="imageProfile@criteria@search@ProvisionContext@servletRequest"
                   disabled="true"/>
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <uix:submitButton name="event" value="NetworkDestination"
                                    textBinding="SELECT@commonResourceBundle"
                                    formNameBinding="formName@ProvisionContext@servletRequest" />
                  <uix:spacer width="3"/>
                  <uix:submitButton name="event" value="RemoveNetwork"
                                    textBinding="REMOVE@commonResourceBundle"
                                    formNameBinding="formName@ProvisionContext@servletRequest" />
                </uix:contents>
              </uix:messageLayout>
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <uix:submitButton name="event" value="ImageDestination"
                                    textBinding="SELECT@commonResourceBundle"
                                    formNameBinding="formName@ProvisionContext@servletRequest" />
                  <uix:spacer width="3"/>
                  <uix:submitButton name="event" value="RemoveImage"
                                    textBinding="REMOVE@commonResourceBundle"
                                    formNameBinding="formName@ProvisionContext@servletRequest" />
                </uix:contents>
              </uix:messageLayout>
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:messageTextInput name="MinCPUFreqInput"
                   promptBinding="LBL_MinCpuFreq@localize@HardwareData@servletRequest"
                   textBinding="minCpuFreq@criteria@search@ProvisionContext@servletRequest"
                   tipBinding="LBL_CPUFreqTip@localize@HardwareData@servletRequest"
                   columns="10" />
              <uix:messageTextInput name="MaxCPUFreqInput"
                   promptBinding="LBL_MaxCpuFreq@localize@HardwareData@servletRequest"
                   textBinding="maxCpuFreq@criteria@search@ProvisionContext@servletRequest"
                   tipBinding="LBL_CPUFreqTip@localize@HardwareData@servletRequest"
                   columns="10" />
              <uix:messageTextInput name="MinRAMInput"
                   promptBinding="LBL_MinRam@localize@HardwareData@servletRequest"
                   textBinding="minRam@criteria@search@ProvisionContext@servletRequest"
                   tipBinding="LBL_RAMTip@localize@HardwareData@servletRequest"
                   columns="10" />
              <uix:messageTextInput name="MaxRAMInput"
                   promptBinding="LBL_MaxRam@localize@HardwareData@servletRequest"
                   textBinding="maxRam@criteria@search@ProvisionContext@servletRequest"
                   tipBinding="LBL_RAMTip@localize@HardwareData@servletRequest"
                   columns="10" />
              <uix:messageTextInput name="MinCPUInput"
                   promptBinding="LBL_MinCpus@localize@HardwareData@servletRequest"
                   textBinding="minCpus@criteria@search@ProvisionContext@servletRequest"
                   columns="10" />
              <uix:messageTextInput name="MaxCPUInput"
                   promptBinding="LBL_MaxCpus@localize@HardwareData@servletRequest"
                   textBinding="maxCpus@criteria@search@ProvisionContext@servletRequest"
                   columns="10" />
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:spacer height="7" />
              <uix:messageLayout prompt=" ">
                <uix:contents>
                  <uix:submitButton name="event" value="doAdvSearch" 
                       textBinding="GO@commonResourceBundle" 
                       shortDescBinding="LBL_GoDesc@localize@HardwareData@servletRequest"
                       formNameBinding="formName@ProvisionContext@servletRequest"/>
                  <uix:spacer width="10" />
                  <uix:link textBinding="searchToggleLabel@ProvisionContext@servletRequest"
                            shortDescBinding="searchToggleDesc@ProvisionContext@servletRequest"
                            destinationBinding="searchToggleDest@ProvisionContext@servletRequest"/>
                </uix:contents>
              </uix:messageLayout>
            </uix:contents>
          </uix:labeledFieldLayout>
          <uix:separator />
          <uix:tableLayout width="100%" hAlign="center">
            <uix:contents>
              <uix:rowLayout>
                <uix:contents>
                  <uix:cellFormat columnSpan="2">
                    <uix:contents>
                      <uix:spacer height="10" />
                        <uix:table name="HardwareServerTable"
                                   tableDataBinding="dataList@resultSet@search@ProvisionContext@servletRequest"
                                   formSubmitted="true"
                                   valueBinding="firstVisibleIndexKey@search@ProvisionContext@servletRequest"
                                   minValueBinding="firstIndexKey@search@ProvisionContext@servletRequest"
                                   maxValueBinding="lastIndexKey@search@ProvisionContext@servletRequest"
                                   blockSizeBinding="blockSizeKey@search@ProvisionContext@servletRequest"
                                   alternateTextBinding="MSG_NoHardwareFound@localize@HardwareData@servletRequest"
                                   width="100%" 
                                   summary="Hardware Server Table">
                          <uix:tableSelection>
                            <uix:singleSelection selectedIndexBinding="selectedItemIndex@search@ProvisionContext@servletRequest">
                              <uix:contents childDataBinding="selectionButtons@search@ProvisionContext@servletRequest">
                                <uix:submitButton textBinding="text"
                                                  nameBinding="name"
                                                  shortDescBinding="shortDesc"
                                                  valueBinding="value"
                                                  disabledBinding="disabled"
                                                  formNameBinding="formName@ProvisionContext@servletRequest"/>
                              </uix:contents>
                            </uix:singleSelection>
                          </uix:tableSelection>
                          <uix:contents>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_Label@localize@HardwareData@servletRequest" />
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:messageStyledText textBinding="label" shortDescBinding="hwdesc"/>
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_Hostname@localize@HardwareData@servletRequest" />
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:link textBinding="hostname" destinationBinding="viewDestination" />
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_Status@localize@HardwareData@servletRequest" />
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:text textBinding="status" />
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_Image@localize@HardwareData@servletRequest" />
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:text textBinding="image" />
                              </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_CurrAssignment@localize@HardwareData@servletRequest" />
                                </uix:columnHeader>
                                <uix:contents>
                                  <uix:link textBinding="currAssignment" destinationBinding="viewAssignment" />
                                </uix:contents>
                            </uix:column>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:text textBinding="LBL_Network@localize@HardwareData@servletRequest" />
                              </uix:columnHeader>
                              <uix:contents>
                                <uix:text textBinding="network" />
                              </uix:contents>
                            </uix:column>
                          </uix:contents>
                        </uix:table>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>
          <uix:spacer height="20" />
        </uix:contents>
      </uix:stackLayout>
    </uix:contents>
  </uix:header>

</uix:buildTree>
<%@ include file="/provision/subtabTemplate.jspf" %>
