<%--
  - FILE
  -   hw_chooser_body.jsp
  -
  - DESCRIPTION
  -   A template to be included in JSPs to show the h/w search/chooser page.
  -
  - MODIFIED   (MM/DD/YY)
  -   kashukla  08/04/05   - addding assignment col 
  -   gauragup  07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                          Attribute 
  -   ashwikum  06/27/05   - Remove styledText at the end 
  -   jhazra    06/15/05   - fix selectron bug 
  -   jhazra    06/11/05   - jhazra_cluster
  -   jhazra    05/18/05   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
  <uix:tableLayout width="100%" cellSpacing="10" hAlign="center" 
                   renderedBinding="isDefaultSearch@pageContext@servletRequest">
      <uix:rowLayout>
        <uix:rowLayout>
              <uix:messageChoice name="viewHardwareChoices"
                                 selectedValueBinding="selectedValue@criteria@search@pageContext@servletRequest"
                                 promptBinding="VIEW@commonResourceBundle">
                <uix:contents childDataBinding="filterChoices@criteria@search@pageContext@servletRequest">
                  <uix:option textBinding="text"/>
                </uix:contents>
              </uix:messageChoice>
              <uix:spacer width="20"/>
              <uix:messageTextInput name="namePatternSimple"
                                    columns="20"
                                    promptBinding="LBL_NamePattern@localize@pageContext@servletRequest"
                                    textBinding="namePatternSimple@criteria@search@pageContext@servletRequest"/>
              <uix:spacer width="10"/>
              <uix:submitButton name="event" value="doSimpleSearch" 
                                textBinding="GO@commonResourceBundle" 
                                shortDescBinding="LBL_GoDesc@localize@pageContext@servletRequest"
                                formNameBinding="formName@pageContext@servletRequest"/>
              <uix:spacer width="10"/>
            <%--uix:link textBinding="searchToggleLabel@pageContext@servletRequest"
                        shortDescBinding="searchToggleDesc@pageContext@servletRequest"
                        destinationBinding="searchToggleDest@pageContext@servletRequest"/--%>
        </uix:rowLayout>
      </uix:rowLayout>
      <%--uix:rowLayout hAlign="right">
        <uix:button textBinding="searchToggleLabel@pageContext@servletRequest"
                    destinationBinding="searchToggleDest@pageContext@servletRequest"/>
      </uix:rowLayout--%>
    <uix:table name="HardwareServerTable"
             tableDataBinding="dataList@resultSet@search@pageContext@servletRequest"
             formSubmitted="true"
             columnHeaderDataBinding="columnHeaderData@search@pageContext@servletRequest"
             columnFormatsBinding="columnFormats@search@pageContext@servletRequest"
             valueBinding="firstVisibleIndexKey@search@pageContext@servletRequest"
             minValueBinding="firstIndexKey@search@pageContext@servletRequest"
             maxValueBinding="lastIndexKey@search@pageContext@servletRequest"
             blockSizeBinding="blockSizeKey@search@pageContext@servletRequest"
             alternateTextBinding="MSG_NothingFound@localize@HardwareData@servletRequest"
             width="100%"
             summary="Hardware Server Table" >
        <uix:tableSelection>
            <uix:switcher childNameBinding="isMultiSelect@search@pageContext@servletRequest">
                <uix:case name="false">
                    <uix:singleSelection selectedBinding="selected"
                                         shortDesc="Select"
                                         disabledBinding="isDisabled"/>
                </uix:case>
                <uix:default>
                    <uix:multipleSelection selectedBinding="selected" shortDesc="Select" disabledBinding="isDisabled"/>
                </uix:default>
            </uix:switcher>
        </uix:tableSelection>
          <uix:columnHeaderStamp>
            <uix:text textBinding="text"/>
          </uix:columnHeaderStamp>                
        <uix:contents>
              <uix:text textBinding="label" />
              <uix:text textBinding="hostname" />
              <uix:text textBinding="status" />
              <uix:text textBinding="image" />
              <uix:link textBinding="currAssignment" destinationBinding="viewAssignment" />
              <uix:text textBinding="network" />
        </uix:contents>
    </uix:table>
  </uix:tableLayout>
