<%--
  - FILE
  -   view_suitinst.jsp
  -
  - DESCRIPTION
  -   Page for (read-only) viewing suite instance  details.
  -
  - MODIFIED   (MM/DD/YY)
  -   kashukla   02/21/06   - 
  -   jhazra     08/09/05   - suite inst member status incorrect 
  -   gauragup   07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                           Attribute 
  -   jhazra     06/11/05   - jhazra_cluster
  -   jhazra     06/08/05   - created
  -
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%--All page content within the editor is within this tag--%>

<uix:buildTree nodeID="pageContent" scope="request">
   <uix:tableLayout width="100%">
        <uix:rowLayout>
         <uix:labeledFieldLayout labelWidth="30%" width="40%">
              <uix:messageStyledText promptBinding="LBL_SuiteInst@localize@levelOnePage@ProvisionContext@servletRequest"
                                     textBinding="suiteInstName@data@levelOnePage@ProvisionContext@servletRequest"
                                     contentStyleClass="OraDataText"/>                
             </uix:labeledFieldLayout>
        </uix:rowLayout>
        <uix:rowLayout>
         <uix:labeledFieldLayout labelWidth="30%" width="40%">
              <uix:messageStyledText promptBinding="LBL_Desc@localize@levelOnePage@ProvisionContext@servletRequest"
                                     textBinding="desc@data@levelOnePage@ProvisionContext@servletRequest"
                                     contentStyleClass="OraDataText"/>                
             </uix:labeledFieldLayout>
        </uix:rowLayout>
        <uix:rowLayout>
         <uix:labeledFieldLayout labelWidth="30%" width="40%">
              <uix:messageStyledText promptBinding="LBL_ProvImage@localize@levelOnePage@ProvisionContext@servletRequest"
                                     textBinding="provImage@data@levelOnePage@ProvisionContext@servletRequest"
                                     contentStyleClass="OraDataText"/>                
             </uix:labeledFieldLayout>
        </uix:rowLayout>
        <uix:rowLayout>
         <uix:labeledFieldLayout labelWidth="30%" width="40%">
              <uix:messageStyledText promptBinding="LBL_AsnImage@localize@levelOnePage@ProvisionContext@servletRequest"
                                     textBinding="asnImage@data@levelOnePage@ProvisionContext@servletRequest"
                                     contentStyleClass="OraDataText"/>                
             </uix:labeledFieldLayout>
        </uix:rowLayout>
        <uix:header textBinding="LBL_SuiteInstMembers@localize@levelOnePage@ProvisionContext@servletRequest">
                <uix:table width="100%" id="SuiteInstMembersTable"
                           tableDataBinding="dataList@resultSet@table@data@levelOnePage@ProvisionContext@servletRequest"
                           columnFormatsBinding="columnHeaderData@table@data@levelOnePage@ProvisionContext@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@table@data@levelOnePage@ProvisionContext@servletRequest"
                           alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
                           summary="SuiteInst Members Table">
                  <uix:tableSelection>
                    <uix:singleSelection selectedIndexBinding="selectedItemIndex@table@data@levelOnePage@ProvisionContext@servletRequest"
                                         primaryClientActionBinding="clientAction@table@data@levelOnePage@ProvisionContext@servletRequest" shortDesc="Select"/>
                  </uix:tableSelection>
                  <uix:columnHeaderStamp>
                    <uix:text textBinding="text"/>
                  </uix:columnHeaderStamp>
                  <uix:contents>
                    <uix:text textBinding="provImagePath"/>
                    <uix:text textBinding="type"/>
                    <uix:text textBinding="suiteInstMemStatus"/>
                    <uix:text textBinding="name"/>
                    <uix:text textBinding="assignment"/>
                    <uix:text textBinding="desc"/>
                  </uix:contents>
                </uix:table>
        </uix:header>
        
        <uix:header textBinding="memberTableHeader@memberTable@table@data@levelOnePage@ProvisionContext@servletRequest"
                    renderedBinding="isMemberTableRendered@memberTable@table@data@levelOnePage@ProvisionContext@servletRequest">
                <uix:table width="100%" id="HardwareServerTable"
                           tableDataBinding="dataList@resultSet@memberTable@table@data@levelOnePage@ProvisionContext@servletRequest"
                           columnFormatsBinding="columnHeaderData@memberTable@table@data@levelOnePage@ProvisionContext@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@memberTable@table@data@levelOnePage@ProvisionContext@servletRequest"
                           alternateTextBinding="MSG_NoItemsFound@localize@ProvisionContext@servletRequest"
                           summary="Hardware Server Table">
                  <uix:columnHeaderStamp>
                    <uix:text textBinding="text"/>
                  </uix:columnHeaderStamp>
                  <uix:contents>
                      <uix:text textBinding="label" />
                      <uix:text textBinding="hostName" />
                      <uix:text textBinding="tgtStatus" />
                      <uix:text textBinding="provImagePath" />
                      <uix:text textBinding="assignment" />
                      <uix:text textBinding="provNetwork" />
                  </uix:contents>
                </uix:table>
        </uix:header>    
   </uix:tableLayout>
</uix:buildTree>
<%@ include file="/provision/editorTemplate.jspf" %>


