<%--
  - FILE
  -   view_hardware_prov_history.jsp
  -
  - DESCRIPTION
  -   View operation history of selected hardware.
  -
  - MODIFIED   (MM/DD/YY)
  - gauragup    07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                          Attribute 
  - ashwikum    05/18/05   - Aligning display 
  - ashwikum    03/17/05   - ashwikum_prov_hist_tz_bugfix
  - ashwikum    03/14/05   - Incorporate changes in history frame work 
  - ashwikum    11/05/04   - Improving layout 
  - ashwikum    11/02/04   - ashwikum_hardwareui
  - ashwikum    10/28/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page content is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:stackLayout>
    <uix:contents>
      <uix:spacer height="10" />
      <uix:labeledFieldLayout>
        <uix:contents>
          <uix:messageStyledText promptBinding="LBL_Hostname@localize@HardwareData@servletRequest"
                                 textBinding="hostname@pageContext@servletRequest"
                                 contentStyleClass="OraDataText" />
          <uix:messageStyledText promptBinding="LBL_AssgnName@localize@HardwareData@servletRequest"
                                 textBinding="assgnName@pageContext@servletRequest"
                                 contentStyleClass="OraDataText" />
          <uix:messageStyledText promptBinding="LBL_AssgnType@localize@HardwareData@servletRequest"
                                 textBinding="assgnType@pageContext@servletRequest"
                                 contentStyleClass="OraDataText" />
          <uix:messageStyledText promptBinding="LBL_NetworkPath@localize@HardwareData@servletRequest"
                                 textBinding="networkPath@pageContext@servletRequest"
                                 contentStyleClass="OraDataText" />
          <uix:messageStyledText promptBinding="LBL_ImagePath@localize@HardwareData@servletRequest"
                                 textBinding="imagePath@pageContext@servletRequest"
                                 contentStyleClass="OraDataText" />
          <uix:messageStyledText promptBinding="LBL_ProvTime@localize@HardwareData@servletRequest"
                                 textBinding="provTime@pageContext@servletRequest"
                                 contentStyleClass="OraDataText" />
          <uix:messageStyledText promptBinding="LBL_ProvStatus@localize@HardwareData@servletRequest"
                                 textBinding="provStatus@pageContext@servletRequest"
                                 contentStyleClass="OraDataText" />
          <uix:messageStyledText promptBinding="LBL_Username@localize@HardwareData@servletRequest"
                                 textBinding="username@pageContext@servletRequest"
                                 contentStyleClass="OraDataText" />
        </uix:contents>
      </uix:labeledFieldLayout>
      <uix:spacer height="10" />
      <uix:tableLayout width="100%" hAlign="center">
        <uix:contents>
          <uix:rowLayout>
            <uix:contents>
              <uix:cellFormat columnSpan="2">
                <uix:contents>
                  <uix:table name="HardwareOpHistoryTable"
                             tableDataBinding="opHistoryData@pageContext@servletRequest"
                             formSubmitted="true"
                             alternateTextBinding="MSG_NoHistoryFound@localize@HardwareData@servletRequest"
                             width="100%" 
                             summary="Hardware Op History Table">
                    <uix:contents>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:text textBinding="LBL_OperationType@localize@HardwareData@servletRequest" />
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:text textBinding="type" />
                        </uix:contents>
                      </uix:column>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:text textBinding="LBL_Timestamp@localize@HardwareData@servletRequest" />
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:text textBinding="timestamp" />
                        </uix:contents>
                      </uix:column>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:text textBinding="LBL_JobId@localize@HardwareData@servletRequest" />
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:text textBinding="jobid" />
                        </uix:contents>
                      </uix:column>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:text textBinding="LBL_FractionComplete@localize@HardwareData@servletRequest" />
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:text textBinding="fraction"/>
                        </uix:contents>
                      </uix:column>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:text textBinding="LBL_Status@localize@HardwareData@servletRequest" />
                        </uix:columnHeader>
                        <uix:contents>
                          <uix:text textBinding="status" />
                        </uix:contents>
                      </uix:column>
                    </uix:contents>
                  </uix:table>
                </uix:contents>
              </uix:cellFormat>
            </uix:contents>
          </uix:rowLayout>
        </uix:contents>
      </uix:tableLayout>
    </uix:contents>
  </uix:stackLayout>
</uix:buildTree>
<%@ include file="/provision/pageTemplate.jspf" %>
