<%--
  - FILE
  -   view_hardware_prov_history.jsp
  -
  - DESCRIPTION
  -   View operation history of selected hardware.
  -
  - MODIFIED   (MM/DD/YY)
  - gauragup    07/15/05   - Fixing Table Accessibility Bug-adding Summary 
  -                          Attribute 
  - ashwikum    05/18/05   - correct form name binding in table
  - ashwikum    03/17/05   - ashwikum_prov_hist_tz_bugfix
  - ashwikum    03/14/05   - Incorporate changes in history frame work 
  - ashwikum    11/05/04   - Improving layout 
  - ashwikum    11/02/04   - ashwikum_hardwareui
  - ashwikum    10/28/04   - created
  -
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page content is within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">
  <uix:tableLayout width="100%" cellSpacing="10" hAlign="center">
    <uix:contents>
      <uix:rowLayout>
        <uix:contents>
          <uix:messageStyledText promptBinding="LBL_Hostname@localize@HardwareData@servletRequest"
                                 textBinding="hostname@levelOnePage@ProvisionContext@servletRequest"
                                 contentStyleClass="OraDataText" />
          <uix:spacer height="10"/>
        </uix:contents>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:contents>
          <uix:cellFormat columnSpan="2">
            <uix:contents>
              <uix:table name="HardwareProvHistoryTable"
                         tableDataBinding="provHistoryData@levelOnePage@ProvisionContext@servletRequest"
                         formSubmitted="true"
                         valueBinding="firstVisibleIndexKey@levelOnePage@ProvisionContext@servletRequest"
                         minValueBinding="firstIndexKey@levelOnePage@ProvisionContext@servletRequest"
                         maxValueBinding="lastIndexKey@levelOnePage@ProvisionContext@servletRequest"
                         blockSizeBinding="blockSizeKey@levelOnePage@ProvisionContext@servletRequest"
                         alternateTextBinding="MSG_NoHistoryFound@localize@HardwareData@servletRequest"
                         width="100%"
                         summary="Hardware Prov History Table">
                <uix:tableSelection>
                  <uix:singleSelection selectedIndexBinding="selectedIndexKey@levelOnePage@ProvisionContext@servletRequest"
                                       shortDesc="Select">
                    <uix:contents>
                      <uix:submitButton name="event" value="showOps"
                                        textBinding="LBL_Operations@localize@HardwareData@servletRequest"
                                        shortDescBinding="LBL_OperationsDesc@localize@HardwareData@servletRequest"
                                        formNameBinding="formName@levelOnePage@ProvisionContext@servletRequest"/>
                    </uix:contents>
                  </uix:singleSelection>
                </uix:tableSelection>
                <uix:contents>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_AssgnName@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:text textBinding="assgnName" />
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_AssgnType@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:text textBinding="assgnType" />
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_NetworkPath@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:text textBinding="networkPath" />
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_ImagePath@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:text textBinding="imagePath"/>
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_ProvTime@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:text textBinding="provTime" />
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_ProvStatus@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:text textBinding="provStatus" />
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_Username@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:text textBinding="username" />
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_BootServer@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:text textBinding="bootServer" />
                    </uix:contents>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:text textBinding="LBL_StagingStorage@localize@HardwareData@servletRequest" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:text textBinding="stagingStorage" />
                    </uix:contents>
                  </uix:column>
                </uix:contents>
              </uix:table>
            </uix:contents>
          </uix:cellFormat>
        </uix:contents>
      </uix:rowLayout>
    </uix:contents>
  </uix:tableLayout>
</uix:buildTree>
<%@ include file="/provision/editorTemplate.jspf" %>
