<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle" />
  <uix:bundle name="rcaResourceBundle" class="oracle.sysman.resources.RCAResourceBundle"/>
  <uix:document>
    <%@ include file="/oemNoscript.jspf" %> 
    <%@ include file="/enablePPR.jspf" %>  
    <%@ include file="/oemTitle.jspf" %>	
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
		<%@ include file="/rca/rcaErrors.jspf" %>
		<uix:dataScope currentDataBinding="faultTestData@servletRequest" >
    
			<uix:header textBinding="testPageHeader">
				<uix:stackLayout>
				
				<uix:labeledFieldLayout width="0"
						labelWidth="0" fieldWidth="0">
				   <uix:styledText styleClass="OraPromptText" textBinding="TARGET_NAME@rcaResourceBundle"/>
				   <uix:styledText styleClass="OraDataText" textBinding="depTarget@servletRequest"/>
				   <uix:styledText styleClass="OraPromptText" textBinding="TARGET_TYPE@rcaResourceBundle"/>	
				   <uix:styledText styleClass="OraDataText" textBinding="depType@servletRequest"/>					
           <uix:styledText styleClass="OraPromptText" textBinding="HOST_LABEL@rcaResourceBundle" renderedBinding="defHostTests" />
           <uix:styledText styleClass="OraDataText" textBinding="componentHostName" renderedBinding="defHostTests" />           
				</uix:labeledFieldLayout>
				<uix:tableLayout width="100%">
					<uix:rowLayout>
						<uix:cellFormat hAlign="left">
							<uix:separator/>
							<uix:styledText styleClass="OraInstructionText" textBinding="testTipText"/>							
						</uix:cellFormat>
					</uix:rowLayout>
				</uix:tableLayout>				 
				<uix:form name="defineFaultTests" method="POST" destinationBinding="destination" >
					 <uix:tableLayout width="100%">
						<uix:rowLayout>
							<uix:cellFormat hAlign="right">
								<uix:submitButton textBinding="ADD@commonResourceBundle" name="event" value="add"/>
							</uix:cellFormat>
						</uix:rowLayout>
						 <uix:rowLayout>
							<uix:cellFormat vAlign="top">                 													
								<uix:table name="defineFaultTestTable"
										  alternateTextBinding="RCA_FAULT_TESTS_NOT_FOUND@rcaResourceBundle"
										  width="100%"
										  formSubmitted="true"
										  tableDataBinding="faultTestTable"
										  columnFormatsBinding="columnFormats"
										  columnHeaderDataBinding="columnHeader"
										  valueBinding="currentValue"
										  minValueBinding="minValue"
										  maxValueBinding="maxValue"
                      summaryBinding="testPageHeader" 
										  blockSize="<%=oracle.sysman.eml.mntr.util.GenDataObjectList.DEFAULT_BLOCK_SIZE%>">	
										  <uix:tableSelection>
											<uix:singleSelection selectedIndexBinding="selectedIndex@faultTestData@servletRequest" disabledBinding="disabled" >
											  <uix:submitButton textBinding="REMOVE@commonResourceBundle" name="event" value="remove"/>
											  <uix:spacer width="5"/>
                        <uix:submitButton textBinding="EDIT@commonResourceBundle" name="event" value="edit"/>
											</uix:singleSelection>
										  </uix:tableSelection>
	
										<uix:tableFormat tableBanding="rowBanding"/>
	
										<uix:columnHeaderStamp>
										  <uix:sortableHeader textBinding="text"
											  sortableBinding="sortable" />
										</uix:columnHeaderStamp>
	
										<uix:contents>
										  <uix:styledText textBinding="metricDisplayName@"/>
										  <uix:styledText textBinding="object@"/>									  
										  <uix:styledText textBinding="operator@"/>
										  <uix:styledText textBinding="threshold@"/>
										  <uix:formValue name="metricName" valueBinding="metricName@"/>
										  <uix:formValue name="metricDisplayName" valueBinding="metricDisplayName@"/>
										  <uix:formValue name="object" valueBinding="object@"/>
										  <uix:formValue name="metricGuid" valueBinding="metricGuid@"/>
										  <uix:formValue name="MetricTestId" valueBinding="currMetricTestId@"/>
										</uix:contents>
	
									  </uix:table>
							</uix:cellFormat>
						</uix:rowLayout>
					</uix:tableLayout>
					</uix:form>
          
          <uix:spacer height="15" />
          
          <uix:header textBinding="COMPONENT_HOST_TEST_HDR@rcaResourceBundle" renderedBinding="showComponentHostTests" >
            <uix:stackLayout>
              <uix:styledText textBinding="COMPONENT_HOST_HELP@rcaResourceBundle" styleClass="OraPromptText" />
              <uix:spacer height="15" />
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" >
                    <uix:styledText textBinding="HOST_LABEL@rcaResourceBundle" styleClass="OraPromptText" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer width="10" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText textBinding="componentHostName" styleClass="OraDataText" />
                  </uix:cellFormat>
                </uix:rowLayout>       
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" >
                    <uix:styledText textBinding="HOST_TEST_LABEL@rcaResourceBundle" styleClass="OraPromptText" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:spacer width="10" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:link textBinding="componentHostTestCount" destinationBinding="componentHostTestDest" />
                  </uix:cellFormat>
                </uix:rowLayout>                  
              </uix:tableLayout>
            </uix:stackLayout>
          </uix:header>
				</uix:stackLayout>
			</uix:header>
		</uix:dataScope>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
