<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<oem:pageSegment>
	<uix:dataScope currentDataBinding="rcaCausesFound@servletRequest">        
    <uix:bundle name="rcaResourceBundle" class="oracle.sysman.resources.RCAResourceBundle"/>        
		<uix:header textBinding="POSSIBLE_ROOT_CAUSES@rcaResourceBundle">
      <uix:contents>
        <uix:tableLayout width="100%">        
          <uix:contents>     
          
            <uix:rowLayout renderedBinding="showRcaSegmentError@" >
              <uix:cellFormat>					
                <uix:inlineMessage messageTypeBinding="rcaSegmentMsgType@">
                  <uix:contents>
                    <uix:tableLayout>                                        
                      <uix:rowLayout>
                        <uix:cellFormat>
                          <uix:styledText textBinding="rcaSegmentErrorMsg@" styleClass="OraPromptText" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:inlineMessage>						
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:form name="doInteractiveForm" method="post" renderedBinding="interactiveOnly@" > <%-- destinationBinding="currentUrl@servletRequest" > --%>
              <uix:formValue name="interRca" value="true" />
              <uix:formValue name="severityGuid" valueBinding="severityGuid@" />
              <uix:rowLayout>
                <uix:stackLayout>
                  <uix:styledText styleClass="OraInstructionText" textBinding="INTERACTIVE_INSTR@rcaResourceBundle" />
                  <uix:spacer height="5" />
                  <uix:flowLayout>
                    <uix:submitButton textBinding="DO_INTERACTIVE@rcaResourceBundle" />
                    <uix:spacer width="20" />
                    <uix:link textBinding="RCA_CONFIG@rcaResourceBundle" destinationBinding="rcaConfigDest@" />
                  </uix:flowLayout>
                </uix:stackLayout>
              </uix:rowLayout>
            </uix:form>

            <uix:rowLayout renderedBinding="showAnalysisResults@" >
              <uix:cellFormat>
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <uix:styledText styleClass="OraInstructionText" textBinding="POSSIBLE_CAUSES_MESSAGE@rcaResourceBundle"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:spacer height="5"/>
                          <uix:tableLayout width="100%">                                        
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="left">
                                <uix:tableLayout>                                        
                                  <uix:rowLayout>
                                    <uix:cellFormat>
                                      <uix:styledText styleClass="OraPromptText" textBinding="CONFIDENCE@rcaResourceBundle"/>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                      <uix:spacer width="5"/>
                                      <uix:styledText styleClass="OraDataText" textBinding="confidence@"/>
                                    </uix:cellFormat>
                                  </uix:rowLayout>
                                </uix:tableLayout>
                              </uix:cellFormat>
                              <uix:cellFormat hAlign="right">
                                <uix:tableLayout>                                        
                                  <uix:rowLayout>
                                    <uix:cellFormat>
                                      <uix:styledText styleClass="OraPromptText" textBinding="LAST_ANALYSIS@rcaResourceBundle"/>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                      <uix:spacer width="5"/>
                                      <uix:styledText styleClass="OraDataText" textBinding="rcaCompletionTime@"/>
                                    </uix:cellFormat>
                                  </uix:rowLayout>
                                </uix:tableLayout>
                              </uix:cellFormat>
                            </uix:rowLayout>
                          </uix:tableLayout>
                          <uix:spacer height="5"/>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat>
                      <uix:table alternateTextBinding="RCA_CAUSES_NOT_FOUND@rcaResourceBundle"	
                        name="rcaSegmentTable"
                        columnFormatsBinding="formats@"
                        columnHeaderDataBinding="columnSortable@"
                        tableDataBinding="rows@"
                        valueBinding="currentValue@"
                        minValueBinding="minValue@"
                        maxValueBinding="maxValue@"
                        blockSizeBinding="blockSize@"
                        width="100%"					
                        summaryBinding="POSSIBLE_ROOT_CAUSES@rcaResourceBundle"
                        id="rcaSegmentTableId">
                        <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:columnHeaderStamp>
                          <uix:sortableHeader sortableBinding="sortable@"
                            textBinding="text@"/>
                        </uix:columnHeaderStamp>
                        <uix:contents>
                          <uix:styledText textBinding="timestamp@"/>
                          <uix:styledText textBinding="targetName@" destinationBinding="destination@"/>
                          <uix:styledText textBinding="targetType@"/>
                          <uix:styledText textBinding="message@" destinationBinding="causeAction@" />
                        </uix:contents>
                      </uix:table>                                                
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat>                                        
                      <uix:styledText textBinding="ROOT_CAUSE_ANAL_DETAILS@rcaResourceBundle" destinationBinding="rcaDetailDest@"/>                                        
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:cellFormat>
            </uix:rowLayout>

          </uix:contents>
        </uix:tableLayout>
      </uix:contents>
    </uix:header>
  </uix:dataScope>
</oem:pageSegment>
