<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="rcaResourceBundle" class="oracle.sysman.resources.RCAResourceBundle"/>
  <uix:bundle name="sdkBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:document>
    <%@ include file="/oemNoscript.jspf" %> 
    <%@ include file="/enablePPR.jspf" %>  
    <%@ include file="/oemTitle.jspf" %>	
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
	    	<%@ include file="/rca/rcaErrors.jspf" %> 
		<uix:dataScope currentDataBinding="pageData@servletRequest" >
			<uix:form name="rcaDetails" method="POST" destinationBinding="destination@">
				<uix:header textBinding="pageHeader@servletRequest">
        
					<uix:stackLayout>
					  <uix:contents>
						<uix:tableLayout width="100%">                          
							<uix:rowLayout>
							  <uix:cellFormat>
                <uix:contents>
								<uix:rowLayout hAlign="right">
								  <uix:contents>
									<uix:styledText styleClass="OraTipText"
												textBinding="PAGE_REFRESHED_TIME@sdkBundle"/>
									<uix:spacer width="5"/>
									<uix:styledText styleClass="OraTipLabel"
												textBinding="pageTimestamp@"/>
									<uix:spacer width="15"/>
									<uix:submitButton name="event"
												  textBinding="REFRESH_BUTTON@mntrResourceBundle"
												  value="Refresh" renderedBinding="showHistData@" />
								  </uix:contents>
								</uix:rowLayout>
							  </uix:contents>
                </uix:cellFormat>
							</uix:rowLayout>  
						</uix:tableLayout>
            
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:contents>
                    <uix:styledText styleClass="OraFieldText"
                    textBinding="MESSAGE@mntrResourceBundle"/>
                  </uix:contents>
                </uix:cellFormat>
                <uix:spacer width="8"/>
                <uix:cellFormat hAlign="left">
                  <uix:contents>
                    <uix:styledText styleClass="OraDataText"
                    textBinding="alertMessage@"/>
                  </uix:contents>
                </uix:cellFormat>
              </uix:rowLayout>                    
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:contents>
                      <uix:styledText styleClass="OraFieldText"
                      textBinding="TIMESTAMP@mntrResourceBundle"/>
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:spacer width="8"/>
                  <uix:cellFormat hAlign="left" wrappingDisabled="true">
                    <uix:contents>
                      <uix:styledText styleClass="OraDataText"
                      textBinding="alertTimestamp@"/>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:rowLayout>
            </uix:tableLayout>
            
            <uix:separator />
	
						<uix:tableLayout>                          
							<uix:rowLayout>
								<uix:cellFormat hAlign="left"  width="25%"  vAlign="top">
									<uix:contents>
										<uix:header textBinding="ANALYSIS_SUMMARY@rcaResourceBundle">
										<uix:contents>
                      <uix:tableLayout>	

                      <uix:rowLayout>
												<uix:cellFormat hAlign="right" wrappingDisabled="true">
													<uix:contents>
														<uix:styledText styleClass="OraFieldText"
														textBinding="ANALYSIS_TIME@rcaResourceBundle"/>
													</uix:contents>
												</uix:cellFormat>
												<uix:spacer width="8"/>
												<uix:cellFormat hAlign="left" wrappingDisabled="true">
													<uix:contents>
														<uix:styledText styleClass="OraDataText"
														textBinding="analysisTime@"/>
													</uix:contents>
												</uix:cellFormat>
											</uix:rowLayout>
                      <uix:rowLayout>
												<uix:cellFormat hAlign="right" wrappingDisabled="true">
													<uix:contents>
														<uix:styledText styleClass="OraFieldText"
														textBinding="CONFIDENCE@rcaResourceBundle"/>
													</uix:contents>
												</uix:cellFormat>
												<uix:spacer width="8"/>
												<uix:cellFormat hAlign="left" wrappingDisabled="true">
													<uix:contents>
														<uix:styledText styleClass="OraDataText"
														textBinding="confidence@"/>
													</uix:contents>
												</uix:cellFormat>
											</uix:rowLayout>
											<uix:rowLayout>
												<uix:cellFormat hAlign="right" wrappingDisabled="true">
													<uix:contents>
														<uix:styledText styleClass="OraFieldText"
															 textBinding="CAUSES_FOUND@rcaResourceBundle"/>
													</uix:contents>
													</uix:cellFormat>
													<uix:spacer width="8"/>
													<uix:cellFormat hAlign="left" wrappingDisabled="true">
														<uix:contents>
															<uix:flowLayout>
																<uix:contents>
																	<uix:styledText styleClass="OraDataText"
																		textBinding="causesFound@"/>
																	<uix:spacer width="8"/>
															<%--		<uix:image sourceBinding="causesSource@"/> --%>
																</uix:contents>
															</uix:flowLayout>
														</uix:contents>
												</uix:cellFormat>
											</uix:rowLayout>
											<uix:rowLayout>
												<uix:cellFormat hAlign="right" wrappingDisabled="true">
													<uix:contents>
														<uix:styledText styleClass="OraFieldText"
															 textBinding="EXCEPTIONS@rcaResourceBundle"/>
													</uix:contents>
													</uix:cellFormat>
													<uix:spacer width="8"/>
													<uix:cellFormat hAlign="left" wrappingDisabled="true">
														<uix:contents>
															<uix:flowLayout>
																<uix:contents>
																	<uix:styledText styleClass="OraDataText"
																		textBinding="noOfExceptions@"/>
																	<uix:spacer width="8"/>
															 <%--		<uix:image sourceBinding="exceptionsSource@"/> --%>
																</uix:contents>
															</uix:flowLayout>
														</uix:contents>
												</uix:cellFormat>
											</uix:rowLayout>

                      <uix:rowLayout>
                        <uix:spacer height="5" />
                      </uix:rowLayout>
                      
                      <uix:rowLayout renderedBinding="showHistData@" >
												<uix:cellFormat hAlign="right" wrappingDisabled="true">
													<uix:contents>
														<uix:styledText styleClass="OraFieldText"
														textBinding="LAST_ANALYSIS@rcaResourceBundle"/>
													</uix:contents>
												</uix:cellFormat>
												<uix:spacer width="8"/>
												<uix:cellFormat hAlign="left" wrappingDisabled="true">
													<uix:contents>
														<uix:styledText styleClass="OraDataText"
														textBinding="lastAnalysis@"/>
													</uix:contents>
												</uix:cellFormat>
											</uix:rowLayout>       
                      
                      <uix:rowLayout renderedBinding="showHistData@" >
												<uix:cellFormat hAlign="right" wrappingDisabled="true">
													<uix:contents>
														<uix:styledText styleClass="OraFieldText" text="" />
													</uix:contents>
												</uix:cellFormat>
												<uix:spacer width="8"/>
												<uix:cellFormat hAlign="left" wrappingDisabled="true">
													<uix:contents>
                            <uix:styledText textBinding="PREVIOUS_UPDATES@rcaResourceBundle" 
                              destinationBinding="totalUpdateDest@" renderedBinding="showHistData@" /> 
													</uix:contents>
												</uix:cellFormat>
											</uix:rowLayout> 
                      
                      </uix:tableLayout>
                      
                    </uix:contents>
										</uix:header>
									</uix:contents>
								</uix:cellFormat>
                

          <uix:cellFormat hAlign="right"  width="75%"  vAlign="top">
            <uix:contents>
                  
							<uix:header textBinding="RCA_CAUSES_HEADER@rcaResourceBundle">
								<uix:contents>
								   <uix:table alternateTextBinding="RCA_CAUSES_NOT_FOUND@rcaResourceBundle"											 
											 columnFormatsBinding="causesFormats@"
											 columnHeaderDataBinding="causesColumnSortable@"
											 tableDataBinding="causesRows@"
											 valueBinding="causesCurrentValue@"
											 minValueBinding="causesMinValue@"
											 maxValueBinding="causesMaxValue@"
                       summaryBinding="RCA_CAUSES_HEADER@rcaResourceBundle"
											 blockSizeBinding="causesBlockSize@"
                       destinationBinding="destination@"
											 width="100%"											 
											 partialRenderMode="self">
										<uix:tableFormat tableBanding="rowBanding"/>
										<uix:columnHeaderStamp>
											<uix:sortableHeader sortableBinding="sortable@"
										   textBinding="text@"/>
										</uix:columnHeaderStamp>
									   <uix:contents>
										 <uix:styledText textBinding="timestamp@"/>
										 <uix:styledText textBinding="targetName@" destinationBinding="destination@"/>
										 <uix:styledText textBinding="targetType@"/>
										 <uix:styledText textBinding="message@" destinationBinding="causeAction@"/>
									   </uix:contents>
									</uix:table>
								</uix:contents>
							</uix:header>
              
              </uix:contents>
              </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout>              
              
							<uix:spacer height="5"/>		
              
							<uix:header textBinding="RCA_AFECTS_HEADER@rcaResourceBundle">
								<uix:contents>
								   <uix:table alternateTextBinding="RCA_AFECTS_NOT_FOUND@rcaResourceBundle"											                       
											 columnFormatsBinding="impactsFormats@"
											 columnHeaderDataBinding="impactsColumnSortable@"
											 tableDataBinding="impactsRows@"
											 valueBinding="impactsCurrentValue@"
											 minValueBinding="impactsMinValue@"
											 maxValueBinding="impactsMaxValue@"
											 blockSizeBinding="impactsBlockSize@"                                           
                       destinationBinding="destination@"
                       summaryBinding="RCA_AFECTS_HEADER@rcaResourceBundle"
											 width="100%"											 
											 partialRenderMode="self">
										<uix:tableFormat tableBanding="rowBanding"/>
										<uix:columnHeaderStamp>
											<uix:sortableHeader sortableBinding="sortable@"
										   textBinding="text@"/>
										</uix:columnHeaderStamp>
									   <uix:contents>
                      <uix:styledText textBinding="targetName@" destinationBinding="destination@" />
                      <uix:styledText textBinding="targetType@" />
                      <uix:styledText textBinding="timestamp@" />       
                      <uix:styledText textBinding="endTimestamp@" />
                      <uix:styledText textBinding="duration@" />
                      <%-- <uix:image sourceBinding="rcaStatus@" /> --%>
                      <uix:styledText textBinding="message@"/>
                      <uix:image sourceBinding="detailsIcon@" destinationBinding="detailsDest@" shortDescBinding="details@" />                                        
									   </uix:contents>
									</uix:table>
								</uix:contents>
							</uix:header>
              
							<uix:spacer height="5"/>		                               
              
            	<uix:header textBinding="RCA_ANALYSIS_STEPS@rcaResourceBundle"  >
								<uix:contents>
									<uix:hGrid id="analysisDetail"
										   width="100%"
										   alternateTextBinding="NO_ANALYSIS_DETAIL_FOUND@rcaResourceBundle"
										   destinationBinding="destination@"
										   summaryBinding="RCA_ANALYSIS_STEPS@rcaResourceBundle"
										   columnFormatsBinding="analysisFormatData@"
										   columnHeaderDataBinding="analysisHeaderData@"
										   treeDataBinding="analysisDetail@"
										   proxyBinding="proxy@servletRequest"
										   formSubmitted="true">
										<uix:nodeStamp>
											<uix:column>
                        <columnFormats>
                          <columnFormat width="30%" columnDataFormat="textFormat"/>
                        </columnFormats>
											  <uix:columnHeader>
                          <uix:styledText textBinding="STEP@rcaResourceBundle"/>
											  </uix:columnHeader>						
											  <uix:styledText textBinding="step@" destinationBinding="destination@"/>
											</uix:column>
										</uix:nodeStamp>
 
										<uix:columnHeaderStamp>
											<uix:text textBinding="text@"/>
										</uix:columnHeaderStamp>								
										
										<uix:image sourceBinding="status@"/>										
										<uix:styledText textBinding="targetName@" destinationBinding="targetDestination@"/>
										<uix:styledText textBinding="targetType@"/>
										<uix:styledText textBinding="metric@" destinationBinding="metricDestination@"/>
										<uix:styledText textBinding="message@"/>	
                    <uix:image sourceBinding="detailsIcon@" destinationBinding="detailsDest@" />
									</uix:hGrid>
                  
                  <uix:spacer height="5" />
                  <uix:header textBinding="STEP_KEY@rcaResourceBundle" >
                      <uix:rowLayout>
                        <uix:image sourceBinding="causesSource@"/> 
                        <uix:spacer width="10" />
                        <uix:styledText textBinding="STEP_KEY_FAULT@rcaResourceBundle" styleClass="OraPromptText" />
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:image sourceBinding="exceptionsSource@"/> 
                        <uix:spacer width="10" />
                        <uix:styledText textBinding="STEP_KEY_ERROR@rcaResourceBundle" styleClass="OraPromptText" />
                      </uix:rowLayout>     
                      <uix:rowLayout>
                        <uix:image sourceBinding="okIconSource@"/> 
                        <uix:spacer width="10" />
                        <uix:styledText textBinding="STEP_KEY_CLEAR@rcaResourceBundle" styleClass="OraPromptText" />
                      </uix:rowLayout>                       
                  </uix:header>
                  
								</uix:contents>
							</uix:header>                 
                
						</uix:contents>
					</uix:stackLayout> 
				</uix:header>				
			</uix:form>
		</uix:dataScope> 
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
