<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="rcaResourceBundle" class="oracle.sysman.resources.RCAResourceBundle"/>
  <uix:bundle name="sdkBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:document>
    <%@ include file="/oemNoscript.jspf" %> 
    <%@ include file="/enablePPR.jspf" %>  
    <%@ include file="/oemTitle.jspf" %>	
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
		<%@ include file="/rca/rcaErrors.jspf" %>
		<uix:dataScope currentDataBinding="pageData@servletRequest" >
			<uix:form name="rcaHistory" method="POST" destinationBinding="destination@">
				<uix:header textBinding="RCA_HISTORY_HEADER@rcaResourceBundle">
					<uix:stackLayout>
					  <uix:contents>
						<uix:tableLayout width="100%">                          
							<uix:rowLayout>
							  <uix:cellFormat><uix:contents>
								<uix:rowLayout hAlign="right">
								  <uix:contents>
									<uix:styledText styleClass="OraTipText"
												textBinding="PAGE_REFRESHED_TIME@sdkBundle"/>
									<uix:spacer width="5"/>
									<uix:styledText styleClass="OraTipLabel"
												textBinding="pageTimestamp@"/>
									<uix:spacer width="15"/>
									<uix:submitButton name="event"
												  textBinding="REFRESH_BUTTON@mntrResourceBundle"
												  value="Refresh"/>
								  </uix:contents>
								</uix:rowLayout>
							  </uix:contents></uix:cellFormat>
							</uix:rowLayout>                          
						</uix:tableLayout>
            
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:contents>
                    <uix:styledText styleClass="OraFieldText"
                    textBinding="MESSAGE@mntrResourceBundle"/>
                  </uix:contents>
                </uix:cellFormat>
                <uix:spacer width="8"/>
                <uix:cellFormat hAlign="left">
                  <uix:contents>
                    <uix:styledText styleClass="OraDataText"
                    textBinding="alertMessage@"/>
                  </uix:contents>
                </uix:cellFormat>
              </uix:rowLayout>                    
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:contents>
                      <uix:styledText styleClass="OraFieldText"
                      textBinding="TIMESTAMP@mntrResourceBundle"/>
                    </uix:contents>
                  </uix:cellFormat>
                  <uix:spacer width="8"/>
                  <uix:cellFormat hAlign="left" wrappingDisabled="true">
                    <uix:contents>
                      <uix:styledText styleClass="OraDataText"
                      textBinding="alertTimestamp@"/>
                    </uix:contents>
                  </uix:cellFormat>
                </uix:rowLayout>
            </uix:tableLayout>
            
            <uix:separator />
		
						<uix:tableLayout width="100%">                          
							<uix:rowLayout>
								<%--Analysis summary --%>
								<uix:cellFormat width="100%" vAlign="top">
									<uix:contents>
										<uix:header textBinding="ANALYSIS_SUMMARY@rcaResourceBundle">
										<uix:contents>
										<uix:tableLayout>											
											<uix:rowLayout>
												<uix:cellFormat hAlign="right" wrappingDisabled="true">
													<uix:contents>
														<uix:styledText styleClass="OraFieldText"
														textBinding="TOTAL_UPDATE@rcaResourceBundle"/>
													</uix:contents>
												</uix:cellFormat>
												<uix:spacer width="8"/>
												<uix:cellFormat hAlign="left">
													<uix:contents>
														<uix:styledText styleClass="OraDataText"
														textBinding="totalUpdate@"/>
													</uix:contents>
												</uix:cellFormat>
											</uix:rowLayout>                    
											<uix:rowLayout>
												<uix:cellFormat hAlign="right" wrappingDisabled="true">
													<uix:contents>
														<uix:styledText styleClass="OraFieldText"
														textBinding="LAST_ANALYSIS@rcaResourceBundle"/>
													</uix:contents>
												</uix:cellFormat>
												<uix:spacer width="8"/>
												<uix:cellFormat hAlign="left">
													<uix:contents>
														<uix:styledText 
														textBinding="mostRecentUpdate@" styleClass="OraDataText"/>
													</uix:contents>
												</uix:cellFormat>
											</uix:rowLayout>
											<uix:rowLayout>
												<uix:cellFormat hAlign="right" wrappingDisabled="true">
													<uix:contents>
														<uix:styledText styleClass="OraFieldText"
														textBinding="ANALYSIS_STATUS@rcaResourceBundle"/>
													</uix:contents>
												</uix:cellFormat>
												<uix:spacer width="8"/>
												<uix:cellFormat hAlign="left">
													<uix:contents>
														<uix:styledText styleClass="OraDataText"
														textBinding="rcaStatus@"/>
													</uix:contents>
												</uix:cellFormat>
											</uix:rowLayout> 
										</uix:tableLayout>	
										</uix:contents>
										</uix:header>
									</uix:contents>
								</uix:cellFormat>
								</uix:rowLayout>
							</uix:tableLayout>
							<uix:spacer height="20"/>              
                      
                            <uix:header textBinding="ANALYSIS_UPDATE_HISTORY@rcaResourceBundle">	
                                <uix:contents>
                                  <uix:tableLayout>
                                   <uix:rowLayout>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:spacer height="10"/>
                                      </uix:contents>
                                     </uix:cellFormat>
                                  </uix:rowLayout>
                                  <uix:rowLayout>
                                    <uix:cellFormat width="65%" vAlign="top">
                                      <uix:contents>                      
                                        <uix:table alternateTextBinding="NO_RCA_HISTORY_MSG@rcaResourceBundle"                                                                                  
                                         width="100%"
                                         formSubmitted="true"
                                         tableDataBinding="rows@"
                                         columnFormatsBinding="formats@"
                                         columnHeaderDataBinding="columnSortable@"                                         
                                         valueBinding="currentValue@"
                                         minValueBinding="minValue@"
                                         maxValueBinding="maxValue@"
                                         blockSizeBinding="blockSize@"
                                         summaryBinding="ANALYSIS_UPDATE_HISTORY@rcaResourceBundle"
                                         partialRenderMode="self">
                                        <uix:tableFormat tableBanding="rowBanding"/>
                                        <uix:columnHeaderStamp>
                                          <uix:sortableHeader sortableBinding="sortable@"
                                           textBinding="text@"/>
                                        </uix:columnHeaderStamp>
                                         <uix:contents>
                                             <uix:styledText textBinding="timestamp" destinationBinding="dest"/>
                                             <uix:styledText textBinding="confidence"/>
                                             <uix:styledText textBinding="causes"/>
                                             <uix:styledText textBinding="exceptions"/>
                                        </uix:contents>
                                      </uix:table>                       
                                     </uix:contents>
                                  </uix:cellFormat>
                                  <uix:cellFormat  vAlign="bottom">
                                    <uix:contents>
                                      <uix:spacer width="20"/>
                                    </uix:contents>
                                 </uix:cellFormat>
                                 <uix:cellFormat  vAlign="top">
                                  <uix:contents>                    
                                    <uix:contentContainer textBinding="RCA_HISTORY_HEADER@rcaResourceBundle" background="low" width="90%">
                                        <uix:contents>
                                            <uix:styledText textBinding="ANALYSIS_CONFIDENCE_MESSAGE@rcaResourceBundle" styleClass="OraPromptText" />
                                        </uix:contents>										
                                    </uix:contentContainer>
                                  </uix:contents>
                                 </uix:cellFormat>
                                </uix:rowLayout>
                                </uix:tableLayout>   
                                </uix:contents>
                            </uix:header>                  		
                        </uix:contents>
                    </uix:stackLayout>
                </uix:header>				
			</uix:form>
		</uix:dataScope> 
    </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>