<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.rca.RcaMetricData"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle" />
  <uix:bundle name="rcaResourceBundle" class="oracle.sysman.resources.RCAResourceBundle"/>
  <uix:document>
    <%@ include file="/oemNoscript.jspf" %> 
    <%@ include file="/enablePPR.jspf" %>  
    <%@ include file="/oemTitle.jspf" %>	
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
		<%@ include file="/rca/rcaErrors.jspf" %>
		<uix:dataScope currentDataBinding="metricData@servletRequest" >
			<uix:header textBinding="header">				
				<uix:form name="createMetric" method="POST" destinationBinding="destination">
					<uix:stackLayout>
						<uix:formValue name="metric" valueBinding="metric"/>
						<uix:tableLayout width="100%">
							<uix:rowLayout>
								<uix:cellFormat hAlign="left">
									<uix:tableLayout width="70%">
										<uix:rowLayout>
											<uix:cellFormat hAlign="left">
											   <uix:labeledFieldLayout width="0"
														labelWidth="0" fieldWidth="0">
												   <uix:styledText styleClass="OraPromptText" textBinding="TARGET_NAME@rcaResourceBundle"/>
												   <uix:styledText styleClass="OraDataText" textBinding="depTarget@servletRequest"/>
												   <uix:styledText styleClass="OraPromptText" textBinding="TARGET_TYPE@rcaResourceBundle"/>	
												   <uix:styledText styleClass="OraDataText" textBinding="depType@servletRequest"/>	
                           <uix:styledText styleClass="OraPromptText" textBinding="HOST_LABEL@rcaResourceBundle" renderedBinding="defHostTests" />
                           <uix:styledText styleClass="OraDataText" textBinding="componentHostName" renderedBinding="defHostTests" /> 											
												   <uix:styledText styleClass="OraPromptText" textBinding="METRIC@rcaResourceBundle"/>
												   <uix:styledText styleClass="OraDataText" textBinding="metricDisplayName"/>		
												</uix:labeledFieldLayout>
											</uix:cellFormat>
										</uix:rowLayout>									 					
									</uix:tableLayout>							
								</uix:cellFormat>
								<uix:cellFormat hAlign="right" vAlign="top">
									<uix:tableLayout  width="30%">
										<uix:rowLayout>
											<uix:cellFormat hAlign="right">
												<uix:submitButton textBinding="CANCEL@commonResourceBundle" name="event" value="cancel"/>
													  <uix:spacer width="5"/>
												<uix:switcher childNameBinding="newRecord">
													<uix:case name="true">
														<uix:flowLayout>
															<uix:contents>
																<uix:submitButton textBinding="BACK@commonResourceBundle" name="event" value="back"/>
																	<uix:spacer width="5"/>
																<uix:submitButton textBinding="FINISH@commonResourceBundle" name="event" value="finish"/>
															</uix:contents>
														</uix:flowLayout>
													</uix:case>
													<uix:case name="false">
														<uix:submitButton textBinding="OK@commonResourceBundle" name="event" value="ok"/>
													</uix:case>
												</uix:switcher>
											</uix:cellFormat>
										</uix:rowLayout>
									</uix:tableLayout>
								</uix:cellFormat>
							</uix:rowLayout>
						</uix:tableLayout>
						<uix:tableLayout  width="100%">
							<uix:rowLayout>
								<uix:cellFormat hAlign="left">
									<uix:separator/>
									<uix:styledText styleClass="OraInstructionText" textBinding="RCA_SET_THRESHOLD_MESSAGE@rcaResourceBundle"/>									
								</uix:cellFormat>
							</uix:rowLayout>
						</uix:tableLayout>																	
            
            <uix:stackLayout>
              <uix:spacer height="20" />
              
              <uix:rowLayout>
                <uix:cellFormat>
                  <uix:spacer width="20" />
                </uix:cellFormat>
                
                <uix:cellFormat>
                  <uix:tableLayout>
        
                    <%
                    RcaMetricData metricData = (RcaMetricData) request.getAttribute("metricData");
                    for(int i=0; i<metricData.getKeyCount(); i++)
                    {
                    %>                                      
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" >
                        <uix:styledText text="<%=metricData.getKeyName(i)%>" styleClass="OraPromptText" />
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:spacer width="10" />
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:switcher childNameBinding="hideKey@metricData@servletRequest">
                          <uix:case name="false">
                            <uix:lovInput 
                              name="<%=metricData.getKeyLOVId(i)%>" 
                              text="<%=metricData.getKeyValue(i)%>"
                              destination="<%=metricData.getKeyLOVDest(i)%>" />															
                          </uix:case>
                          <uix:case name="true">
                            <uix:styledText styleClass="OraDataText" text="<%=metricData.getKeyValue(i)%>"/>
                          </uix:case>
                        </uix:switcher>		
                      </uix:cellFormat>
                    </uix:rowLayout>  
                    <%
                    }
                    %>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" >
                        <uix:styledText textBinding="COMPARISON_OPERATOR@rcaResourceBundle" styleClass="OraPromptText" />
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:spacer width="10" />
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:styledText styleClass="OraDataText" textBinding="operator" renderedBinding="fixedOperator" />
                        <uix:choice name="operatorChoice" required="yes" renderedBinding="selectOperator"  >
                          <uix:contents childDataBinding="operatorList" >
                            <uix:option textBinding="textKey" valueBinding="valueKey"/>
                          </uix:contents>
                        </uix:choice>								                        
                      </uix:cellFormat>
                    </uix:rowLayout>  
                    
                    <uix:rowLayout>									
                      <uix:cellFormat hAlign="right" vAlign="top" >
                        <uix:styledText textBinding="THRESHOLD@rcaResourceBundle" styleClass="OraPromptText" />
                      </uix:cellFormat>
                      <uix:cellFormat>
                        <uix:spacer width="10" />
                      </uix:cellFormat>
                      <uix:cellFormat>		
                        <uix:stackLayout >
                          <uix:radioButton name="testCriteria" 
                             value="0" 
                             textBinding="thresholdSevMsg" 
                             selectedValueBinding="thresholdType"/>
                          <uix:flowLayout renderedBinding="showThresholdTip" >
                            <uix:spacer width="15" />
                            <uix:styledText styleClass="OraTipText" textBinding="thresholdTip" />
                          </uix:flowLayout>
                          <uix:radioButton name="testCriteria" 
                             value="1" 
                             textBinding="THRESHOLD_ALT_MESSAGE@rcaResourceBundle" 
                             selectedValueBinding="thresholdType"/>
                          <uix:flowLayout>
                            <uix:spacer width="15"/>
                          <uix:textInput name="threshold" columns="30" textBinding="threshold"/>	
                          </uix:flowLayout>                             				
                        </uix:stackLayout>
                  </uix:cellFormat>		
                    </uix:rowLayout>                    
                    
                  </uix:tableLayout>
                  
                </uix:cellFormat>                
              </uix:rowLayout>
            </uix:stackLayout>
              
						<uix:tableLayout width="100%">						 
							<uix:rowLayout>
								<uix:cellFormat hAlign="right">
									<uix:submitButton textBinding="CANCEL@commonResourceBundle" name="event" value="cancel"/>
										  <uix:spacer width="5"/>
									<uix:switcher childNameBinding="newRecord">
										<uix:case name="true">
											<uix:flowLayout>
												<uix:contents>
													<uix:submitButton textBinding="BACK@commonResourceBundle" name="event" value="back"/>
														<uix:spacer width="5"/>
													<uix:submitButton textBinding="FINISH@commonResourceBundle" name="event" value="finish"/>
												</uix:contents>
											</uix:flowLayout>
										</uix:case>
										<uix:case name="false">
											<uix:submitButton textBinding="OK@commonResourceBundle" name="event" value="ok"/>
										</uix:case>
									</uix:switcher>
								</uix:cellFormat>
							</uix:rowLayout>
						</uix:tableLayout>					
					</uix:stackLayout>
				</uix:form>
			</uix:header>
		</uix:dataScope> 
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
