<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle" />
  <uix:bundle name="rcaResourceBundle" class="oracle.sysman.resources.RCAResourceBundle"/>
  <uix:document>
    <%@ include file="/oemNoscript.jspf" %> 
    <%@ include file="/enablePPR.jspf" %>  
    <%@ include file="/oemTitle.jspf" %>	

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
		<%@ include file="/rca/rcaErrors.jspf" %>
		<uix:dataScope currentDataBinding="selectMetricData@servletRequest" >
		<uix:form name="selectMetric" method="POST" destinationBinding="destination">
			<uix:header textBinding="RCA_SELECT_METRIC_HEADER@rcaResourceBundle">
				<uix:stackLayout>
					<uix:tableLayout width="100%">
						<uix:rowLayout>
							<uix:cellFormat hAlign="left">
								<uix:tableLayout width="70%">
									<uix:rowLayout>
										<uix:cellFormat hAlign="left">
										   <uix:labeledFieldLayout width="0"
													labelWidth="0" fieldWidth="0">
											   <uix:styledText styleClass="OraPromptText" textBinding="TARGET_NAME@rcaResourceBundle"/>
											   <uix:styledText styleClass="OraDataText" textBinding="depTarget@servletRequest"/>
											   <uix:styledText styleClass="OraPromptText" textBinding="TARGET_TYPE@rcaResourceBundle"/>	
											   <uix:styledText styleClass="OraDataText" textBinding="depType@servletRequest"/>									
                         <uix:styledText styleClass="OraPromptText" textBinding="HOST_LABEL@rcaResourceBundle" renderedBinding="defHostTests" />
                         <uix:styledText styleClass="OraDataText" textBinding="componentHostName" renderedBinding="defHostTests" /> 											</uix:labeledFieldLayout>
										</uix:cellFormat>
									</uix:rowLayout>									 					
								</uix:tableLayout>
							</uix:cellFormat>
							<uix:cellFormat hAlign="right" vAlign="top">
								<uix:tableLayout width="30%">
									<uix:rowLayout>
										<uix:cellFormat hAlign="right">
											<uix:submitButton textBinding="CANCEL@commonResourceBundle" name="event" value="cancel"/>
													  <uix:spacer width="5"/>
											<uix:submitButton textBinding="CONTINUE@commonResourceBundle" renderedBinding="hasRows" name="event" value="continue"/>
										</uix:cellFormat>
									</uix:rowLayout>
								</uix:tableLayout>
							</uix:cellFormat>
						</uix:rowLayout>
					</uix:tableLayout>
					<uix:tableLayout width="100%">
							<uix:rowLayout>
								<uix:cellFormat hAlign="left">
									<uix:separator/>
									<uix:styledText styleClass="OraInstructionText" textBinding="RCA_SELECT_TEST_METRIC_MESSAGE@rcaResourceBundle"/>									
								</uix:cellFormat>
							</uix:rowLayout>
					</uix:tableLayout>						
          
          <%--
					<uix:tableLayout width="100%">
						<uix:rowLayout vAlign="center" >
							<uix:cellFormat hAlign="left" vAlign="center" >
								<uix:spacer height="30"/>
								<uix:styledText
									styleClass="OraPromptText"
									textBinding="METRIC_TYPE@rcaResourceBundle"/>
								<uix:spacer width="5"/>
								<uix:choice name="metricType"
									selectedValueBinding="currMetricType"
									required="yes"
									onChange="submitForm(selectMetric, false, {event:'MetricChanged'})">
									<uix:contents childDataBinding="metricTypesList" >
										<uix:option textBinding="textKey"
											valueBinding="valueKey"/>
									</uix:contents>
								</uix:choice>								
							</uix:cellFormat>
						</uix:rowLayout>
					</uix:tableLayout>
					--%>
					 <uix:tableLayout width="100%">
						 <uix:rowLayout>
							<uix:cellFormat vAlign="top">
								<uix:table name="selectMetricTableName"	
										  alternateTextBinding="RCA_METRICS_NOT_FOUND@rcaResourceBundle"
										  width="100%"
										  formSubmitted="true"
										  tableDataBinding="selectMetricTable"
										  columnFormatsBinding="columnFormats"
										  columnHeaderDataBinding="columnHeader"
										  valueBinding="currentValue"
										  minValueBinding="minValue"
										  maxValueBinding="maxValue"
                      summaryBinding="RCA_SELECT_METRIC_HEADER@rcaResourceBundle"
										  blockSize="<%=oracle.sysman.eml.mntr.util.GenDataObjectList.DEFAULT_BLOCK_SIZE%>">

										<uix:tableFormat tableBanding="rowBanding"/>
	
										<uix:columnHeaderStamp>
										  <uix:sortableHeader textBinding="text"
											  sortableBinding="sortable" />
										</uix:columnHeaderStamp>
	
										<uix:contents>											  
										  <uix:styledText textBinding="columnName@"/>
										  <uix:styledText textBinding="threshold@"/>
										  <%-- <uix:styledText textBinding="collectionStatus@"/> --%>
                      <%--  <uix:styledText textBinding="description@"/> --%>
										  <uix:formValue name="columnName" valueBinding="columnName@"/>
										  <uix:formValue name="metricCol" valueBinding="metricCol@"/>
										  <uix:formValue name="metricName" valueBinding="metricName@"/>
										  <uix:formValue name="metricGuid" valueBinding="metricGuid@"/>		
                      <uix:formValue name="transKey" valueBinding="transKey@"/>
                      <uix:formValue name="metricType" valueBinding="metricType@" />
										</uix:contents>
										<uix:tableSelection>
											<uix:singleSelection selectedIndex="0">
											</uix:singleSelection>
										</uix:tableSelection>
	
									</uix:table>
							</uix:cellFormat>
						</uix:rowLayout>
					</uix:tableLayout>
					<uix:tableLayout width="100%">						 
						<uix:rowLayout>
							<uix:cellFormat hAlign="right">
								<uix:cellFormat hAlign="right">										
									<uix:submitButton textBinding="CANCEL@commonResourceBundle" name="event" value="cancel"/>
											  <uix:spacer width="5"/>
									<uix:submitButton textBinding="CONTINUE@commonResourceBundle" renderedBinding="hasRows" name="event" value="continue"/>
								</uix:cellFormat>
							</uix:cellFormat>
						</uix:rowLayout>
					</uix:tableLayout>					
				</uix:stackLayout>
			</uix:header>
			</uix:form>
		</uix:dataScope> 
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
