<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree scope="request" nodeID="relatedAlertsTable">
  <uix:styledText textBinding="sectionHeaderText@" styleClass="OraHeaderSubSub" 
              renderedBinding="showAlertsSection@"/>

  <uix:stackLayout>
    <uix:tableLayout>
      
        <uix:rowLayout
              renderedBinding="showErrorCount@">
          <uix:styledText 
                  styleClass="OraPromptText"
                  textBinding="METRIC_COLLECTION_ERRORS@sdkMsg"/>
          <uix:spacer width="3"/>
          <uix:image
                  sourceBinding="metricErrorImage@" />
          <uix:spacer width="3"/>
          <uix:link 
                  textBinding="errorCount@"
                  destinationBinding="errorDest@" />
        </uix:rowLayout>
      
    </uix:tableLayout>

    <uix:table nameBinding="tableName@"
               renderedBinding="showAlertsTable@"
               tableDataBinding="alertList@"
               columnHeaderDataBinding="columnHeaderData@"
               alternateTextBinding="ALERTS_ALT@sdkMsg"
               width="100%"
               showAll="yes"
               blockSizeBinding="blockSize@"
               minValueBinding="minValue@"
               maxValueBinding="maxValue@"
               valueBinding="start@">

        <uix:tableFormat tableBanding="rowBanding"/>
        <%--we had to modify this and use columnHeaderStamp due to a bug in cabo
           where alternate color table banding format is not rendered in pda if we use
           uix:column directly as used in em/sdk/alertsInclude.jsp--%>
          <uix:columnHeaderStamp>
           <uix:styledText textBinding="text"
                     styleClass="OraTableColumnHeader"/>
          </uix:columnHeaderStamp>
         <uix:contents>
            
              <uix:link textBinding="name@" destinationBinding="valueDest@" />
                   
              <!--uix:styledText textBinding="key1Text@" styleClassBinding="key1Style@" /-->
              <!--uix:styledText textBinding="key2Text@" styleClassBinding="key2Style@"  /-->
              <!--uix:styledText textBinding="key3Text@" styleClassBinding="key3Style@"  /-->
            
              <uix:link textBinding="targetName@" destinationBinding="targetNameDest@" />
           
              <uix:styledText textBinding="targetType@"/>
         
              <uix:image sourceBinding="severity@"/>
            
              <uix:styledText textBinding="openSince@"/>
           
              <uix:styledText textBinding="value@" />
          
              <uix:styledText textBinding="lastChecked@"/>
          
          </uix:contents>

    </uix:table>

  </uix:stackLayout>

</uix:buildTree>

