<%--

/* $Header: siebelRecorderInstruct.jsp 17-apr-2007.05:26:22 nishriva Exp $ */
/* Copyright (c) 2001, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
     Forms Transaction Recording Start Page Page.

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
      nishri 04/17/07 - 
      nishri 04/16/07 - 
      vesrin 12/08/06 - remove
      rnag   10/22/06 - removing the verify button from this page
      vesrin 09/13/06 - 
      vesrin 08/23/06 - creation
 */

/**
 *  @version $Header: siebelRecorderInstruct.jsp 17-apr-2007.05:26:22 nishriva Exp $
 *  @author  vesriniv
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.cabo.ui.UIConstants"%>
<%@ page import="oracle.sysman.eml.siebeltt.SiebelTestTypeConstants"%>
<%@ page import="oracle.sysman.eml.siebeltt.data.SiebelTxnRecorderData"%>
<%@ page import="oracle.sysman.eml.siebeltt.data.SiebelRecorderInstructionData"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="siebelMsg" class="oracle.sysman.resources.eml.siebeltt.SiebelTestResourceBundle"/>
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
      <uix:dataScope currentDataBinding="siebelTxnRecordingData@servletRequest">
        <uix:form name="siebelTxnRecord" method="POST">
          <uix:pageLayout>

            <%@ include file="/oemGlobal.jspf" %>

            <uix:messageBox messageType="error" messageBinding="errorMsg" renderedBinding="hasError">
            </uix:messageBox>
            <uix:formValue name="rec_txn" value="" />
            <uix:formValue name="rec_errtxt" value="" />
            <uix:formValue name="rec_status" value="" />

            <uix:header textBinding="header@servletRequest">
              <uix:stackLayout>
                <uix:spacer height="5"/>
                <uix:tableLayout>
                  <uix:cellFormat>
                    <uix:contentContainer width="100%">
                      <uix:styledText styleClass="OraInstructionText"
                                      textBinding="SIEBELTEST_TXN_REC_INST_INTRO@siebelMsg" />
                      <uix:spacer height="5"/>
                      <uix:styledText styleClass="OraInstructionText"
                                      textBinding="SIEBELTEST_TXN_REC_INST_STEP_1@siebelMsg" />
                      <uix:spacer height="5"/>
                      <uix:styledText styleClass="OraInstructionText"
                                      textBinding="SIEBELTEST_TXN_REC_INST_STEP_2@siebelMsg" />
                      <uix:spacer height="5"/>
                      <uix:styledText styleClass="OraInstructionText"
                                      textBinding="SIEBELTEST_TXN_REC_INST_STEP_3@siebelMsg" />
                      <uix:spacer height="5"/>
                      <uix:styledText styleClass="OraInstructionText"
                                      textBinding="SIEBELTEST_TXN_REC_INST_STEP_4@siebelMsg" />
                    </uix:contentContainer>
                  </uix:cellFormat>
                </uix:tableLayout>
              </uix:stackLayout>
            </uix:header>
  

            <uix:contentFooter>
              <uix:flowLayout>

                <uix:button id="siebelTxnRecordStartButton"
                            textBinding="SIEBELTEST_TXN_START_REC@siebelMsg" 
                            onClick="flipButtons()"/>

                <uix:spacer width="10"/>
                <uix:button id="siebelTxnRecordStopButton"
                            textBinding="SIEBELTEST_TXN_STOP_REC@siebelMsg"
                            onClick="flipButtons()"/>

                <uix:spacer width="10"/>

                <uix:button id="siebelTxnRecordContinueButton"
                            textBinding="CONTINUE@commonResourceBundle"
                            onClick="continueSavingSiebelRecording()"/>

                <uix:spacer width="10"/>

                <uix:button id="siebelTxnRecordCancelButton"
                            textBinding="CANCEL@commonResourceBundle"
                            onClick="cancelSavingSiebelRecording()"/>

              </uix:flowLayout>
            </uix:contentFooter>

          </uix:pageLayout>  

          <uix:tableLayout>
            <uix:rowLayout>
              <uix:rawText>
                    <%!
                      String objectId= null;
                      String codeBase = null;
                      StringBuffer strBuf = null;
                    %>
                    <%
                      SiebelRecorderInstructionData siebelRecordingData = (SiebelRecorderInstructionData) request.getAttribute(SiebelTestTypeConstants.SIEBEL_TXN_RECORDING_DATA);
                      SiebelTxnRecorderData siebelTxnRecorderData = siebelRecordingData.getSiebelRecorder();
                      if (siebelTxnRecorderData != null)
                      {
                        objectId = siebelTxnRecorderData.getRecorderObjID();
                        codeBase = siebelTxnRecorderData.getCodeBase();
                        strBuf = new StringBuffer();

                        strBuf.append( "<OBJECT id=recorderCtl width=10 height=10 top=0 left=0\n");
                                    strBuf.append( "    classid=\""+ objectId +"\" codebase=\""+codeBase+"\">" );
                        strBuf.append( "  <PARAM NAME=\"visible\" VALUE=\"FALSE\">\n");
                        strBuf.append( "</OBJECT>\n");
                        out.println( strBuf.toString() );
                      }
                    %>

                    <script language="JavaScript">   
                    /* states: 0=idle, 1=recording, 2=stop->processing, 3=processed/ok, 4=failed/error */
                         var recState = 0;
                         var recError = "";
                         var recordingStatus =false;               
                         function showAlert(alert_id)
                         {
                           <%!
                              String alertMsg = "";
                              String alertMsg2 = "";
                           %>
                              switch (alert_id)
                              {
                                case 1:
                                   <% alertMsg = siebelTxnRecorderData.getRecAlertMsg(1); %>
                                     alert("<%=alertMsg%>");
                                   break;
                                case 2:
                                   <% alertMsg =siebelTxnRecorderData .getRecAlertMsg(2); %>
                                     alert("<%=alertMsg%>");
                                   break;
                                case 3:
                                   <% alertMsg = siebelTxnRecorderData.getRecAlertMsg(3); %>
                                     alert("<%=alertMsg%>");
                                   break;
                                case 4:
                                   <% alertMsg = siebelTxnRecorderData.getRecAlertMsg(4); %>
                                     alert("<%=alertMsg%>");
                                   break;
                                case 5:
                                   <% alertMsg = siebelTxnRecorderData.getRecAlertMsg(5); %>
                                     alert("<%=alertMsg%>");
                                   break;
                                case 6:
                                   <% alertMsg = siebelTxnRecorderData.getRecAlertMsg(6); %>
                                     alert("<%=alertMsg%>" + recError);
                                   break;
                                case 7:
                                   <%
                                     alertMsg = siebelTxnRecorderData.getRecAlertMsg(6);
                                   alertMsg2 = siebelTxnRecorderData.getRecAlertMsg(7);
                                   %>
                                     alert("<%=alertMsg%>" + recError + "<%=alertMsg2%>");
                                   break;
                                default:
                                   <% alertMsg = siebelTxnRecorderData.getRecAlertMsg(0); %>
                                     alert("<%=alertMsg%>");
                              }
                         }

                         /* Retrieves the recording from the recorder control */
                         function checkRecording()
                         {
                           if (recState == 2)
                           {
                              //alert(" inside checkrecording");
                                                var recorderCtl = document.getElementById("recorderCtl");
                              recorderCtl.status=recorderCtl.getRecordingStatus();
                                if (recorderCtl.status == 1)
                                {
                                   recState = 3;
                                   document.siebelTxnRecord.rec_txn.value =  recorderCtl.getrecordeddata();
                                   document.siebelTxnRecord.rec_status.value = "0";
                                   document.siebelTxnRecord.rec_errtxt.value = "";
                                }
                                else
                                {
                                   recState = 4;
                                   document.siebelTxnRecord.rec_txn.value = "";
                                   document.siebelTxnRecord.rec_status.value = recorderCtl.getRecordingStatus();
                                   document.siebelTxnRecord.rec_errtxt.value = recorderCtl.errmsg;
                                   <%!
                                     String errMsg1 = "";
                                   String errMsg2 = "";
                                   %>
                                     switch ( document.siebelTxnRecord.rec_status.value)
                                     {
                                        case 0:
                                          <% errMsg1 =  siebelTxnRecorderData.getRecErrMsg(1); %>
                                             recError = "<%=errMsg1%>";
                                          break;
                                        default:
                                          <% errMsg1 =  siebelTxnRecorderData.getRecErrMsg(100); %>
                                             recError = "<%=errMsg1%>";
                                     }
                                }
                           }
                         }

                              /* Start button handler */
                              function onRecord()
                              {
                                                  var recorderCtl = document.getElementById("recorderCtl");
                                var doRec = false;
                                switch (recState)
                                {
                                   case 0 :
                                     doRec = true;
                                     break;
                                   case 1 :
                                     showAlert(1);
                                     break;
                                   case 2 :
                                     showAlert(2);
                                     break;
                                   case 4 :
                                     showAlert(7);
                                     recState = 0;
                                     recError = "";
                                     doRec = true;
                                     break;

                                }
                                if (doRec)
                                {
                                   recState = 1;
                                   recorderCtl.startRecording();
                                }
                              }


                              /* Stop button handler */
                              function onStop()
                              {
                                                  var recorderCtl = document.getElementById("recorderCtl");
                                if (recState == 1)
                                {
                                   recState = 2;
                                   recorderCtl.stopRecording();
                                   checkRecording(); /* start polling for the results */
                                }
                              }
                              /* Verify button handler */
                              function onVerify()
                              {
                                switch (recState)
                                {
                                   case 0 :
                                     showAlert(3);
                                     break;
                                   case 1 :
                                     showAlert(4);
                                     break;
                                   case 2 :
                                     showAlert(5);
                                     break;
                                   case 3 :
                                    Play();
                                     break;
                                   case 4 :
                                     showAlert(6);
                                     break;
                                }
                              }

                             function Play()
                                              {
                                                  var recorderCtl = document.getElementById("recorderCtl");
                                                  if (recorderCtl != null)
                                                  {
                                                        var val=document.siebelTxnRecord.rec_txn.value;
                                                        var timeval=30000;
                                                        recorderCtl.PlayRecording(val,timeval);
                                                  }
                                                }

                              function flipButtons() {

                                if (recordingStatus==true)
                                {
                                   onStop();
                                   hideStop();
                                   showStart();
                                   recordingStatus=false;
                                }
                                else if(recState ==3)
                                {
                                   <%! String confirmMsg = "";%>
                                     <% confirmMsg = siebelTxnRecorderData.getRecConfirmMsg(); %>
                                     if (confirm("<%=confirmMsg%>"))
                                     {
                                        recState = 0;
                                        onRecord();
                                        showStop();
                                        hideStart();
                                        hideVerify();
                                        recordingStatus=true;
                                        return true;
                                     }
                                     else
                                     {
                                        showStart();
                                        hideStop();
                                        recordingStatus=false;
                                        return false;
                                     }
                                }
                                else
                                {
                                   onRecord();
                                   showStop();
                                   hideStart();
                                   recordingStatus=true;
                                }
                              }

                              function hideStop()
                              {
                                var stopButton = document.getElementById("siebelTxnRecordStopButton");
                                if (stopButton != null)
                                {
                                   stopButton.style.display = "none";
                                }
                              }

                              function showStop()
                              {
                                var stopButton = document.getElementById("siebelTxnRecordStopButton");
                                if (stopButton != null)
                                {
                                   stopButton.style.display = "inline";
                                }
                              }

                              function hideStart()
                              {
                                var startButton = document.getElementById("siebelTxnRecordStartButton");
                                if (startButton != null)
                                {
                                   startButton.style.display = "none";
                                }
                              }

                              function showStart()
                              {
                                var startButton = document.getElementById("siebelTxnRecordStartButton");
                                if (startButton != null)
                                {
                                   startButton.style.display = "inline";
                                }
                              }
                                             function continueSavingSiebelRecording() {
                                   var recorderCtl = document.getElementById("recorderCtl");
                                if (recState == 1)
                                    recorderCtl.stopRecording();
                                               setTimeout("submitForm('siebelTxnRecord',true,{'event':'siebelSaveRecording'})", 3000);
                                             }
     
                                           function cancelSavingSiebelRecording() {
                                                var recorderCtl = document.getElementById("recorderCtl");
                                                   document.recorderCtl.command="CANCEL";
                                 if (recState == 1)
                                                      recorderCtl.stopRecording();

                                                submitForm('siebelTxnRecord',true,{'event':'siebelCancelRecording'});
                                             }

                                hideStop();

                    </script>
        </uix:rawText>
      </uix:rowLayout>
          </uix:tableLayout>

        </uix:form>
      </uix:dataScope> 
    </uix:body>
  </uix:document>
</uix:renderingContext> 
