<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oemjsp" %>
<%@ taglib uri="http://xmlns.oracle.com/oem" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import='oracle.sysman.eml.webapp.e2e.data.TraceConstants'%>
<%@ page import='oracle.sysman.eml.chronos.WebsiteConstants'%>
<%@ page import='oracle.sysman.eml.siebeltt.data.SiebelTxnRecorderData'%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import='oracle.sysman.eml.siebeltt.SiebelTestTypePageNames'%>


<jsp:useBean
    id="showResults"
    scope="request"
    type="oracle.sysman.eml.siebeltt.data.ShowResultData"/>

<uix:renderingContext id="renderingContext">
<oemjsp:setURLEncoder id="renderingContext"/>
<uix:bundle name="websiteResourceBundle"
		class="oracle.sysman.resources.website.WebsiteResourceBundle"/>
<uix:bundle name="commonResourceBundle"
		class="oracle.sysman.resources.CommonResourceBundle"/>

<uix:document>
<uix:head titleBinding="_emSDK_PageTitle@servletRequest"/>

<%@ include file="/oemTitle.jspf" %>
<uix:body onLoad="onLoadPlay()">
	<uix:form name="showResultsForm"  method="POST"  destinationBinding="<%=SiebelTestTypePageNames.SIEBEL_TXN_SIEBEL_POST_PAGE%>">
		<uix:pageLayout>
		   <%@ include file="/enablePPR.jspf" %>
		   <%@ include file="/oemGlobal.jspf" %>
		   <%@ include file="/oemNoscript.jspf" %>
		   <uix:stackLayout>
			 <uix:contents>
				<uix:spacer height="5"/>
			   	  <uix:header textBinding="header@showResults@servletRequest">
				   <uix:spacer height="10"/>
				   <uix:formValue name="<%=TraceConstants.PB_RESULTS_DATA_PARAM%>" value=""/>
				   <uix:formValue name="<%=TraceConstants.TXN_ID_PARAM%>"
							  valueBinding="txnID@showResults@servletRequest"/>          
				   <%--This is for the details fo the transaction--%> 
				   <uix:formValue  name="txnDetails"
						  valueBinding="txnDetails@servletRequest" />

				   <uix:formValue name="timeoutduration"
						  valueBinding="timeoutduration@servletRequest" /> 

				   <uix:button id="siebelTxnPlayBackButton"
								textBinding="RESULTS@commonResourceBundle"
								onClick="showResults()"/>
			 	   </uix:header>
		   </uix:contents>
		</uix:stackLayout>
	        <uix:tableLayout>
 		    <uix:rawText>
	 			  <script  language="JavaScript">
 					function onLoadPlay()
 					{
 						<%!
 							   SiebelTxnRecorderData txnRecorderData; 
 						%>
 						<%
 							   txnRecorderData = showResults.getTxnRecorderData(); 
	 					%>
 						var val=document.showResultsForm.txnDetails.value;
 						var timeval=document.showResultsForm.timeoutduration.value;
	 					recorderCtl.PlayRecording(val,timeval);
 					}
 
 					function showResults()
	 				{
 						document.showResultsForm.pbPostData.value = recorderCtl.getStatusandMetrics();
 						submitForm('showResultsForm',true,{'event':'pbResults'});
 					}
	 			  </script>
			</uix:rawText>
	        </uix:tableLayout>

		<uix:contentFooter>
			  <uix:pageButtonBar/>
		</uix:contentFooter>
		
		</uix:pageLayout>
   	  </uix:form>
    </uix:body>
</uix:document>
</uix:renderingContext>
<uix:spacer height="1000"/>
      <%!
        String objectId= null;
        String codeBase = null;
        StringBuffer strBuf = null;
      %>

      <%
        objectId = txnRecorderData.getRecorderObjID();
        codeBase = txnRecorderData.getCodeBase();
        strBuf = new StringBuffer();

        strBuf.append( "<OBJECT id=recorderCtl width=250 height=115 top=0 left=0\n");
        strBuf.append( "    classid=\""+ objectId +"\" codebase=\""+codeBase+"\">" );
        strBuf.append( "  <PARAM NAME=\"visible\" VALUE=\"FALSE\">\n");
        strBuf.append( "</OBJECT>\n");

        System.out.println( strBuf.toString() );

        out.println( strBuf.toString() );
      %>


