<%--
 * Copyright (c) 2004, 2005, Oracle. All rights reserved.  
 *
 *  NAME
 *    groupStorageErrors.jsp
 *
 *  NOTES
 *    shows collection errors and storage mapping issues for groups.
 *  
 * MODIFIED
 *    ajere    05/26/05 - Accessibility changes 
 *    rmenon   12/03/04 - sorting/blocking consolidation
 *    rmenon   11/11/04 - 
 *    rmenon   10/26/04 - removed dummy message
 *    rmenon   10/09/04 - rmenon_storage_group_ui_and_sql_code_refactor
 *    rmenon   09/20/04 - 
 *    rmenon   09/08/04 - 
 *    rmenon   08/02/04 - rmenon_storage_refresh_error_page_checkin
 *    rmenon   08/02/04 - Creation
--%>

<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.cabo.ui.UIConstants' %>
<%@ page import='oracle.sysman.emSDK.svc.ServiceUtil' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageUIConstants' %>
<%@ page import='oracle.sysman.eml.ecm.ui.SimpleDataObjectList' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageUIConstants' %>

<%@ include file="/sdk/oemTop.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResource"
    class="oracle.sysman.resources.CommonResourceBundle"/>

  <%--
   * resource bundles used by this page.
  --%>

  <uix:bundle name="storageResource"
    class="oracle.sysman.eml.storage.resources.StorageResourceBundle"/>

  <uix:bundle name="sdkResource"
    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@errorPageViewBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>

      <uix:pageLayout titleBinding="RELATED_ERRORS@storageResource">
        <%@ include file="/oemGlobal.jspf" %>

        <uix:rawText textBinding="debugMessage@servletRequest"/>
        <uix:rawText textBinding="errorMessage@servletRequest"/>

        <uix:form name="groupStorageErrorPageForm" method="GET">
          <uix:tableLayout width="100%" >
            <uix:rowLayout width="90%" hAlign="right" >
              <uix:cellFormat width="50%" hAlign="right">
                <uix:rowLayout hAlign="right" >
                  <uix:styledText styleClass="OraTipText" 
                    textBinding="COLL_FROM_TARGET@sdkResource"/>
                  <uix:spacer width="5"/>
                  <uix:styledText styleClass="OraTipLabel" 
                    textBinding="collectionTimestamp@errorPageViewBean@servletRequest"/>
                  <uix:spacer width="8"/>
                    <uix:submitButton name="event"
                       value="refreshGroupStorage"
                       textBinding="REFRESH_JOB@storageResource" />
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
          <%@ include file="../common/storageMetricCollectionErrors.jspf" %>
          <uix:header textBinding="STORAGE_MAPPING_ISSUES_HEADER@storageResource">
            <uix:tableLayout cellPadding="0" width="90%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="center" >
                  <uix:table name="storageMappingIssuesTable"
                    id="storageMappingIssuesTableID"
                    tableDataBinding="rows@storageMappingIssuesTable@servletRequest"
                    columnHeaderDataBinding="storageMappingIssuesTableColumnHeaders@servletRequest"
                    blockSizeBinding="size@rows@storageMappingIssuesTable@servletRequest"
                    maxValueBinding="max@rows@storageMappingIssuesTable@servletRequest"
                    valueBinding="start@rows@storageMappingIssuesTable@servletRequest"
                    minValue="1"
                    width="100%"
                    alternateTextBinding= "NO_ITEMS_FOUND@sdkResource"
                    formSubmitted="true"
                    showAll="yes"
                    summaryBinding="STORAGE_MAPPING_ISSUES_HEADER@storageResource">
                  
                    <uix:tableFormat tableBanding="rowBanding"/>
                  
                    <uix:columnHeaderStamp>
                      <uix:sortableHeader textBinding="text" 
                        sortableBinding="sortable"
                       />
            
                    </uix:columnHeaderStamp>
                    <uix:contents>
                      <uix:styledText textBinding="target_name"/>
                      <uix:styledText textBinding="storageMappingMessage"/>
                      <uix:styledText textBinding="storageMappingAction"/>
                      <uix:styledText textBinding="collection_timestamp"/>
                    </uix:contents>
                  </uix:table>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
          <uix:header textBinding="HOSTS_WITH_MISSING_SNAPSHOTS@storageResource">
            <uix:tableLayout cellPadding="0" width="50%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" >
                  <uix:table name="hostsWithMissingSnapshot"
                   id="hostsWithMissingSnapshotID"
                   tableDataBinding="rows@hostsWithMissingSnapshot@servletRequest"
                   columnHeaderDataBinding="hostsWithMissingSnapshotColumnHeaders@servletRequest"
                   blockSizeBinding="size@rows@hostsWithMissingSnapshot@servletRequest"
                   maxValueBinding="max@rows@hostsWithMissingSnapshot@servletRequest"
                   valueBinding="start@rows@hostsWithMissingSnapshot@servletRequest"
                   minValue="1"
                   width="80%"
                   alternateTextBinding= "NO_ITEMS_FOUND@sdkResource"
                   formSubmitted="true"
                   showAll="yes"
                   summaryBinding="HOSTS_WITH_MISSING_SNAPSHOTS@storageResource">
                 
                   <uix:tableFormat tableBanding="rowBanding"/>
                 
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" 
                       sortableBinding="sortable"
                      />
           
                   </uix:columnHeaderStamp>
                   <uix:contents>
                     <uix:link textBinding="target_name"
                       destinationBinding="homePageURL" />
                   </uix:contents>
           
                  </uix:table>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
          <uix:header textBinding="HOSTS_WITH_NO_STORAGE_COLLECTION_DEFINED@storageResource">
            <uix:tableLayout cellPadding="0" width="50%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" >
                  <uix:table name="hostsWithNoCollectionDefined"
                   id="hostsWithNoCollectionDefinedID"
                   tableDataBinding="rows@hostsWithNoCollectionDefined@servletRequest"
                   columnHeaderDataBinding="hostsWithNoCollectionDefinedColumnHeaders@servletRequest"
                   blockSizeBinding="size@rows@hostsWithNoCollectionDefined@servletRequest"
                   maxValueBinding="max@rows@hostsWithNoCollectionDefined@servletRequest"
                   valueBinding="start@rows@hostsWithNoCollectionDefined@servletRequest"
                   minValue="1"
                   width="80%"
                   alternateTextBinding= "NO_ITEMS_FOUND@sdkResource"
                   formSubmitted="true"
                   showAll="yes"
                   summaryBinding="HOSTS_WITH_NO_STORAGE_COLLECTION_DEFINED@storageResource">
                 
                   <uix:tableFormat tableBanding="rowBanding"/>
                 
                   <uix:columnHeaderStamp>
                     <uix:sortableHeader textBinding="text" 
                       sortableBinding="sortable"
                      />
           
                   </uix:columnHeaderStamp>
                   <uix:contents>
                     <uix:link textBinding="target_name"
                       destinationBinding="homePageURL" />
                   </uix:contents>
           
                  </uix:table>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

