<%--
 * Copyright (c) 2004, 2005, Oracle. All rights reserved.  
 *
 *  NAME
 *    groupStorageHistory.jsp
 *
 *  DESCRIPTION
 *    Has the UI contents of the group storage history details.
 *
 *  NOTES
 *
 *    We need to use jsp:include and buildTree to include the 
 *    pages - I tried to implement this on june 17th but it did not
 *    work for me for some reason (gave blank page.)
 * MODIFIED
 *    ajere    08/09/05 - Fix bug# 4222327 
 *    ajere    07/19/05 - Fix bug# 4493757 
 *    ajere    07/14/05 - Fix bug# 4429794 
 *    ajere    05/26/05 - Accessibility changes 
 *    rmenon   03/23/05 - 
 *    rmenon   03/15/05 - 
 *    rmenon   02/25/05 - 
 *    rmenon   02/18/05 - remove debug messages
 *    rmenon   01/03/05 - 
 *    rmenon   12/03/04 - 
 *    rmenon   11/11/04 - 
 *    rmenon   10/15/04 - 
 *    rmenon   10/09/04 - rmenon_storage_group_ui_and_sql_code_refactor
 *    rmenon   10/04/04 - 
 *    rmenon   08/10/04 - 
 *    rmenon   08/02/04 - converted tab to drop down
 *    rmenon   06/28/04 - rmenon_storage_disks_tab_ui
 *    rmenon   06/10/04 - Created
--%>

<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import='oracle.cabo.ui.UIConstants' %>
<%@ page import='java.text.SimpleDateFormat' %>
<%@ page import='oracle.sysman.emSDK.svc.ServiceUtil' %>
<%@ page import='oracle.sysman.eml.ecm.ui.SimpleDataObjectList' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageUIConstants' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageHistoryMgmtLayerViewBean' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageHistorySummaryViewBean' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageHistoryDisksViewBean' %>
<%@ page import='oracle.sysman.eml.storage.common.StorageHistoryApplicationsViewBean' %>
<%@ page import='oracle.sysman.eml.storage.group.GroupStorageHistoryViewBean' %>

<%@ page import="oracle.cabo.ui.partial.PartialPageContext"%>
<%@ page import="oracle.cabo.ui.partial.PartialPageUtils"%>
<%@ page import="oracle.cabo.servlet.ui.partial.PartialPageEventUtils"%>


<%@ include file="/sdk/oemTop.jspf" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <%--
   * resource bundles used by this page.
  --%>
<%
  GroupStorageHistoryViewBean historyViewBean = 
    (GroupStorageHistoryViewBean)
    request.getAttribute( "historyViewBean" );
  String selectedHistoryType = historyViewBean.getSelectedHistoryType();
  String storageHistoryEnabled = historyViewBean.getStorageHistoryEnabledFlag();
  Object confirmationMessage = request.getAttribute( 
    StorageUIConstants.CONFIRM_MESSAGE_TABLE_KEY );
%>
  <uix:bundle name="storageResource"
    class="oracle.sysman.eml.storage.resources.StorageResourceBundle"/>
  <uix:bundle name="sdkResource"
    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResource"
    class="oracle.sysman.resources.CommonResourceBundle"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@historyViewBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoadBinding="focusJavaScript@historyViewBean@servletRequest">

      <uix:pageLayout >
        <%@ include file="/oemGlobal.jspf" %>

        <uix:rawText textBinding="debugMessage@servletRequest"/>
        <uix:rawText textBinding="errorMessage@servletRequest"/>

        <uix:form name="groupStorageHistoryForm" method="GET">
          <oem:messageBox messageType="confirmation"
            errorTableBinding="confirmation@servletRequest"
            titleTextKey="titleText" mainTextKey="mainText"/>
          <%
            if( StorageUIConstants.NO.equals( storageHistoryEnabled ) &&
                confirmationMessage == null ) 
            {
          %>
              <uix:messageBox messageType="information"
                messageBinding="GROUP_STORAGE_HISTORY_IS_DISABLED_MESSAGE@storageResource" />
          <%}%>
          <uix:header textBinding="HISTORY@storageResource"/>
          <uix:tableLayout width="100%">
            <uix:rowLayout width="100%" hAlign="right" >
              <uix:switcher childNameBinding="storageHistoryEnabledFlag@historyViewBean@servletRequest">
                <uix:case name="N">
                  <uix:cellFormat width="50%" hAlign="right">
                    <uix:rowLayout hAlign="right" >
                      <uix:submitButton name="event"
                         value="cfmHistEnable"
                         textBinding="ENABLE_GROUP_STORAGE_HISTORY@storageResource" />
                    </uix:rowLayout>
                  </uix:cellFormat>
                </uix:case>
                <uix:case name="Y">
                  <uix:cellFormat width="50%" hAlign="right">
                    <uix:rowLayout hAlign="right" >
                      <uix:submitButton name="event"
                         value="cfmHistDisable"
                         textBinding="DISABLE_GROUP_STORAGE_HISTORY@storageResource" />
                    </uix:rowLayout>
                  </uix:cellFormat>
                </uix:case>
              </uix:switcher>
            </uix:rowLayout>
          </uix:tableLayout>
          <uix:tableLayout>
            <uix:stackLayout>
              <uix:spacer height="10"/>
              <uix:tableLayout cellPadding="0" width="100%">
                <uix:rowLayout width="100%">
                  <uix:cellFormat width="80%" hAlign="right">
                      <uix:styledText styleClass="OraTipText" 
                        textBinding="LATEST_FROM_TARGET@sdkResource"/>
                      <uix:spacer width="5"/>
                    <%
                      if ( StorageUIConstants.SUMMARY.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historySummaryViewBean@servletRequest"/>
                    <%
                      }
                      else if ( StorageUIConstants.DB.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historyApplicationsViewBean@servletRequest"/>
                    <%}
                      else if ( StorageUIConstants.LOCAL_FS.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historyApplicationsViewBean@servletRequest"/>
                    <%}
                      else if ( StorageUIConstants.WRITEABLE_NFS.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historyApplicationsViewBean@servletRequest"/>
                    <%}
                      else if ( StorageUIConstants.DISKS.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historyDisksViewBean@servletRequest"/>
                    <%}
                      else if ( StorageUIConstants.ASM.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historyMgmtLayerViewBean@servletRequest"/>
                    <%}
                      else if ( StorageUIConstants.VOLUMES.equals( selectedHistoryType ) )
                      {
                    %>
                      <uix:styledText styleClass="OraTipLabel" 
                        textBinding="collectionTimestamp@historyMgmtLayerViewBean@servletRequest"/>
                    <%}%>
                  </uix:cellFormat>
                  <uix:cellFormat >
                    <uix:spacer width="5" />
                  </uix:cellFormat>
                  <uix:cellFormat width="10%" hAlign="right" >
                    <uix:styledText textBinding="VIEW@storageResource"
                                    styleClass="OraPromptText"
                                    labeledNodeId="viewPeriodChoice"/>
                  </uix:cellFormat>
                  <uix:cellFormat >
                    <uix:spacer width="5" />
                  </uix:cellFormat>
                  <uix:cellFormat width = "10%" hAlign="right" >
                    <uix:choice name="viewPeriodChoice"
                                id="viewPeriodChoice"
                                onChange="submitForm('groupStorageHistoryForm', true, {'event':'viewHistoryByResource'})"
                                selectedValueBinding="selectedPeriod@historyViewBean@servletRequest" >
                      <uix:contents childDataBinding="periodSelector@historyViewBean@servletRequest">
                        <uix:option textBinding="text"
                                    valueBinding="value"
                                    renderedBinding="rendered"/>
                      </uix:contents>
                     </uix:choice>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat width="80%" hAlign="left" >
                    <uix:styledText textBinding="HISTORY_OF@storageResource"
                                    styleClass="OraPromptText"
                                    labeledNodeId="viewStorageChoice"/>
                    <uix:choice name="viewStorageChoice"
                                id="viewStorageChoice"
                                onChange="submitForm('groupStorageHistoryForm', true, {'event':'viewHistoryOf'})"
                                selectedValueBinding="selectedHistoryTypeText@historyViewBean@servletRequest" >
                      <uix:contents childDataBinding="historyTypeSelector@historyViewBean@servletRequest">
                        <uix:option textBinding="text"
                          renderedBinding="rendered"/>
                      </uix:contents>
                     </uix:choice>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <%
                if ( StorageUIConstants.SUMMARY.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="groupStorageHistorySummary.jspf" %>
              <%
                }
                else if ( StorageUIConstants.DB.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="groupStorageHistoryDatabases.jspf" %>
              <%}
                else if ( StorageUIConstants.LOCAL_FS.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="groupStorageHistoryLocalFS.jspf" %>
              <%}
                else if ( StorageUIConstants.WRITEABLE_NFS.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="groupStorageHistoryNFS.jspf" %>
              <%}
                else if ( StorageUIConstants.DISKS.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="groupStorageHistoryDisks.jspf" %>
              <%}
                else if ( StorageUIConstants.ASM.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="groupStorageHistoryAsm.jspf" %>
              <%}
                else if ( StorageUIConstants.VOLUMES.equals( selectedHistoryType ) )
                {
              %>
                  <%@ include file="groupStorageHistoryVolumes.jspf" %>
              <%}
                else
                {
              %>
                  <uix:spacer height="10"/>
                  <uix:styledText styleClass="OraDataText"
                    text="Not implemented yet"/>
              <%}%>
              <uix:spacer height="10"/>
            </uix:stackLayout>
          </uix:tableLayout>
        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

